/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.runtime.swing.tree;

import io.ultreia.java4all.util.Enumerations;
import java.awt.Color;
import java.util.Collections;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Stack;
import java.util.stream.Stream;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.UIDefaults;
import javax.swing.tree.TreeNode;
import org.jdesktop.swingx.painter.Painter;

public class JTrees {
    public static void initUI(JScrollPane selectedTreePane, JTree tree) {
        UIDefaults defaults = new UIDefaults();
        Painter painter = (g, c, w, h) -> g.fillRect(0, 0, w, h);
        defaults.put("Tree:TreeCell[Enabled+Selected].backgroundPainter", painter);
        defaults.put("Tree:TreeCell[Enabled+Focused].backgroundPainter", painter);
        defaults.put("Tree:TreeCell[Focused+Selected].backgroundPainter", painter);
        tree.putClientProperty("Nimbus.Overrides", defaults);
        selectedTreePane.getViewport().setBackground(Color.WHITE);
    }

    public static Stream<TreeNode> preorderStream(TreeNode node) {
        return JTrees.preorderStream(node, false);
    }

    public static Stream<TreeNode> preorderStream(TreeNode node, boolean parallel) {
        return Enumerations.stream((Enumeration)new PreorderEnumeration(node), (boolean)parallel);
    }

    public static Stream<TreeNode> postorderStream(TreeNode node) {
        return JTrees.postorderStream(node, false);
    }

    public static Stream<TreeNode> postorderStream(TreeNode node, boolean parallel) {
        return Enumerations.stream((Enumeration)new PostorderEnumeration(node), (boolean)parallel);
    }

    public static Stream<TreeNode> breadthFirstStream(TreeNode node) {
        return JTrees.breadthFirstStream(node, false);
    }

    public static Stream<TreeNode> breadthFirstStream(TreeNode node, boolean parallel) {
        return Enumerations.stream((Enumeration)new BreadthFirstEnumeration(node), (boolean)parallel);
    }

    private static final class BreadthFirstEnumeration
    implements Enumeration<TreeNode> {
        private Queue queue;

        public BreadthFirstEnumeration(TreeNode rootNode) {
            Objects.requireNonNull(rootNode);
            this.queue = new Queue();
            this.queue.enqueue(Enumerations.singleton((Object)rootNode));
        }

        @Override
        public boolean hasMoreElements() {
            return !this.queue.isEmpty() && this.queue.peek().hasMoreElements();
        }

        @Override
        public TreeNode nextElement() {
            Enumeration<? extends TreeNode> children;
            Enumeration currentEnumeration = this.queue.peek();
            TreeNode node = (TreeNode)currentEnumeration.nextElement();
            if (!currentEnumeration.hasMoreElements()) {
                this.queue.pop();
            }
            if ((children = node.children()).hasMoreElements()) {
                this.queue.enqueue(children);
            }
            return node;
        }

        public final class Queue {
            QNode head;
            QNode tail;

            public void enqueue(Enumeration anObject) {
                if (this.head == null) {
                    this.head = this.tail = new QNode(anObject, null);
                } else {
                    this.tail = this.tail.next = new QNode(anObject, null);
                }
            }

            public void pop() {
                if (this.head == null) {
                    throw new NoSuchElementException("No more elements");
                }
                QNode oldHead = this.head;
                this.head = this.head.next;
                if (this.head == null) {
                    this.tail = null;
                } else {
                    oldHead.next = null;
                }
            }

            public Enumeration peek() {
                if (this.head == null) {
                    throw new NoSuchElementException("No more elements");
                }
                return this.head.object;
            }

            public boolean isEmpty() {
                return this.head == null;
            }

            final class QNode {
                public Enumeration object;
                public QNode next;

                public QNode(Enumeration object, QNode next) {
                    this.object = object;
                    this.next = next;
                }
            }
        }
    }

    private static final class PostorderEnumeration
    implements Enumeration<TreeNode> {
        private TreeNode root;
        private Enumeration<TreeNode> children;
        private Enumeration<TreeNode> subtree;

        public PostorderEnumeration(TreeNode rootNode) {
            Objects.requireNonNull(rootNode);
            this.root = rootNode;
            this.children = this.root.children();
            this.subtree = Collections.emptyEnumeration();
        }

        @Override
        public boolean hasMoreElements() {
            return this.root != null;
        }

        @Override
        public TreeNode nextElement() {
            TreeNode returnValue;
            if (this.subtree.hasMoreElements()) {
                returnValue = this.subtree.nextElement();
            } else if (this.children.hasMoreElements()) {
                this.subtree = new PostorderEnumeration(this.children.nextElement());
                returnValue = this.subtree.nextElement();
            } else {
                returnValue = this.root;
                this.root = null;
            }
            return returnValue;
        }
    }

    private static final class PreorderEnumeration
    implements Enumeration<TreeNode> {
        private final Stack<Enumeration> stack = new Stack();

        public PreorderEnumeration(TreeNode rootNode) {
            this.stack.push(Enumerations.singleton((Object)rootNode));
        }

        @Override
        public boolean hasMoreElements() {
            return !this.stack.empty() && this.stack.peek().hasMoreElements();
        }

        @Override
        public TreeNode nextElement() {
            Enumeration<? extends TreeNode> children;
            Enumeration currentEnumeration = this.stack.peek();
            TreeNode node = (TreeNode)currentEnumeration.nextElement();
            if (!currentEnumeration.hasMoreElements()) {
                this.stack.pop();
            }
            if ((children = node.children()).hasMoreElements()) {
                this.stack.push(children);
            }
            return node;
        }
    }
}

