/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.runtime.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ReflectUtil {
    private static final Logger log = LogManager.getLogger(ReflectUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Method getDeclaredMethod(Class<?> klass, String methodName, boolean strict, Object ... arguments) throws IllegalArgumentException {
        Method method;
        HashSet classes = new HashSet();
        try {
            method = ReflectUtil.getDeclaredMethod(klass, methodName, classes, arguments);
        }
        finally {
            if (log.isDebugEnabled()) {
                log.debug("Inspected classes : " + classes);
            }
            classes.clear();
        }
        if (method == null && strict) {
            throw new IllegalArgumentException("could not find method " + methodName + " on type " + klass.getName());
        }
        return method;
    }

    protected static Method getDeclaredMethod(Class<?> klass, String methodName, Set<Class<?>> visitedClasses, Object ... arguments) {
        if (visitedClasses.contains(klass)) {
            return null;
        }
        visitedClasses.add(klass);
        Method method = null;
        for (Method m : klass.getDeclaredMethods()) {
            Class<?>[] types;
            if (!methodName.equals(m.getName()) || arguments.length != (types = m.getParameterTypes()).length) continue;
            Object[] prototype = m.getParameterTypes();
            if (log.isDebugEnabled()) {
                log.debug("Found a method with same parameters size : " + m.getName() + " : " + Arrays.toString(prototype));
            }
            int index = 0;
            boolean parametersMatches = true;
            for (Object argument : arguments) {
                Class<?> type = prototype[index++];
                if (argument == null) continue;
                Class<?> runtimeType = argument.getClass();
                if (log.isDebugEnabled()) {
                    log.debug("Test parameter [" + (index - 1) + "] : " + type + " vs  " + runtimeType);
                }
                if ((type = ReflectUtil.boxType(type)).equals(runtimeType = ReflectUtil.boxType(runtimeType)) || type.isAssignableFrom(runtimeType)) continue;
                parametersMatches = false;
                if (!log.isDebugEnabled()) break;
                log.debug("Types are not matching.");
                break;
            }
            if (!parametersMatches) break;
            method = m;
            break;
        }
        if (method == null && klass.getSuperclass() != null) {
            method = ReflectUtil.getDeclaredMethod(klass.getSuperclass(), methodName, visitedClasses, arguments);
        }
        if (method == null) {
            Class<?> anInterface;
            Class<?>[] interfaces;
            Class<?>[] classArray = interfaces = klass.getInterfaces();
            int n = classArray.length;
            for (int i = 0; i < n && (method = ReflectUtil.getDeclaredMethod(anInterface = classArray[i], methodName, visitedClasses, arguments)) == null; ++i) {
            }
        }
        return method;
    }

    public static Class<?> boxType(Class<?> type) {
        if (!type.isPrimitive()) {
            return type;
        }
        if (Boolean.TYPE.equals(type)) {
            return Boolean.class;
        }
        if (Character.TYPE.equals(type)) {
            return Character.class;
        }
        if (Byte.TYPE.equals(type)) {
            return Byte.class;
        }
        if (Short.TYPE.equals(type)) {
            return Short.class;
        }
        if (Integer.TYPE.equals(type)) {
            return Integer.class;
        }
        if (Long.TYPE.equals(type)) {
            return Long.class;
        }
        if (Float.TYPE.equals(type)) {
            return Float.class;
        }
        if (Double.TYPE.equals(type)) {
            return Double.class;
        }
        if (Void.TYPE.equals(type)) {
            return Void.class;
        }
        return type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <A extends Annotation> Map<Field, A> getFieldAnnotation(Class<?> objectClass, Class<A> annotationClass, boolean deepVisit) {
        HashMap result = new HashMap();
        HashSet visitedClasses = new HashSet();
        try {
            ReflectUtil.getFieldAnnotation(objectClass, annotationClass, deepVisit, visitedClasses, result);
        }
        finally {
            visitedClasses.clear();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <A extends Annotation> Map<Method, A> getMethodAnnotation(Class<?> objectClass, Class<A> annotationClass, boolean deepVisit) {
        HashMap result = new HashMap();
        HashSet visitedClasses = new HashSet();
        try {
            ReflectUtil.getMethodAnnotation(objectClass, annotationClass, deepVisit, visitedClasses, result);
        }
        finally {
            visitedClasses.clear();
        }
        return result;
    }

    protected static <A extends Annotation> void getFieldAnnotation(Class<?> objectClass, Class<A> annotationClass, boolean deepVisit, Set<Class<?>> visitedClasses, Map<Field, A> result) {
        if (visitedClasses.contains(objectClass) || Object.class.equals(objectClass)) {
            return;
        }
        visitedClasses.add(objectClass);
        for (Field field : objectClass.getDeclaredFields()) {
            A annotation = field.getAnnotation(annotationClass);
            if (annotation == null) continue;
            result.put(field, annotation);
        }
        if (deepVisit) {
            Class<?>[] interfaces;
            Class<?> superclass = objectClass.getSuperclass();
            if (superclass != null) {
                ReflectUtil.getFieldAnnotation(superclass, annotationClass, deepVisit, visitedClasses, result);
            }
            for (Class<?> anInterface : interfaces = objectClass.getInterfaces()) {
                ReflectUtil.getFieldAnnotation(anInterface, annotationClass, deepVisit, visitedClasses, result);
            }
        }
    }

    protected static <A extends Annotation> void getMethodAnnotation(Class<?> objectClass, Class<A> annotationClass, boolean deepVisit, Set<Class<?>> visitedClasses, Map<Method, A> result) {
        if (visitedClasses.contains(objectClass) || Object.class.equals(objectClass)) {
            return;
        }
        visitedClasses.add(objectClass);
        for (Method method : objectClass.getDeclaredMethods()) {
            A annotation = method.getAnnotation(annotationClass);
            if (annotation == null) continue;
            result.put(method, annotation);
        }
        if (deepVisit) {
            Class<?>[] interfaces;
            Class<?> superclass = objectClass.getSuperclass();
            if (superclass != null) {
                ReflectUtil.getMethodAnnotation(superclass, annotationClass, deepVisit, visitedClasses, result);
            }
            for (Class<?> anInterface : interfaces = objectClass.getInterfaces()) {
                ReflectUtil.getMethodAnnotation(anInterface, annotationClass, deepVisit, visitedClasses, result);
            }
        }
    }
}

