/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.runtime.context;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.jaxx.runtime.JAXXContext;
import org.nuiton.jaxx.runtime.JAXXObject;
import org.nuiton.jaxx.runtime.JAXXUtil;
import org.nuiton.jaxx.runtime.context.JAXXContextEntryDef;

public class DefaultJAXXContext
implements JAXXContext {
    protected static final JAXXContextEntryDef<JAXXContext> PARENT_CONTEXT_ENTRY = JAXXUtil.newContextEntryDef(JAXXContext.class);
    private static final Log log = LogFactory.getLog(DefaultJAXXContext.class);
    protected JAXXContext parentContext;
    protected final Map<JAXXContextEntryDef<?>, Object> data = new HashMap();

    public <T> void setContextValue(T o) {
        this.setContextValue(o, null);
    }

    public <T> void setContextValue(T o, String name) {
        if (name == null && PARENT_CONTEXT_ENTRY.accept2(o.getClass(), null)) {
            this.setParentContext((JAXXContext)o);
            return;
        }
        JAXXContextEntryDef<?> entry = this.getKey(name, o.getClass());
        Object oldValue = this.remove0(o.getClass(), name);
        if (oldValue != null && log.isDebugEnabled()) {
            log.debug((Object)("remove value " + oldValue.getClass() + " for " + entry));
        }
        this.data.put(entry, o);
    }

    public <T> T getContextValue(Class<T> clazz) {
        return this.getContextValue(clazz, null);
    }

    public <T> T getContextValue(Class<T> clazz, String name) {
        if (this.parentContext != null && this.parentContext.getClass().equals(clazz) || PARENT_CONTEXT_ENTRY.accept(clazz, name)) {
            return (T)this.getParentContext();
        }
        for (Map.Entry<JAXXContextEntryDef<?>, Object> entry : this.data.entrySet()) {
            if (!entry.getKey().accept(clazz, name)) continue;
            return (T)entry.getValue();
        }
        if (JAXXContext.class.equals(clazz)) {
            return null;
        }
        JAXXContext parent = this.getParentContext();
        if (parent == null) {
            return null;
        }
        return (T)parent.getContextValue(clazz, name);
    }

    public <T> void removeContextValue(Class<T> klazz) {
        this.removeContextValue(klazz, null);
    }

    public <T> void removeContextValue(Class<T> klazz, String name) {
        this.remove0(klazz, name);
    }

    public String[] getKeys(Class<?> klass) {
        ArrayList<String> keys = new ArrayList<String>();
        for (JAXXContextEntryDef<?> key : this.data.keySet()) {
            if (!key.getKlass().equals(klass)) continue;
            keys.add(key.getName());
        }
        return keys.toArray(new String[keys.size()]);
    }

    public void clear() {
        this.data.clear();
    }

    protected JAXXContextEntryDef<?> getKey(String name, Class<?> klass) {
        return JAXXUtil.newContextEntryDef(name, klass);
    }

    protected <T> T remove0(Class<T> klass, String name) {
        if (PARENT_CONTEXT_ENTRY.accept(klass, name)) {
            JAXXContext old = this.getParentContext();
            this.setParentContext(null);
            return (T)old;
        }
        JAXXContextEntryDef<?> entry = this.getEntry(klass, name);
        if (entry != null) {
            return (T)this.data.remove(entry);
        }
        if (JAXXContext.class.equals(klass)) {
            return null;
        }
        JAXXContext parent = this.getParentContext();
        if (parent == null) {
            return null;
        }
        if (parent instanceof DefaultJAXXContext) {
            return ((DefaultJAXXContext)parent).remove0(klass, name);
        }
        return null;
    }

    protected JAXXContextEntryDef<?> getEntry(Class<?> klass, String name) {
        JAXXContextEntryDef<?> entry = null;
        for (JAXXContextEntryDef<?> entryDef : this.data.keySet()) {
            if (!entryDef.accept(klass, name)) continue;
            entry = entryDef;
            break;
        }
        return entry;
    }

    protected JAXXContext getParentContext() {
        return this.parentContext;
    }

    protected void setParentContext(JAXXContext parentContext) {
        if (parentContext instanceof JAXXObject) {
            parentContext = ((JAXXObject)parentContext).getDelegateContext();
        }
        this.parentContext = parentContext;
    }
}

