package org.nuiton.jaxx.runtime.swing;

/*-
 * #%L
 * JAXX :: Runtime
 * %%
 * Copyright (C) 2008 - 2017 Code Lutin, Ultreia.io
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.awt.Color;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.UIDefaults;
import org.jdesktop.swingx.painter.Painter;

/**
 * Created by tchemit on 11/10/17.
 *
 * @author Tony Chemit - dev@tchemit.fr
 */
public class JTrees {

    public static void initUI(JScrollPane selectedTreePane, JTree tree) {

        // customize tree selection colors
        UIDefaults defaults = new UIDefaults();

        Painter<JComponent> painter = (g, c, w, h) -> g.fillRect(0, 0, w, h);
        defaults.put("Tree:TreeCell[Enabled+Selected].backgroundPainter", painter);
        defaults.put("Tree:TreeCell[Enabled+Focused].backgroundPainter", painter);
        defaults.put("Tree:TreeCell[Focused+Selected].backgroundPainter", painter);

        tree.putClientProperty("Nimbus.Overrides", defaults);
        // Fix http://forge.codelutin.com/issues/2781
        selectedTreePane.getViewport().setBackground(Color.WHITE);
    }
}
