/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.runtime.swing;

import com.google.common.collect.ImmutableMap;
import io.ultreia.java4all.lang.Objects2;
import io.ultreia.java4all.lang.TypedGetterProducer;
import io.ultreia.java4all.lang.TypedSetterProducer;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeListener;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.event.SwingPropertyChangeSupport;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.runtime.JAXXObject;
import org.nuiton.jaxx.runtime.swing.JOptionPanes;
import org.nuiton.jaxx.runtime.swing.SwingUtil;

public abstract class ApplicationAction<UI extends JAXXObject>
implements Action,
TypedGetterProducer<ApplicationAction<UI>>,
TypedSetterProducer<ApplicationAction<UI>> {
    private static final Log log = LogFactory.getLog(ApplicationAction.class);
    public static final String ACTION_TYPE = "actionType";
    public static final String EDITOR = "editor";
    private static final String ENABLED = "enabled";
    protected UI ui;
    private String name;
    private String text;
    private String tooltipText;
    private boolean enabled = true;
    private boolean selectedKey;
    private boolean addKeyStrokeToText = true;
    private boolean addMnemonicAsKeyStroke = true;
    private KeyStroke keyStroke;
    private int mnemonic;
    private int displayMnemonicIndexKey = -1;
    private Icon icon;
    private Icon largeIcon;
    protected AbstractButton editor;
    private SwingPropertyChangeSupport changeSupport;
    private static final ImmutableMap<String, Function<ApplicationAction, ?>> GETTERS = ImmutableMap.builder().put((Object)"ActionCommandKey", ApplicationAction::getActionCommandKey).put((Object)"Name", ApplicationAction::getText).put((Object)"ShortDescription", ApplicationAction::getTooltipText).put((Object)"AcceleratorKey", ApplicationAction::getAcceleratorKey).put((Object)"SmallIcon", ApplicationAction::getIcon).put((Object)"SwingLargeIconKey", ApplicationAction::getLargeIcon).put((Object)"MnemonicKey", ApplicationAction::getMnemonic).put((Object)"editor", ApplicationAction::getEditor).put((Object)"SwingSelectedKey", ApplicationAction::isSelectedKey).put((Object)"SwingDisplayedMnemonicIndexKey", ApplicationAction::getDisplayMnemonicIndexKey).build();
    private static final ImmutableMap<String, BiConsumer<ApplicationAction, ?>> SETTERS = ImmutableMap.builder().put((Object)"ActionCommandKey", (e, v) -> e.setName((String)v)).put((Object)"Name", (e, v) -> e.setText((String)v)).put((Object)"ShortDescription", (e, v) -> e.setTooltipText((String)v)).put((Object)"AcceleratorKey", (e, v) -> e.setKeyStroke((KeyStroke)v)).put((Object)"SmallIcon", (e, v) -> e.setIcon((Icon)v)).put((Object)"SwingLargeIconKey", (e, v) -> e.setLargeIcon((Icon)v)).put((Object)"MnemonicKey", (e, v) -> e.setMnemonic((Integer)v)).put((Object)"SwingSelectedKey", (e, v) -> e.setSelectedKey((Boolean)v)).put((Object)"SwingDisplayedMnemonicIndexKey", (e, v) -> e.setDisplayMnemonicIndexKey((Integer)v)).build();

    public static <U extends JAXXObject, A extends ApplicationAction<U>> A init(U ui, AbstractButton editor) {
        Class actionType = (Class)editor.getClientProperty(ACTION_TYPE);
        return actionType == null ? null : (A)ApplicationAction.init(ui, editor, actionType);
    }

    public static <U extends JAXXObject, A extends ApplicationAction<U>> A init(U ui, AbstractButton editor, Class<A> actionType) {
        ApplicationAction action = (ApplicationAction)Objects2.newInstance(actionType);
        log.info((Object)String.format("init action: %s", action.getName()));
        action.setUi(ui);
        action.setEditor(editor);
        action.init();
        return (A)action;
    }

    public static <U extends JAXXObject, A extends ApplicationAction<U>> void run(U ui, Class<A> actionType) {
        A action = ApplicationAction.init(ui, null, actionType);
        ((Runnable)action).run();
    }

    public abstract void init();

    protected abstract void doActionPerformed(ActionEvent var1, UI var2);

    protected ApplicationAction(String label, String shortDescription, String actionIcon, KeyStroke acceleratorKey) {
        this(null, label, shortDescription, actionIcon, acceleratorKey);
    }

    protected ApplicationAction(String actionCommandKey, String label, String shortDescription, String actionIcon, KeyStroke acceleratorKey) {
        this(actionCommandKey, label, shortDescription, actionIcon);
        this.keyStroke = acceleratorKey;
    }

    protected ApplicationAction(String label, String shortDescription, String actionIcon, char acceleratorKey) {
        this(null, label, shortDescription, actionIcon, acceleratorKey);
    }

    protected ApplicationAction(String actionCommandKey, String label, String shortDescription, String actionIcon, char acceleratorKey) {
        this(actionCommandKey, label, shortDescription, actionIcon);
        this.mnemonic = acceleratorKey;
    }

    private ApplicationAction(String actionCommandKey, String label, String shortDescription, String actionIcon) {
        this.name = actionCommandKey == null ? this.getClass().getName() : actionCommandKey;
        this.text = I18n.t((String)label, (Object[])new Object[0]);
        this.tooltipText = I18n.t((String)shortDescription, (Object[])new Object[0]);
        if (actionIcon != null) {
            this.icon = SwingUtil.getUIManagerActionIcon(actionIcon);
        }
    }

    @Override
    public final Object getValue(String key) {
        return this.get(key);
    }

    @Override
    public final void putValue(String key, Object value) {
        this.set(key, value);
    }

    @Override
    public final synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this.changeSupport == null) {
            this.changeSupport = new SwingPropertyChangeSupport(this);
        }
        this.changeSupport.addPropertyChangeListener(listener);
    }

    @Override
    public final synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.changeSupport == null) {
            return;
        }
        this.changeSupport.removePropertyChangeListener(listener);
    }

    @Override
    public final boolean isEnabled() {
        return this.editor == null ? this.enabled : this.editor.isEnabled();
    }

    @Override
    public final void setEnabled(boolean enabled) {
        boolean oldValue = this.isEnabled();
        this.enabled = enabled;
        log.debug((Object)String.format("Action [%s] - enabled? %s \u2192 %s", this.getActionCommandKey(), oldValue, enabled));
        this.firePropertyChange(ENABLED, oldValue, enabled);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.canExecuteAction(e)) {
            this.doActionPerformed(e, this.ui);
        }
    }

    protected boolean canExecuteAction(ActionEvent e) {
        AbstractButton editor = this.getEditor();
        Objects.requireNonNull(editor);
        if (!editor.isVisible() || !editor.isEnabled()) {
            return false;
        }
        if (editor instanceof JMenuItem) {
            return ((JMenuItem)editor).isArmed();
        }
        return editor.isShowing();
    }

    public final String getName() {
        return this.name;
    }

    public final void setName(String name) {
        this.name = name;
    }

    public final String getText() {
        return this.text;
    }

    public final String getTooltipText() {
        return this.tooltipText;
    }

    public final KeyStroke getKeyStroke() {
        return this.keyStroke;
    }

    public final int getMnemonic() {
        return this.mnemonic;
    }

    public final Icon getIcon() {
        return this.icon;
    }

    public final void setKeyStroke(KeyStroke keyStroke) {
        this.keyStroke = keyStroke;
    }

    public final void setText(String text) {
        this.text = text;
    }

    public final void setTooltipText(String tooltipText) {
        this.tooltipText = tooltipText;
    }

    public final void setIcon(Icon icon) {
        this.icon = icon;
    }

    public final void setMnemonic(int mnemonic) {
        this.mnemonic = mnemonic;
    }

    public boolean isSelectedKey() {
        return this.selectedKey;
    }

    public final void setSelectedKey(boolean selectedKey) {
        this.selectedKey = selectedKey;
    }

    public int getDisplayMnemonicIndexKey() {
        return this.displayMnemonicIndexKey;
    }

    public final void setDisplayMnemonicIndexKey(int displayMnemonicIndexKey) {
        this.displayMnemonicIndexKey = displayMnemonicIndexKey;
    }

    public boolean isAddMnemonicAsKeyStroke() {
        return this.addMnemonicAsKeyStroke;
    }

    public void setAddMnemonicAsKeyStroke(boolean addMnemonicAsKeyStroke) {
        this.addMnemonicAsKeyStroke = addMnemonicAsKeyStroke;
    }

    public Icon getLargeIcon() {
        return this.largeIcon;
    }

    public final void setLargeIcon(Icon largeIcon) {
        this.largeIcon = largeIcon;
    }

    public final KeyStroke getAcceleratorKey() {
        return this.keyStroke;
    }

    public final String getActionCommandKey() {
        return this.name;
    }

    public final UI getUi() {
        return this.ui;
    }

    public final void setUi(UI ui) {
        this.ui = ui;
    }

    public void setEditor(AbstractButton editor) {
        this.editor = editor;
    }

    public final AbstractButton getEditor() {
        return this.editor;
    }

    public boolean isAddKeyStrokeToText() {
        return this.addKeyStrokeToText;
    }

    public void setAddKeyStrokeToText(boolean addKeyStrokeToText) {
        this.addKeyStrokeToText = addKeyStrokeToText;
    }

    public final void register(InputMap inputMap, ActionMap actionMap) {
        if (this.keyStroke != null) {
            String actionCommandKey = this.getActionCommandKey();
            inputMap.put(this.keyStroke, actionCommandKey);
            actionMap.put(actionCommandKey, this);
        }
    }

    public final synchronized PropertyChangeListener[] getPropertyChangeListeners() {
        if (this.changeSupport == null) {
            return new PropertyChangeListener[0];
        }
        return this.changeSupport.getPropertyChangeListeners();
    }

    public final void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (this.changeSupport == null || Objects.equals(oldValue, newValue)) {
            return;
        }
        this.changeSupport.firePropertyChange(propertyName, oldValue, newValue);
    }

    public void displayInfo(String title, String text) {
        JOptionPanes.displayInfo((Component)this.ui, title, text);
    }

    public void displayWarning(String title, String text) {
        JOptionPanes.displayWarning((Component)this.ui, title, text);
    }

    public int askUser(String title, String message, int typeMessage, Object[] options, int defaultOption) {
        return JOptionPanes.askUser((Component)this.ui, title, message, typeMessage, options, defaultOption);
    }

    public int askUser(String title, Object message, int typeMessage, Object[] options, int defaultOption) {
        return JOptionPanes.askUser((Component)this.ui, title, message, typeMessage, options, defaultOption);
    }

    public int askUser(JOptionPane pane, String title, Object[] options) {
        return JOptionPanes.askUser((Frame)this.ui, pane, title, options);
    }

    protected void defaultInit(InputMap inputMap, ActionMap actionMap) {
        if (this.editor != null) {
            Icon icon;
            String tip;
            log.info((Object)("init action " + this.getActionCommandKey()));
            String text = this.editor.getText();
            if (StringUtils.isNotEmpty((CharSequence)text)) {
                this.setText(text);
            }
            if (StringUtils.isNotEmpty((CharSequence)(tip = this.editor.getToolTipText()))) {
                this.setTooltipText(tip);
            }
            if ((icon = this.editor.getIcon()) != null) {
                this.setIcon(icon);
            }
            if (this.addMnemonicAsKeyStroke && this.keyStroke == null && this.mnemonic != 0) {
                this.setKeyStroke(KeyStroke.getKeyStroke(this.mnemonic, 8));
            }
            if (this.addKeyStrokeToText && this.keyStroke != null) {
                this.addKeyStrokeToText(this.getText(), this.getTooltipText());
            }
            this.setEnabled(this.editor.isEnabled());
            this.editor.setAction(this);
        }
        this.register(inputMap, actionMap);
    }

    private void addKeyStrokeToText(String label, String shortDescription) {
        if (this.keyStroke == null) {
            return;
        }
        String acceleratorStr = " " + SwingUtil.keyStrokeToStr(this.keyStroke);
        this.setText(label == null ? "" : I18n.t((String)label, (Object[])new Object[0]) + acceleratorStr);
        this.setTooltipText(shortDescription == null ? "" : I18n.t((String)shortDescription, (Object[])new Object[0]) + acceleratorStr);
    }

    public final <O> O get(String propertyName) {
        Function<ApplicationAction<UI>, ?> getter = this.getters().get(propertyName);
        Objects.requireNonNull(getter, String.format("Can't find a getter for property: %s on %s", propertyName, this.getClass().getName()));
        return (O)getter.apply(this);
    }

    public final <O> void set(String propertyName, O o) {
        BiConsumer<ApplicationAction<UI>, ?> setter = this.setters().get(propertyName);
        Objects.requireNonNull(setter, String.format("Can't find a setter for property: %s on %s", propertyName, this.getClass().getName()));
        setter.accept(this, o);
    }

    public final Map<String, Function<ApplicationAction<UI>, ?>> getters() {
        return GETTERS;
    }

    public final Map<String, BiConsumer<ApplicationAction<UI>, ?>> setters() {
        return SETTERS;
    }
}

