package org.nuiton.jaxx.runtime.util;

/*-
 * #%L
 * JAXX :: Runtime
 * %%
 * Copyright (C) 2008 - 2017 Ultreia.io
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import org.apache.commons.beanutils.PropertyUtils;

/**
 * Created by tchemit on 12/07/17.
 *
 * @author Tony Chemit - dev@tchemit.fr
 */
public class BeanUtil {


    public static Method getMutator(Object bean, String property) {
        Method mutator = null;
        if (bean == null) {
            throw new NullPointerException("could not find bean");
        }
        if (property == null) {
            throw new NullPointerException("could not find property");
        }

        try {
            PropertyDescriptor descriptor = PropertyUtils.getPropertyDescriptor(bean, property);
            if (descriptor != null) {
                mutator = descriptor.getWriteMethod();
            }
        } catch (Exception e) {
            throw new RuntimeException(e);
        }

        return mutator;
    }
}
