/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.runtime.swing.wizard.ext;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuiton.jaxx.runtime.swing.wizard.WizardModel;
import org.nuiton.jaxx.runtime.swing.wizard.ext.WizardExtStep;
import org.nuiton.jaxx.runtime.swing.wizard.ext.WizardExtStepModel;
import org.nuiton.jaxx.runtime.swing.wizard.ext.WizardState;

public abstract class WizardExtModel<E extends WizardExtStep>
extends WizardModel<E> {
    private static final Logger log = LogManager.getLogger(WizardExtModel.class);
    public static final String OPERATIONS_PROPERTY_NAME = "operations";
    public static final String STEP_STATE_PROPERTY_NAME = "stepState";
    public static final String MODEL_STATE_PROPERTY_NAME = "modelState";
    public static final String WAS_STARTED_PROPERTY_NAME = "wasStarted";
    protected final Set<E> operations;
    protected final Map<E, WizardExtStepModel<E>> models;
    protected final Map<E, WizardState> stepStates;
    protected WizardState modelState;
    protected boolean wasStarted;

    public WizardExtModel(Class<E> stepClass, E ... steps) {
        super(stepClass, steps);
        this.stepStates = new EnumMap<E, WizardState>(stepClass);
        this.operations = EnumSet.noneOf(stepClass);
        this.models = new EnumMap<E, WizardExtStepModel<E>>(stepClass);
    }

    public Set<E> getOperations() {
        return this.operations;
    }

    public WizardState getModelState() {
        return this.modelState;
    }

    public boolean isWasStarted() {
        return this.wasStarted;
    }

    public boolean containsOperation(E step) {
        return this.getOperations().contains(step);
    }

    public E getOperation() {
        return (E)(this.getStep() != null && ((WizardExtStep)this.getStep()).isOperation() ? (WizardExtStep)this.getStep() : null);
    }

    public WizardState getStepState() {
        E operation = this.getOperation();
        return this.getStepState(operation);
    }

    public WizardState getStepState(E step) {
        return this.stepStates.get(step);
    }

    public void setStepState(WizardState newState) {
        E operation = this.getOperation();
        this.setStepState(operation, newState);
    }

    public void setStepState(E step, WizardState newState) {
        WizardState oldValue = this.getStepState(step);
        this.stepStates.put(step, newState);
        if (this.valueAdjusting) {
            return;
        }
        this.fireIndexedPropertyChange(STEP_STATE_PROPERTY_NAME, this.getSteps().indexOf(step), (Object)oldValue, (Object)newState);
        this.updateModelState(step, newState);
        this.validate();
    }

    public boolean[] getAccessibleSteps() {
        if (log.isDebugEnabled()) {
            log.debug("compute with steps " + this.getSteps());
        }
        boolean[] result = new boolean[this.getSteps().size()];
        int index = this.getSteps().indexOf(this.getStep());
        if (index != -1) {
            int j = this.steps.size();
            for (int i = 0; i < j; ++i) {
                if (i <= index) {
                    result[i] = true;
                    continue;
                }
                WizardExtStep previousStep = (WizardExtStep)this.steps.get(i - 1);
                result[i] = this.modelState == WizardState.SUCCESSED || result[i - 1] && this.validate(previousStep) && (!previousStep.isOperation() || this.getStepState(previousStep) == WizardState.SUCCESSED);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("accessibles steps -------- " + Arrays.toString(result));
        }
        return result;
    }

    @Override
    public void start() {
        if (this.steps.isEmpty()) {
            throw new IllegalStateException("can not start, no step found");
        }
        this.updateUniverse();
        this.step = null;
        WizardExtStep startStep = (WizardExtStep)this.steps.get(0);
        this.setStep(startStep);
        this.setModelState(WizardState.PENDING);
        this.validate();
    }

    public void cancel() {
        for (WizardExtStep op : this.operations) {
            if (this.getStepState(op) != WizardState.PENDING) continue;
            this.setStepState(op, WizardState.CANCELED);
        }
        this.setModelState(WizardState.CANCELED);
    }

    public WizardExtModel<E> addOperation(E operation) {
        if (this.operations.contains(operation)) {
            return this;
        }
        log.info("Add operation " + operation);
        this.operations.add(operation);
        this.updateUniverse();
        this.validate();
        return this;
    }

    public void removeOperation(E operation) {
        if (!this.operations.contains(operation)) {
            return;
        }
        this.operations.remove(operation);
        this.updateUniverse();
        this.validate();
    }

    @Override
    public void setSteps(E ... steps) {
        super.setSteps(steps);
        if (this.valueAdjusting) {
            return;
        }
        this.firePropertyChange(OPERATIONS_PROPERTY_NAME, null, this.operations);
    }

    public WizardExtStepModel<E> getStepModel(E operation) {
        if (operation == null) {
            return null;
        }
        if (!operation.isOperation()) {
            throw new IllegalStateException("step [" + operation + "] is not an operation.");
        }
        return this.models.get(operation);
    }

    public void updateStepStates(List<E> steps) {
        int index = 0;
        for (WizardExtStep e : steps) {
            this.fireIndexedPropertyChange(STEP_STATE_PROPERTY_NAME, index++, null, (Object)this.getStepState(e));
        }
        this.firePropertyChange(MODEL_STATE_PROPERTY_NAME, null, (Object)this.modelState);
    }

    public void setErrorOnStepModel(Exception error) {
        this.getStepModel(this.getOperation()).setError(error);
    }

    protected void setModelState(WizardState modelState) {
        WizardState oldValue = this.modelState;
        this.modelState = modelState;
        this.firePropertyChange(MODEL_STATE_PROPERTY_NAME, (Object)oldValue, (Object)modelState);
        if (!(this.wasStarted || oldValue != null && oldValue != WizardState.PENDING || modelState != WizardState.RUNNING)) {
            this.wasStarted = true;
            this.firePropertyChange(WAS_STARTED_PROPERTY_NAME, false, true);
        }
    }

    protected void updateModelState(E step, WizardState newState) {
        switch (newState) {
            case RUNNING: {
                this.setModelState(WizardState.RUNNING);
                break;
            }
            case FAILED: {
                this.setModelState(WizardState.FAILED);
                break;
            }
            case CANCELED: {
                this.setModelState(WizardState.CANCELED);
                return;
            }
            case PENDING: {
                this.setModelState(WizardState.PENDING);
                break;
            }
            case NEED_FIX: {
                this.setModelState(WizardState.PENDING);
                break;
            }
            case SUCCESSED: {
                boolean valid = true;
                for (WizardExtStep o : this.operations) {
                    if (this.getStepState(o) == WizardState.SUCCESSED) continue;
                    valid = false;
                    break;
                }
                if (valid) {
                    this.setModelState(WizardState.SUCCESSED);
                    break;
                }
                this.setModelState(WizardState.PENDING);
            }
        }
        this.updateStepStates(this.steps);
    }

    @Override
    public void updateUniverse() {
        ArrayList oldSteps = new ArrayList(this.getSteps());
        log.info("Start updateUniverse (oldSteps = " + oldSteps + ")");
        Object[] newSteps = this.updateStepUniverse();
        log.info("newSteps = " + Arrays.toString(newSteps));
        boolean skip = true;
        for (Object newStep : newSteps) {
            if (oldSteps.contains(newStep)) continue;
            skip = false;
        }
        if (skip && oldSteps.size() == newSteps.length) {
            log.info("Steps are same, do not modify anything");
            return;
        }
        for (WizardExtStepModel wizardExtStepModel : this.models.values()) {
            log.info("Destroy previous model : " + wizardExtStepModel);
            wizardExtStepModel.destroy();
        }
        this.models.clear();
        ArrayList<Object> toAdd = new ArrayList<Object>(Arrays.asList(newSteps));
        log.info("Will add models for " + toAdd);
        Iterator iterator = toAdd.iterator();
        while (iterator.hasNext()) {
            WizardExtStep step = (WizardExtStep)iterator.next();
            if (step.getModelClass() == null) {
                iterator.remove();
                continue;
            }
            if (!step.isOperation()) continue;
            WizardExtStepModel<?> model = step.newModel();
            if (log.isInfoEnabled()) {
                log.info("[" + step + "] Add primary model " + model);
            }
            this.models.put(step, model);
            iterator.remove();
        }
        if (!toAdd.isEmpty()) {
            Iterator iterator2 = toAdd.iterator();
            while (iterator2.hasNext()) {
                WizardExtStep step = (WizardExtStep)iterator2.next();
                Class<WizardExtStepModel<?>> modelClass = step.getModelClass();
                WizardExtStepModel<E> selectedModel = null;
                for (WizardExtStepModel<E> model : this.models.values()) {
                    if (!modelClass.isAssignableFrom(model.getClass())) continue;
                    selectedModel = model;
                    break;
                }
                if (selectedModel == null) {
                    throw new IllegalStateException("Could not find a primary model " + modelClass + " for step [" + step + "]");
                }
                log.info("[" + step + "] Attach model " + selectedModel);
                this.models.put(step, selectedModel);
                iterator2.remove();
            }
            if (!toAdd.isEmpty()) {
                throw new IllegalStateException("There is some step no model : " + toAdd);
            }
        }
        this.setSteps((WizardExtStep[])newSteps);
        this.stepStates.clear();
        for (Object step : newSteps) {
            if (this.stepStates.containsKey(step)) continue;
            this.setStepState(step, WizardState.PENDING);
        }
        log.info("Ending updateUniverse");
    }

    protected abstract E[] updateStepUniverse();

    @Override
    public void destroy() {
        super.destroy();
        for (WizardExtStepModel<E> model : this.models.values()) {
            if (log.isDebugEnabled()) {
                log.debug("destroy model " + model);
            }
            model.destroy();
        }
    }

    protected int getOperationIndex(E operation) {
        int index = 0;
        for (WizardExtStep o : this.operations) {
            if (o.equals(operation)) {
                return index;
            }
            ++index;
        }
        return -1;
    }
}

