/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.runtime.swing.wizard;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.nuiton.jaxx.runtime.JAXXUtil;
import org.nuiton.jaxx.runtime.swing.wizard.WizardStep;

public abstract class WizardModel<E extends WizardStep> {
    public static final String STEPS_PROPERTY_NAME = "steps";
    public static final String STEP_PROPERTY_NAME = "step";
    public static final String PREVIOUS_STEP_PROPERTY_NAME = "previousStep";
    public static final String NEXT_STEP_PROPERTY_NAME = "nextStep";
    public static final String VALID_STEP_PROPERTY_NAME = "validStep";
    public static final String BUSY_PROPERTY_NAME = "busy";
    protected final Class<E> stepClass;
    protected List<E> steps;
    protected List<E> excludeSteps;
    protected E step;
    protected boolean validStep;
    private boolean busy;
    protected boolean valueAdjusting;
    protected PropertyChangeSupport pcs;

    public WizardModel(Class<E> stepClass, E ... steps) {
        if (!Enum.class.isAssignableFrom(stepClass)) {
            throw new IllegalArgumentException("stepClass must be an Enumeration but was " + stepClass.getName());
        }
        this.stepClass = stepClass;
        this.pcs = new PropertyChangeSupport(this);
        this.steps = new ArrayList();
        if (steps.length > 0) {
            this.setSteps((WizardStep[])steps);
        }
    }

    public void start() {
        if (this.steps.isEmpty()) {
            throw new IllegalStateException("can not start, no step found");
        }
        this.step = null;
        WizardStep startStep = (WizardStep)this.steps.get(0);
        this.setStep(startStep);
    }

    public void destroy() {
        JAXXUtil.destroy((PropertyChangeSupport)this.pcs);
    }

    public void gotoNextStep() {
        E nextStep = this.getNextStep();
        if (nextStep == null) {
            throw new IllegalStateException("no next step to go");
        }
        this.setStep(nextStep);
    }

    public void gotoPreviousStep() {
        E previousStep = this.getPreviousStep();
        if (previousStep == null) {
            throw new IllegalStateException("no previous step to go");
        }
        this.setStep(previousStep);
    }

    public void gotoStep(E e) {
        if (e == null) {
            throw new NullPointerException("step can not be null");
        }
        if (!this.steps.contains(e)) {
            throw new IllegalStateException("step " + e.toString() + " is not in universe of steps (" + this.steps + ")");
        }
        this.setBusy(true);
        try {
            this.setStep(e);
        }
        finally {
            this.setBusy(false);
        }
    }

    public E getStep() {
        return this.step;
    }

    public int getStepIndex(E s) {
        return this.steps.indexOf(s);
    }

    public boolean isValidStep() {
        return this.validStep;
    }

    public E getPreviousStep() {
        return this.getPreviousStep(this.step);
    }

    public E getPreviousStep(E step) {
        int index = this.getStepIndex(step);
        if (index < 1) {
            return null;
        }
        return (E)((WizardStep)this.steps.get(index - 1));
    }

    public E getNextStep(E step) {
        int index = this.getStepIndex(step);
        if (index < 1) {
            return null;
        }
        return (E)((WizardStep)this.steps.get(index - 1));
    }

    public E getNextStep() {
        int index = this.getStepIndex(this.step);
        if (index == -1 || index == this.steps.size() - 1) {
            return null;
        }
        return (E)((WizardStep)this.steps.get(index + 1));
    }

    public List<E> getSteps() {
        return this.steps;
    }

    public boolean containsStep(E step) {
        return this.getSteps().contains(step);
    }

    public boolean isValueAdjusting() {
        return this.valueAdjusting;
    }

    public boolean isBusy() {
        return this.busy;
    }

    public void setBusy(boolean busy) {
        boolean oldValue = this.busy;
        this.busy = busy;
        this.firePropertyChange(BUSY_PROPERTY_NAME, oldValue, busy);
    }

    public void setSteps(E ... steps) {
        List<E> oldValue = this.steps;
        this.steps = Collections.unmodifiableList(Arrays.asList(steps));
        this.firePropertyChange(STEPS_PROPERTY_NAME, oldValue, this.steps);
        this.firePropertyChange(NEXT_STEP_PROPERTY_NAME, null, this.getNextStep());
    }

    public void setValueAdjusting(boolean valueAdjusting) {
        this.valueAdjusting = valueAdjusting;
    }

    public void setExcludeSteps(List<E> excludeSteps) {
        this.excludeSteps = excludeSteps;
    }

    public boolean validate(E s) {
        return this.step != null;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListeners() {
        JAXXUtil.destroy((PropertyChangeSupport)this.pcs);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.destroy();
    }

    public void validate() {
        if (this.step == null) {
            return;
        }
        this.validStep = this.validate(this.step);
        this.firePropertyChange(VALID_STEP_PROPERTY_NAME, null, this.validStep);
    }

    public abstract void updateUniverse();

    public Class<E> getStepClass() {
        return this.stepClass;
    }

    protected void setStep(E step) {
        E oldValue = this.step;
        this.step = step;
        this.firePropertyChange(STEP_PROPERTY_NAME, oldValue, step);
        this.firePropertyChange(NEXT_STEP_PROPERTY_NAME, null, this.getNextStep());
        this.firePropertyChange(PREVIOUS_STEP_PROPERTY_NAME, null, this.getPreviousStep());
        this.validate();
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.pcs.firePropertyChange(propertyName, oldValue, newValue);
    }

    protected void firePropertyChange(String propertyName, Object newValue) {
        this.pcs.firePropertyChange(propertyName, null, newValue);
    }

    protected void fireIndexedPropertyChange(String propertyName, int index, Object oldValue, Object newValue) {
        this.pcs.fireIndexedPropertyChange(propertyName, index, oldValue, newValue);
    }
}

