/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.runtime.swing.session;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.table.TableColumn;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuiton.jaxx.runtime.swing.session.State;

public class JTableState
implements State {
    private static final Logger log = LogManager.getLogger(JTableState.class);
    protected int[] columnWidths = new int[0];
    protected Map<Integer, String> sortKeys;

    public JTableState() {
    }

    public JTableState(int[] columnWidths, Map<Integer, String> sortKeys) {
        this.columnWidths = columnWidths;
        this.sortKeys = sortKeys;
    }

    public int[] getColumnWidths() {
        return this.columnWidths;
    }

    public void setColumnWidths(int[] columnWidths) {
        this.columnWidths = columnWidths;
    }

    public Map<Integer, String> getSortKeys() {
        return this.sortKeys;
    }

    public void setSortKeys(Map<Integer, String> sortKeys) {
        this.sortKeys = sortKeys;
    }

    protected JTable checkComponent(Object o) {
        if (o == null) {
            throw new IllegalArgumentException("null component");
        }
        if (!(o instanceof JTable)) {
            throw new IllegalArgumentException("invalid component");
        }
        return (JTable)o;
    }

    @Override
    public State getState(Object o) {
        JTable table = this.checkComponent(o);
        JTableState result = new JTableState();
        int[] columnWidths = new int[table.getColumnCount()];
        boolean resizableColumnExists = false;
        for (int i = 0; i < columnWidths.length; ++i) {
            TableColumn tc = table.getColumnModel().getColumn(i);
            int n = columnWidths[i] = tc.getResizable() ? tc.getWidth() : -1;
            if (!tc.getResizable()) continue;
            resizableColumnExists = true;
        }
        if (resizableColumnExists) {
            result.setColumnWidths(columnWidths);
        }
        if (table.getRowSorter() != null) {
            List<RowSorter.SortKey> sortKeys = table.getRowSorter().getSortKeys();
            HashMap<Integer, String> sortKeysMap = null;
            if (sortKeys != null) {
                sortKeysMap = new HashMap<Integer, String>();
                for (RowSorter.SortKey sortKey : sortKeys) {
                    sortKeysMap.put(sortKey.getColumn(), String.valueOf((Object)sortKey.getSortOrder()));
                }
            }
            result.setSortKeys(sortKeysMap);
        }
        return result;
    }

    @Override
    public void setState(Object o, State state) {
        Map<Integer, String> sortKeysMap;
        if (!(state instanceof JTableState)) {
            throw new IllegalArgumentException("invalid state");
        }
        JTable table = this.checkComponent(o);
        JTableState jTableState = (JTableState)state;
        int[] columnWidths = jTableState.getColumnWidths();
        if (columnWidths != null && table.getColumnCount() == columnWidths.length) {
            for (int i = 0; i < columnWidths.length; ++i) {
                TableColumn tc;
                if (columnWidths[i] == -1 || !(tc = table.getColumnModel().getColumn(i)).getResizable()) continue;
                tc.setPreferredWidth(columnWidths[i]);
            }
        }
        if ((sortKeysMap = jTableState.getSortKeys()) != null) {
            ArrayList<RowSorter.SortKey> sortKeys = new ArrayList<RowSorter.SortKey>();
            for (Integer index : sortKeysMap.keySet()) {
                SortOrder sortOrder = SortOrder.valueOf(sortKeysMap.get(index));
                RowSorter.SortKey sortKey = new RowSorter.SortKey(index, sortOrder);
                sortKeys.add(sortKey);
            }
            table.getRowSorter().setSortKeys(sortKeys);
        }
    }
}

