/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.runtime.swing.nav.tree;

import io.ultreia.java4all.i18n.I18n;
import java.util.HashMap;
import java.util.Map;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuiton.jaxx.runtime.swing.nav.NavDataProvider;
import org.nuiton.jaxx.runtime.swing.nav.NavNode;

public abstract class AbstractNavTreeCellRenderer<M, N extends NavNode<M, N>>
extends DefaultTreeCellRenderer {
    protected static final Logger log = LogManager.getLogger(AbstractNavTreeCellRenderer.class);
    private static final long serialVersionUID = -2339479996023197627L;
    protected NavDataProvider dataProvider;
    protected final Map<N, String> renderCache = new HashMap<N, String>();

    protected abstract String computeNodeText(N var1);

    protected AbstractNavTreeCellRenderer() {
    }

    public NavDataProvider getDataProvider() {
        return this.dataProvider;
    }

    public void setDataProvider(NavDataProvider dataProvider) {
        this.dataProvider = dataProvider;
        this.clearCache();
    }

    public void clearCache() {
        this.renderCache.clear();
    }

    public void invalidateCache(N node) {
        this.renderCache.remove(node);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.clearCache();
    }

    public String getNodeText(N node) {
        String text;
        if (node == null) {
            return null;
        }
        if (node.isDirty() || !this.renderCache.containsKey(node)) {
            text = node.isStringNode() ? I18n.t((String)node.getId(), (Object[])new Object[0]) : this.computeNodeText(node);
            if (log.isDebugEnabled()) {
                log.debug("text for node [" + node + "] = <" + text + ">");
            }
            this.renderCache.put(node, text);
            node.setDirty(false);
        } else {
            text = this.renderCache.get(node);
        }
        return text;
    }
}

