/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.runtime.swing.nav.treetable;

import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jdesktop.swingx.tree.TreeModelSupport;
import org.jdesktop.swingx.treetable.DefaultTreeTableModel;
import org.jdesktop.swingx.treetable.TreeTableModel;
import org.jdesktop.swingx.treetable.TreeTableNode;
import org.nuiton.jaxx.runtime.swing.nav.treetable.NavTreeTableNode;

public class NavTreeTableModel
implements TreeTableModel {
    private static final Logger log = LogManager.getLogger(NavTreeTableModel.class);
    protected final MyDefaultTreeTableModel delegate;

    public NavTreeTableModel(MyDefaultTreeTableModel delegate) {
        this.delegate = delegate;
    }

    public TreeTableNode[] getPathToRoot(TreeTableNode aNode) {
        if (aNode == null) {
            return null;
        }
        TreeTableNode[] treeNodes = this.getDelegate().getPathToRoot(aNode);
        NavTreeTableNode[] result = new NavTreeTableNode[treeNodes.length];
        System.arraycopy(treeNodes, 0, result, 0, treeNodes.length);
        return result;
    }

    public void nodeStructureChanged(NavTreeTableNode<?> node) {
        if (node != null) {
            TreeNode parentNode = node.getParent();
            if (parentNode == null || ((NavTreeTableNode)parentNode).isRoot()) {
                this.getModelSupport().fireNewRoot();
            } else {
                Object[] treeNodes = this.getPathToRoot((TreeTableNode)parentNode);
                if (treeNodes != null) {
                    this.getModelSupport().fireTreeStructureChanged(new TreePath(treeNodes));
                }
            }
        } else {
            log.error("Node is null !");
        }
    }

    public void nodeChanged(NavTreeTableNode<?> node) {
        if (node != null) {
            TreeNode parent = node.getParent();
            Object[] treeNodes = this.getPathToRoot((TreeTableNode)parent);
            if (treeNodes != null) {
                this.getModelSupport().fireChildChanged(new TreePath(treeNodes), parent.getIndex(node), node);
            }
        } else {
            log.error("Node is null !");
        }
    }

    public MyDefaultTreeTableModel getDelegate() {
        return this.delegate;
    }

    public TreeModelSupport getModelSupport() {
        return this.delegate.getModelSupport();
    }

    public String[] getColomnsNames() {
        return this.delegate.getColumnsNames();
    }

    public void setRoot(TreeTableNode root) {
        this.delegate.setRoot(root);
    }

    public TreeTableNode getRoot() {
        return this.delegate.getRoot();
    }

    public Object getChild(Object parent, int index) {
        return this.delegate.getChild(parent, index);
    }

    public int getChildCount(Object parent) {
        return this.delegate.getChildCount(parent);
    }

    public boolean isLeaf(Object node) {
        return this.delegate.isLeaf(node);
    }

    public void valueForPathChanged(TreePath path, Object newValue) {
        this.delegate.valueForPathChanged(path, newValue);
    }

    public int getIndexOfChild(Object parent, Object child) {
        return this.delegate.getIndexOfChild(parent, child);
    }

    public void addTreeModelListener(TreeModelListener l) {
        this.delegate.addTreeModelListener(l);
    }

    public void removeTreeModelListener(TreeModelListener l) {
        this.delegate.removeTreeModelListener(l);
    }

    public Class<?> getColumnClass(int i) {
        return this.getDelegate().getColumnClass(i);
    }

    public int getColumnCount() {
        return this.getColomnsNames().length;
    }

    public String getColumnName(int column) {
        return this.getColomnsNames()[column];
    }

    public int getHierarchicalColumn() {
        return this.getDelegate().getHierarchicalColumn();
    }

    public Object getValueAt(Object o, int i) {
        return this.getDelegate().getValueAt(o, i);
    }

    public boolean isCellEditable(Object o, int i) {
        return this.getDelegate().isCellEditable(o, i);
    }

    public void setValueAt(Object o, Object o1, int i) {
        this.getDelegate().setValueAt(o, o1, i);
    }

    public static abstract class MyDefaultTreeTableModel
    extends DefaultTreeTableModel {
        public TreeModelSupport getModelSupport() {
            return this.modelSupport;
        }

        public abstract String[] getColumnsNames();
    }
}

