/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.runtime.swing.nav.tree;

import java.util.Enumeration;
import java.util.EventListener;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuiton.jaxx.runtime.swing.nav.NavBridge;
import org.nuiton.jaxx.runtime.swing.nav.tree.NavTreeNode;

public class NavTreeBridge<N extends NavTreeNode<N>>
implements NavBridge<DefaultTreeModel, N> {
    private static final Logger log = LogManager.getLogger(NavTreeBridge.class);
    protected DefaultTreeModel model;

    @Override
    public DefaultTreeModel getModel() {
        return this.model;
    }

    @Override
    public N getRoot() {
        return (N)((NavTreeNode)this.model.getRoot());
    }

    @Override
    public boolean isLeaf(Object node) {
        return this.model.isLeaf(node);
    }

    @Override
    public int getChildCount(Object parent) {
        return this.model.getChildCount(parent);
    }

    @Override
    public N getChild(Object parent, int index) {
        return (N)((NavTreeNode)this.model.getChild(parent, index));
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        return this.model.getIndexOfChild(parent, child);
    }

    @Override
    public TreeNode[] getPathToRoot(TreeNode aNode) {
        return this.model.getPathToRoot(aNode);
    }

    @Override
    public void setModel(DefaultTreeModel model) {
        this.model = model;
    }

    @Override
    public void setRoot(N node) {
        this.model.setRoot((TreeNode)node);
    }

    @Override
    public void insertNodeInto(N newChild, N parent, int index) {
        this.model.insertNodeInto((MutableTreeNode)newChild, (MutableTreeNode)parent, index);
    }

    @Override
    public void removeNodeFromParent(N node) {
        this.model.removeNodeFromParent((MutableTreeNode)node);
    }

    @Override
    public void reload(N node) {
        this.model.reload();
    }

    @Override
    public boolean canLoadChild(N node) {
        return true;
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
        this.model.valueForPathChanged(path, newValue);
    }

    @Override
    public void nodesWereInserted(N parent, int[] indices) {
        this.model.nodesWereInserted((TreeNode)parent, indices);
    }

    @Override
    public void nodeWereInserted(N parentNode, int childIndice, N node) {
        int[] indices = new int[]{childIndice};
        this.model.nodesWereInserted((TreeNode)parentNode, indices);
    }

    @Override
    public void nodeChanged(TreeNode node) {
        this.model.nodeChanged(node);
    }

    @Override
    public void nodeStructureChanged(TreeNode node) {
        this.model.nodeStructureChanged(node);
    }

    @Override
    public void nodesWereRemoved(TreeNode node, int[] childIndices, Object[] removedChildren) {
        this.model.nodesWereRemoved(node, childIndices, removedChildren);
    }

    @Override
    public void nodesChanged(TreeNode node, int[] childIndices) {
        this.model.nodesChanged(node, childIndices);
    }

    @Override
    public void notifyChildNodesInserted(N node) {
        int count = ((DefaultMutableTreeNode)node).getChildCount();
        if (count < 1) {
            if (log.isDebugEnabled()) {
                log.debug("Skip for leaf node : " + node);
            }
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("Notify for node : " + node + ", " + count + " child(s) inserted.");
        }
        int[] indices = new int[count];
        for (int i = 0; i < count; ++i) {
            indices[i] = i;
        }
        this.nodesWereInserted(node, indices);
        Enumeration childs = ((NavTreeNode)node).children();
        while (childs.hasMoreElements()) {
            NavTreeNode child = (NavTreeNode)childs.nextElement();
            this.notifyChildNodesInserted((N)child);
        }
    }

    @Override
    public void notifyNodeInserted(N node) {
        TreeNode parent = ((NavTreeNode)node).getParent();
        if (parent != null) {
            int indice = ((DefaultMutableTreeNode)parent).getIndex((TreeNode)node);
            if (log.isDebugEnabled()) {
                log.debug("Notify for node : " + node + ", for parent [" + parent + "] child  " + indice + " inserted.");
            }
            this.nodesWereInserted(parent, new int[]{indice});
            this.notifyChildNodesInserted(node);
        }
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
        this.model.addTreeModelListener(l);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
        this.model.removeTreeModelListener(l);
    }

    @Override
    public TreeModelListener[] getTreeModelListeners() {
        return this.model.getTreeModelListeners();
    }

    @Override
    public <T extends EventListener> T[] getListeners(Class<T> listenerType) {
        return this.model.getListeners(listenerType);
    }
}

