/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.runtime.swing.help;

import java.applet.Applet;
import java.awt.AWTEvent;
import java.awt.ActiveEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.MenuComponent;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Vector;
import javax.help.CSH;
import javax.help.HelpBroker;
import javax.help.HelpSet;
import javax.help.plaf.basic.BasicCursorFactory;
import javax.swing.AbstractButton;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuiton.jaxx.runtime.JAXXContext;
import org.nuiton.jaxx.runtime.JAXXObject;
import org.nuiton.jaxx.runtime.awt.visitor.BuildTreeVisitor;
import org.nuiton.jaxx.runtime.awt.visitor.ComponentTreeNode;
import org.nuiton.jaxx.runtime.awt.visitor.GetCompopentAtPointVisitor;
import org.nuiton.jaxx.runtime.swing.help.JAXXHelpUIHandler;

public class JAXXHelpBroker {
    public static final String JAXX_CONTEXT_ENTRY = "jaxxcontext";
    private static final Logger log = LogManager.getLogger(JAXXHelpBroker.class);
    protected final String helpsetName;
    protected final String defaultID;
    protected final String helpKey;
    protected HelpSet helpset;
    protected HelpBroker helpBroker;
    protected Locale locale;
    protected Hashtable<Component, Cursor> cursors;
    protected Cursor onItemCursor;
    protected final Map<Component, String> cache;
    protected JAXXHelpUIHandler handler;

    public JAXXHelpBroker(String helpsetName, String helpKey, String defaultID, JAXXHelpUIHandler handler) {
        this(null, helpsetName, helpKey, defaultID, handler);
    }

    public JAXXHelpBroker(Locale locale, String helpsetName, String helpKey, String defaultID, JAXXHelpUIHandler handler) {
        if (helpsetName == null) {
            throw new NullPointerException("parameter helpsetName can not be null!");
        }
        if (handler == null) {
            throw new NullPointerException("handler can not be null");
        }
        this.locale = locale;
        this.helpsetName = helpsetName;
        this.helpKey = helpKey;
        this.defaultID = defaultID;
        this.handler = handler;
        this.cache = new HashMap<Component, String>();
    }

    public void prepareUI(JAXXObject c) {
        if (c == null) {
            throw new NullPointerException("parameter c can not be null!");
        }
        AbstractButton help = this.getShowHelpButton(c);
        if (help == null) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("attach context to showhelp button " + c);
        }
        help.putClientProperty(JAXX_CONTEXT_ENTRY, c);
        ActionListener listener = this.getShowHelpAction();
        if (log.isDebugEnabled()) {
            log.debug("adding tracking action " + listener);
        }
        help.addActionListener(listener);
        if (log.isDebugEnabled()) {
            log.debug("done for " + c);
        }
        this.getHelpBroker().enableHelpKey((Component)c, this.getDefaultID(), this.getHelpset());
    }

    public void showHelp(JAXXContext context, String helpId) {
        this.getHandler().showHelp(context, this, helpId);
    }

    public JAXXHelpUIHandler getHandler() {
        return this.handler;
    }

    public HelpBroker getHelpBroker() {
        if (this.helpBroker == null) {
            this.helpBroker = this.getHelpset().createHelpBroker();
        }
        return this.helpBroker;
    }

    public String getHelpKey() {
        return this.helpKey;
    }

    public HelpSet getHelpset() {
        if (this.helpset == null) {
            try {
                ClassLoader cl = this.getClass().getClassLoader();
                URL url = HelpSet.findHelpSet((ClassLoader)cl, (String)this.helpsetName, (Locale)this.locale);
                this.helpset = new HelpSet(cl, url);
            }
            catch (Exception ee) {
                throw new IllegalStateException("could not find help set " + this.helpsetName + " for reason " + ee.getMessage(), ee);
            }
        }
        return this.helpset;
    }

    public String getHelpsetName() {
        return this.helpsetName;
    }

    public String getDefaultID() {
        return this.defaultID;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
        this.helpset = null;
        this.helpBroker = null;
        this.getHelpset();
        this.getHelpBroker();
    }

    public void showHelpSet() {
        if (log.isDebugEnabled()) {
            log.debug((Object)this);
        }
        new CSH.DisplayHelpFromSource(this.getHelpBroker());
    }

    public void installUI(Component comp, String helpId) {
        CSH.setHelpIDString((Component)comp, (String)helpId);
        if (log.isDebugEnabled()) {
            log.debug(helpId + " : " + comp.getName());
        }
        this.cache.put(comp, helpId);
    }

    protected AbstractButton getShowHelpButton(JAXXObject c) {
        return (AbstractButton)c.getObjectById("showHelp");
    }

    protected ActionListener getShowHelpAction() {
        return new ShowHelpForTrackedComponentAction();
    }

    protected Component getDeppestComponent(Component mouseComponent, MouseEvent event) {
        ComponentTreeNode tree = BuildTreeVisitor.buildTree((Component)mouseComponent);
        Point point = event.getLocationOnScreen();
        Component component = GetCompopentAtPointVisitor.get((ComponentTreeNode)tree, (Point)point);
        if (log.isDebugEnabled()) {
            log.debug("Component at (" + point + "): " + component);
        }
        return component;
    }

    public String findHelpId(Component comp) {
        String helpID = CSH.getHelpIDString((Component)comp);
        if (this.defaultID.equals(helpID)) {
            String id = this.cache.get(comp);
            if (helpID.equals(id)) {
                return helpID;
            }
            if (log.isDebugEnabled()) {
                log.debug("will try to find better id for comp : " + comp.getName());
            }
            helpID = this.findExtactHelpId(comp);
        }
        if (log.isInfoEnabled()) {
            log.info("helpID " + helpID + " for comp " + comp.getName() + " : " + comp.getClass().getName());
        }
        return helpID;
    }

    protected String findExtactHelpId(Component comp) {
        for (Container parent = comp.getParent(); parent != null; parent = parent.getParent()) {
            String id = this.cache.get(parent);
            if (id == null) {
                continue;
            }
            return id;
        }
        return this.defaultID;
    }

    protected Vector<?> getTopContainers(Object source) {
        Frame[] frames;
        Vector<Component> containers = new Vector<Component>();
        Component topComponent = null;
        topComponent = this.getRoot(source);
        if (topComponent instanceof Applet) {
            try {
                Enumeration<Applet> applets = ((Applet)topComponent).getAppletContext().getApplets();
                while (applets.hasMoreElements()) {
                    containers.add(applets.nextElement());
                }
            }
            catch (NullPointerException npe) {
                containers.add(topComponent);
            }
        }
        for (Frame frame : frames = Frame.getFrames()) {
            Window[] windows = frame.getOwnedWindows();
            Collections.addAll(containers, windows);
            if (containers.contains(frame)) continue;
            containers.add(frame);
        }
        return containers;
    }

    protected Component getRoot(Object comp) {
        Object parent = comp;
        while (parent != null) {
            comp = parent;
            if (comp instanceof MenuComponent) {
                parent = ((MenuComponent)comp).getParent();
                continue;
            }
            if (!(comp instanceof Component) || comp instanceof Window || comp instanceof Applet) break;
            parent = ((Component)comp).getParent();
        }
        if (comp instanceof Component) {
            return (Component)comp;
        }
        return null;
    }

    protected void setAndStoreCursors(Component comp, Cursor cursor) {
        Cursor compCursor;
        if (comp == null) {
            return;
        }
        if (this.cache.containsKey(comp) && (compCursor = comp.getCursor()) != cursor) {
            this.cursors.put(comp, compCursor);
            if (log.isDebugEnabled()) {
                log.debug("set cursor on " + comp);
            }
            comp.setCursor(cursor);
        }
        if (comp instanceof Container) {
            Component[] component;
            for (Component aComponent : component = ((Container)comp).getComponents()) {
                this.setAndStoreCursors(aComponent, cursor);
            }
        }
    }

    protected void resetAndRestoreCursors(Component comp) {
        if (comp == null) {
            return;
        }
        Cursor oldCursor = this.cursors.get(comp);
        if (oldCursor != null) {
            log.debug("restored cursor " + oldCursor + " on " + comp);
            comp.setCursor(oldCursor);
        }
        if (comp instanceof Container) {
            Component[] component;
            for (Component aComponent : component = ((Container)comp).getComponents()) {
                this.resetAndRestoreCursors(aComponent);
            }
        }
    }

    public static MouseEvent getMouseEvent() {
        block18: {
            try {
                if (!EventQueue.isDispatchThread()) break block18;
                EventQueue eq = null;
                try {
                    eq = Toolkit.getDefaultToolkit().getSystemEventQueue();
                }
                catch (Exception ee) {
                    log.debug((Object)ee);
                }
                if (eq == null) {
                    return null;
                }
                int eventNumber = -1;
                while (true) {
                    ++eventNumber;
                    AWTEvent event = eq.getNextEvent();
                    Object src = event.getSource();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)event);
                    }
                    if (event instanceof ActiveEvent) {
                        ((ActiveEvent)((Object)event)).dispatch();
                        continue;
                    }
                    if (src instanceof Component) {
                        InputEvent e;
                        if (event instanceof KeyEvent) {
                            e = (KeyEvent)event;
                            if (((KeyEvent)e).getKeyCode() == 3 || ((KeyEvent)e).getKeyCode() == 27) {
                                e.consume();
                                return null;
                            }
                            e.consume();
                            continue;
                        }
                        if (event instanceof MouseEvent) {
                            e = (MouseEvent)event;
                            int eID = e.getID();
                            if ((eID == 500 || eID == 501 || eID == 502) && SwingUtilities.isRightMouseButton((MouseEvent)e)) {
                                e.consume();
                                if (log.isDebugEnabled()) {
                                    log.debug("tracking canceled!!!");
                                }
                                return null;
                            }
                            if ((eID == 500 || eID == 501 || eID == 502) && SwingUtilities.isLeftMouseButton((MouseEvent)e)) {
                                if (eID == 500 && eventNumber == 0) {
                                    JAXXHelpBroker.dispatchEvent(event);
                                    continue;
                                }
                                e.consume();
                                return e;
                            }
                            e.consume();
                            continue;
                        }
                        JAXXHelpBroker.dispatchEvent(event);
                        continue;
                    }
                    if (src instanceof MenuComponent) {
                        if (!(event instanceof InputEvent)) continue;
                        ((InputEvent)event).consume();
                        continue;
                    }
                    log.error("unable to dispatch event: " + event);
                }
            }
            catch (InterruptedException e) {
                if (!log.isDebugEnabled()) break block18;
                log.debug((Object)e);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("Fall Through code");
        }
        return null;
    }

    protected static void dispatchEvent(AWTEvent event) {
        Object src = event.getSource();
        if (event instanceof ActiveEvent) {
            ((ActiveEvent)((Object)event)).dispatch();
        } else if (src instanceof Component) {
            ((Component)src).dispatchEvent(event);
        } else if (src instanceof MenuComponent) {
            ((MenuComponent)src).dispatchEvent(event);
        } else {
            log.error("unable to dispatch event: " + event);
        }
    }

    public class ShowHelpForTrackedComponentAction
    implements ActionListener {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent e) {
            AbstractButton source = (AbstractButton)e.getSource();
            JAXXContext context = (JAXXContext)source.getClientProperty(JAXXHelpBroker.JAXX_CONTEXT_ENTRY);
            JAXXHelpBroker.this.onItemCursor = (Cursor)UIManager.get("HelpOnItemCursor");
            if (JAXXHelpBroker.this.onItemCursor == null) {
                JAXXHelpBroker.this.onItemCursor = BasicCursorFactory.getOnItemCursor();
                UIManager.put("HelpOnItemCursor", JAXXHelpBroker.this.onItemCursor);
            }
            Objects.requireNonNull(JAXXHelpBroker.this.onItemCursor, "A cursor is missing (add HelpOnItemCursor cursor in UIManager).");
            Vector<?> topComponents = null;
            JAXXHelpBroker.this.cursors = null;
            if (JAXXHelpBroker.this.onItemCursor != null) {
                JAXXHelpBroker.this.cursors = new Hashtable();
                topComponents = JAXXHelpBroker.this.getTopContainers(source);
                for (Object topComponent : topComponents) {
                    JAXXHelpBroker.this.setAndStoreCursors((Container)topComponent, JAXXHelpBroker.this.onItemCursor);
                }
            }
            Component comp = null;
            try {
                MouseEvent event = JAXXHelpBroker.getMouseEvent();
                if (event == null) {
                    return;
                }
                comp = (Component)event.getSource();
                if (log.isDebugEnabled()) {
                    log.debug("component traking " + comp.getName() + " : " + comp.getClass().getName());
                }
                comp = JAXXHelpBroker.this.getDeppestComponent(comp, event);
                if (log.isDebugEnabled()) {
                    log.debug("deepest component " + comp.getName() + " : " + comp.getClass().getName());
                }
            }
            finally {
                if (topComponents != null) {
                    for (Object topComponent : topComponents) {
                        JAXXHelpBroker.this.resetAndRestoreCursors((Container)topComponent);
                    }
                }
                JAXXHelpBroker.this.cursors = null;
            }
            String helpID = JAXXHelpBroker.this.findHelpId(comp);
            JAXXHelpBroker.this.showHelp(context, helpID);
        }
    }
}

