/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.runtime.swing.application;

import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuiton.jaxx.runtime.swing.application.event.ApplicationRunnerEvent;
import org.nuiton.jaxx.runtime.swing.application.event.ApplicationRunnerListener;

public abstract class ApplicationRunner {
    private static final Logger log = LogManager.getLogger(ApplicationRunner.class);
    private static final Object lock = new Object();
    private static ApplicationRunner runner;
    protected final String[] args;
    protected final Runnable runnable;
    protected boolean reload;
    protected boolean initOnce;
    protected long startingTime;
    protected Exception error;
    protected Thread mainThread;
    private ApplicationRunnerListener mainListener;

    protected ApplicationRunner(String ... args) {
        runner = this;
        this.args = args;
        this.runnable = () -> {
            this.startingTime = System.nanoTime();
            try {
                this.onInit();
                this.onStart();
            }
            catch (Exception e) {
                this.error = e;
                this.onError(e);
                ApplicationRunner.unlock();
            }
        };
        Thread shutdownHook = new Thread(() -> {
            try {
                this.onShutdown();
            }
            catch (Exception e) {
                this.error = e;
                this.onShutdown(e);
            }
        }, "ShutDown " + this.getClass().getSimpleName());
        Runtime.getRuntime().addShutdownHook(shutdownHook);
    }

    public static ApplicationRunner getRunner() {
        if (runner == null) {
            throw new IllegalStateException("No runner initialized");
        }
        return runner;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void lock() throws InterruptedException {
        Object object = lock;
        synchronized (object) {
            lock.wait();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unlock() {
        Object object = lock;
        synchronized (object) {
            lock.notifyAll();
        }
    }

    public void setMainListener(ApplicationRunnerListener mainListener) {
        this.mainListener = Objects.requireNonNull(mainListener);
    }

    public final void launch() {
        if (this.mainListener == null) {
            throw new IllegalStateException("No main listener registered in ApplicationRunner");
        }
        this.reload = false;
        if (!this.initOnce) {
            try {
                this.initOnce();
            }
            finally {
                this.initOnce = true;
            }
        }
        this.mainThread = new Thread(this.runnable, this.getClass().getSimpleName());
        this.mainThread.start();
        try {
            ApplicationRunner.lock();
            log.info(String.format("Application [%s] is closing...", this.mainThread));
        }
        catch (InterruptedException e) {
            log.error(String.format("%s was interrupted for reason %s", this.mainThread, e.getMessage()), (Throwable)e);
        }
        finally {
            this.close();
        }
    }

    public void initOnce() {
        this.mainListener.initOnce(new ApplicationRunnerEvent(this));
    }

    public void onInit() throws Exception {
        this.mainListener.init(new ApplicationRunnerEvent(this));
    }

    public void onStart() throws Exception {
        this.mainListener.start(new ApplicationRunnerEvent(this));
    }

    public void onClose(boolean reload) throws Exception {
        this.mainListener.close(new ApplicationRunnerEvent(this, reload));
    }

    public void onShutdown() throws Exception {
        this.mainListener.shutdown(new ApplicationRunnerEvent(this));
    }

    public void onShutdown(Exception ex) {
        this.mainListener.shutdownWithError(new ApplicationRunnerEvent(this, ex));
    }

    public void onError(Exception e) {
        this.mainListener.error(new ApplicationRunnerEvent(this, e));
    }

    public boolean isReload() {
        return this.reload;
    }

    public void setReload(boolean reload) {
        this.reload = reload;
    }

    public String[] getArgs() {
        return this.args;
    }

    public final void close() {
        boolean doReload = this.isReload();
        try {
            this.onClose(doReload);
            if (doReload) {
                log.info("Will reload application");
                System.runFinalization();
                this.launch();
            }
        }
        catch (Exception e) {
            this.onError(e);
        }
        finally {
            if (!doReload) {
                log.debug("Will shutdown application ...");
                ApplicationRunner.unlock();
                Runtime.getRuntime().exit(0);
            }
        }
    }
}

