/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.runtime.swing.application;

import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import javax.swing.SwingWorker;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.jaxx.runtime.swing.application.ActionWorker;
import org.nuiton.jaxx.runtime.util.ReflectUtil;

public abstract class ActionExecutor {
    private static final Log log = LogFactory.getLog(ActionExecutor.class);
    protected final Set<ActionWorker<?, ?>> tasks = new HashSet();
    protected final PropertyChangeListener workerListener = evt -> {
        if (log.isDebugEnabled()) {
            log.debug((Object)("action " + evt.getSource() + " property " + evt.getPropertyName() + " changed <" + evt.getOldValue() + " - " + evt.getNewValue() + '>'));
        }
        if (!"state".equals(evt.getPropertyName())) return;
        ActionWorker source = (ActionWorker)evt.getSource();
        SwingWorker.StateValue state = (SwingWorker.StateValue)((Object)((Object)evt.getNewValue()));
        if (state == SwingWorker.StateValue.STARTED) {
            this.onActionStart(source);
            return;
        }
        if (state != SwingWorker.StateValue.DONE) return;
        ActionWorker.ActionStatus status = source.getStatus();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Action [" + source.getActionLabel() + "] status = " + (Object)((Object)status)));
        }
        try {
            switch (status) {
                case OK: {
                    this.onActionEnd(source);
                    return;
                }
                case CANCEL: {
                    this.onActionCancel(source);
                    return;
                }
                case FAIL: {
                    this.onActionFail(source);
                    return;
                }
            }
            return;
        }
        finally {
            this.tasks.remove(source);
            this.onAfterAction(source);
        }
    };

    public abstract void onActionStart(ActionWorker<?, ?> var1);

    public abstract void onActionFail(ActionWorker<?, ?> var1);

    public abstract void onActionCancel(ActionWorker<?, ?> var1);

    public abstract void onActionEnd(ActionWorker<?, ?> var1);

    public abstract void onAfterAction(ActionWorker<?, ?> var1);

    public ActionWorker<?, ?> addAction(String actionLabel, Runnable action) {
        ActionWorker worker = action instanceof ActionWorker ? (ActionWorker)action : new ActionWorker(actionLabel, action);
        worker.addPropertyChangeListener(this.workerListener);
        this.tasks.add(worker);
        worker.execute();
        return worker;
    }

    public void terminatesAndWaits() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Executor " + this + " is terminating..."));
        }
        for (ActionWorker<?, ?> task : this.tasks) {
            task.cancel(true);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Executor " + this + " is terminated at " + new Date()));
        }
    }

    public int getNbActions() {
        return this.getTasks().size();
    }

    public Set<ActionWorker<?, ?>> getTasks() {
        return this.tasks;
    }

    public Runnable createRunnable(Object methodContainer, String methodName, Object ... arguments) {
        Class<?> klass = methodContainer.getClass();
        Method targetMethod = ReflectUtil.getDeclaredMethod(klass, (String)methodName, (boolean)true, (Object[])arguments);
        targetMethod.setAccessible(true);
        Runnable result = (Runnable)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{Runnable.class}, (proxy, method, args) -> {
            String methodName1 = method.getName();
            if ("run".equals(methodName1)) {
                try {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"will invoke run method");
                    }
                    return targetMethod.invoke(methodContainer, arguments);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException("could not invoke on container " + methodContainer, e);
                }
                catch (InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            }
            if (methodName1.equals("toString")) {
                return this.toString();
            }
            if (methodName1.equals("equals")) {
                return this.equals(args[0]);
            }
            if (methodName1.equals("hashCode")) {
                return this.hashCode();
            }
            return null;
        });
        return result;
    }
}

