/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.runtime.init;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.ultreia.java4all.util.SingletonSupplier;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.JComponent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuiton.jaxx.runtime.JAXXObject;

public class UIInitializerContext<U extends JAXXObject> {
    private static final Logger log = LogManager.getLogger(UIInitializerContext.class);
    private final U ui;
    private final String prefix;
    private final Class<?>[] types;
    private final ImmutableSet.Builder<String> doNotBlockComponentIds;
    private final ImmutableSet.Builder<Class<?>> componentsToKeep;
    private final ArrayListMultimap<String, JComponent> focusComponents = ArrayListMultimap.create();
    private final ImmutableList.Builder<Object> dependencies;
    private final SingletonSupplier<ArrayListMultimap<Class<?>, Object>> typedComponents;
    private Init initState;

    public static ArrayListMultimap<Class<?>, Object> components(JAXXObject ui) {
        ArrayListMultimap result = ArrayListMultimap.create();
        ui.get$objectMap().values().forEach(v -> result.put(v.getClass(), v));
        return result;
    }

    public static <O> Stream<O> onComponents(Class<O> type, ArrayListMultimap<Class<?>, Object> components) {
        return UIInitializerContext.loadComponents(type, components).stream();
    }

    public static <O> List<O> loadComponents(Class<O> type, ArrayListMultimap<Class<?>, Object> components) {
        ImmutableList.Builder result = ImmutableList.builder();
        Set entries = components.asMap().entrySet();
        entries.stream().filter(k -> type.isAssignableFrom((Class)k.getKey())).forEach(k -> result.addAll((Iterable)((Collection)k.getValue())));
        return result.build();
    }

    public UIInitializerContext(U ui, Class<?> ... types) {
        this.ui = (JAXXObject)Objects.requireNonNull(ui);
        this.prefix = "[" + ui.getClass().getSimpleName() + "] ";
        this.types = types;
        this.doNotBlockComponentIds = ImmutableSet.builder();
        this.dependencies = ImmutableList.builder();
        this.componentsToKeep = ImmutableSet.builder();
        this.typedComponents = SingletonSupplier.of(this::init);
    }

    public U getUi() {
        return this.ui;
    }

    public ArrayListMultimap<Class<?>, Object> init() {
        ArrayListMultimap typedComponents = ArrayListMultimap.create();
        this.ui.get$objectMap().forEach((k, v) -> {
            if (v == null) {
                log.warn(String.format("%s Null JAXX object with id: %s", this.prefix, k));
                return;
            }
            typedComponents.put(v.getClass(), v);
        });
        return typedComponents;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void registerDependencies(Object ... dependencies) {
        this.dependencies.addAll(Arrays.asList(dependencies));
        for (Object dep : dependencies) {
            this.ui.setContextValue((Object)dep);
        }
    }

    public void addDoNotBlockComponentId(String editor) {
        this.doNotBlockComponentIds.add((Object)editor);
    }

    public ImmutableSet<String> getDoNotBlockComponentIds() {
        return this.doNotBlockComponentIds.build();
    }

    public ImmutableList<Object> getDependencies() {
        return this.dependencies.build();
    }

    public ArrayListMultimap<String, JComponent> getFocusComponents() {
        return this.focusComponents;
    }

    public ImmutableSet<Class<?>> getComponentsToKeep() {
        return this.componentsToKeep.build();
    }

    public void addFocusComponents(String name, Collection<JComponent> collection) {
        this.focusComponents.putAll((Object)name, collection);
    }

    public void addFocusComponent(String name, JComponent editor) {
        this.focusComponents.put((Object)name, (Object)editor);
    }

    public UIInitializerContext<U> startFirstPass() {
        log.info(String.format("%sInit widgets - first pass", this.prefix));
        this.initState = Init.FIRST_PASS;
        return this;
    }

    public UIInitializerContext<U> startSecondPass() {
        log.info(String.format("%sInit widgets - second pass", this.prefix));
        this.initState = Init.SECOND_PASS;
        return this;
    }

    public <C> UIInitializerContext<U> onComponents(Class<C> componentType, boolean keep, Consumer<C> consumer) {
        if (keep) {
            this.componentsToKeep.add(componentType);
        }
        this.getComponents(componentType).forEach(consumer);
        return this;
    }

    public <C> UIInitializerContext<U> onComponents(Class<C> componentType, Consumer<C> consumer) {
        return this.onComponents(componentType, false, consumer);
    }

    public <C> UIInitializerContext<U> onSubComponents(Class<C> componentType, boolean keep, Consumer<C> consumer) {
        Set<Class<?>> subComponentsTypes = this.getSubComponentsTypes(componentType);
        if (keep) {
            this.componentsToKeep.addAll(subComponentsTypes);
        }
        this.getSubComponents(componentType, subComponentsTypes).forEach(consumer);
        return this;
    }

    public <C> UIInitializerContext<U> onSubComponents(Class<C> componentType, Consumer<C> consumer) {
        return this.onSubComponents(componentType, false, consumer);
    }

    public void checkFirstPass() {
        this.check(Init.FIRST_PASS);
    }

    public void checkSecondPass() {
        this.check(Init.SECOND_PASS);
    }

    public void check(Init initState) {
        if (!Objects.equals((Object)initState, (Object)this.initState)) {
            throw new IllegalStateException("Must be in " + this + " but still on " + initState);
        }
    }

    public <C> Stream<C> getComponents(Class<C> componentType) {
        return ((ArrayListMultimap)this.typedComponents.get()).get(componentType).stream();
    }

    public <C> Stream<C> getSubComponents(Class<C> componentType, Set<Class<?>> componentTypes) {
        ArrayListMultimap multimap = (ArrayListMultimap)this.typedComponents.get();
        return multimap.asMap().entrySet().stream().filter(e -> componentTypes.contains(e.getKey())).flatMap(e -> ((Collection)e.getValue()).stream()).distinct();
    }

    public <C> Set<Class<?>> getSubComponentsTypes(Class<C> componentType) {
        ArrayListMultimap multimap = (ArrayListMultimap)this.typedComponents.get();
        return multimap.asMap().keySet().stream().filter(componentType::isAssignableFrom).collect(Collectors.toSet());
    }

    public UIInitializerContext<U> apply(Runnable consumer) {
        consumer.run();
        return this;
    }

    public ArrayListMultimap<Class<?>, Object> getKeptComponents() {
        ArrayListMultimap result = ArrayListMultimap.create();
        this.getComponentsToKeep().forEach(type -> result.putAll(type, (Iterable)((ArrayListMultimap)this.typedComponents.get()).get(type)));
        return result;
    }

    public static enum Init {
        FIRST_PASS,
        SECOND_PASS;

    }
}

