/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.runtime.resources;

import java.awt.Color;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import javax.swing.ImageIcon;
import javax.swing.UIManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class UIResourcesProvider {
    private static final Logger log = LogManager.getLogger(UIResourcesProvider.class);
    private static final String ICON_PREFIX = "icon.";
    private static final String COLOR_PREFIX = "color.";
    private final String name;
    private final String resourcePath;
    private int nbIcons;
    private int nbColors;

    public UIResourcesProvider(String name, String resourcePath) {
        this.name = name;
        this.resourcePath = resourcePath;
    }

    public void load() throws IOException {
        log.info(String.format("%s Loading ui resources", this.name));
        try (InputStream resourceAsStream = this.getClass().getClassLoader().getResourceAsStream(this.resourcePath);){
            Objects.requireNonNull(resourceAsStream, "Could not find ui resources file: " + this.resourcePath);
            Properties p = new Properties();
            p.load(resourceAsStream);
            this.load(p);
        }
        log.info(String.format("%s Loaded %d icon(s).", this.name, this.nbIcons));
        log.info(String.format("%s Loaded %d color(s).", this.name, this.nbColors));
    }

    public int getNbIcons() {
        return this.nbIcons;
    }

    public int getNbColors() {
        return this.nbColors;
    }

    public void load(Properties incoming) throws IOException {
        this.nbColors = 0;
        this.nbIcons = 0;
        for (Map.Entry<Object, Object> entry : incoming.entrySet()) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            if (key.startsWith(ICON_PREFIX)) {
                String iconKey = key.substring(ICON_PREFIX.length());
                String iconPath = "/icons/" + value;
                log.info(String.format("%s Loading icon %s \u2192 %s", this.name, iconKey, iconPath));
                URL imgURL = this.getClass().getResource(iconPath);
                if (imgURL == null) {
                    throw new IOException(String.format("%s could not find icon %s", this.name, iconPath));
                }
                ImageIcon icon = new ImageIcon(imgURL);
                UIManager.put(iconKey, icon);
                ++this.nbIcons;
                continue;
            }
            if (!key.startsWith(COLOR_PREFIX)) continue;
            String colorKey = key.substring(COLOR_PREFIX.length());
            Object[] rgb = ((String)value).split(",");
            log.info(String.format("%s Loading color %s \u2192 %s", this.name, colorKey, Arrays.toString(rgb)));
            UIManager.put(colorKey, new Color(Integer.valueOf((String)rgb[0]), Integer.valueOf((String)rgb[1]), Integer.valueOf((String)rgb[2])));
            ++this.nbColors;
        }
    }
}

