/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.runtime.init;

import io.ultreia.java4all.bean.JavaBean;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javax.swing.JComponent;
import org.nuiton.jaxx.runtime.bean.BeanScopeAware;
import org.nuiton.jaxx.runtime.init.UIInitializerContext;
import org.nuiton.jaxx.runtime.init.UIInitializerResult;

public abstract class UIInitializerSupport<UI extends JComponent, C extends UIInitializerContext<UI>> {
    public static final String CLIENT_PROPERTY_SELECT_ON_FOCUS = "selectOnFocus";
    private static final String CLIENT_PROPERTY_SKIP_BINDING_TO_BEAN = "skipBindingToBean";
    private static final String CLIENT_PROPERTY_SKIP_BINDING_FROM_BEAN = "skipBindingFromBean";
    protected final C initializerContext;

    public static boolean isBindingToBean(JComponent editor) {
        Boolean skip = (Boolean)editor.getClientProperty(CLIENT_PROPERTY_SKIP_BINDING_TO_BEAN);
        return skip == null || skip == false;
    }

    public static boolean isBindingFromBean(JComponent editor) {
        Boolean skip = (Boolean)editor.getClientProperty(CLIENT_PROPERTY_SKIP_BINDING_FROM_BEAN);
        return skip == null || skip == false;
    }

    public static <J extends JComponent, O> void bindFromBean(J editor, String property, Function<J, O> valueGetter, BiConsumer<J, O> valueSetter) {
        JavaBean bean = (JavaBean)((BeanScopeAware)((Object)editor)).getBean();
        if (property != null && bean != null && UIInitializerSupport.isBindingFromBean(editor)) {
            bean.addPropertyChangeListener(property, e -> {
                Object newValue;
                Object oldValue = valueGetter.apply(editor);
                if (!Objects.equals(oldValue, newValue = e.getNewValue())) {
                    valueSetter.accept(editor, newValue);
                }
            });
        }
    }

    public UIInitializerSupport(UI ui, Class<?> ... types) {
        this.initializerContext = this.createIInitializerContext(ui, types);
    }

    protected abstract void initUI(C var1);

    protected abstract C createIInitializerContext(UI var1, Class<?> ... var2);

    public UIInitializerResult initUI() {
        this.initUI(this.initializerContext);
        return this.build(this.initializerContext);
    }

    protected UIInitializerResult build(C initializerContext) {
        return new UIInitializerResult((UIInitializerContext<?>)initializerContext);
    }

    public void registerDependencies(Object ... dependencies) {
        ((UIInitializerContext)this.initializerContext).registerDependencies(dependencies);
    }
}

