package org.nuiton.jaxx.runtime.init;

/*-
 * #%L
 * JAXX :: Runtime Spi
 * %%
 * Copyright (C) 2008 - 2020 Code Lutin, Ultreia.io
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import org.nuiton.jaxx.runtime.JAXXObject;

import javax.swing.JComponent;

/**
 * Created on 10/12/2020.
 *
 * @author Tony Chemit - dev@tchemit.fr
 * @since 3.0
 */
public abstract class UIInitializerSupport<UI extends JComponent & JAXXObject, C extends UIInitializerContext<UI>> {

    protected final C initializerContext;

    public UIInitializerSupport(UI ui, Class<?>... types) {
        initializerContext = createIInitializerContext(ui, types);
    }

    protected abstract void initUI(C initializerContext);

    protected abstract C createIInitializerContext(UI ui, Class<?>... types);

    public UIInitializerResult initUI() {
        initUI(initializerContext);
        return build(initializerContext);
    }

    protected UIInitializerResult build(C initializerContext) {
        return new UIInitializerResult(initializerContext);
    }

    public void registerDependencies(Object... dependencies) {
        initializerContext.registerDependencies(dependencies);
    }

}
