/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.runtime.spi.init;

import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import org.nuiton.jaxx.runtime.JAXXObject;
import org.nuiton.jaxx.runtime.spi.init.ComponentInitializer;

public class ComponentInitializerManager {
    public static final ComponentInitializerManager INSTANCE = new ComponentInitializerManager();
    private final Set<ComponentInitializer> initializerSet = new HashSet<ComponentInitializer>();

    private ComponentInitializerManager() {
        for (ComponentInitializer componentInitializer : ServiceLoader.load(ComponentInitializer.class)) {
            this.initializerSet.add(componentInitializer);
        }
    }

    public static ComponentInitializerManager get() {
        return INSTANCE;
    }

    public Set<ComponentInitializer> apply(JAXXObject ui) {
        LinkedHashSet<ComponentInitializer> done = new LinkedHashSet<ComponentInitializer>();
        for (ComponentInitializer componentInitializer : this.initializerSet) {
            componentInitializer.reset();
            if (componentInitializer.acceptUi(ui)) {
                componentInitializer.start(ui);
                for (Map.Entry<String, Object> entry : ui.get$objectMap().entrySet()) {
                    Object component = entry.getValue();
                    if (component == null || !componentInitializer.acceptComponent(component)) continue;
                    componentInitializer.init(ui, component);
                }
            }
            if (!componentInitializer.isTouched()) continue;
            done.add(componentInitializer);
        }
        for (ComponentInitializer<Object> componentInitializer : done) {
            componentInitializer.end(ui);
        }
        return done;
    }
}

