/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.runtime.spi.init;

import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import org.nuiton.jaxx.runtime.JAXXObject;
import org.nuiton.jaxx.runtime.spi.init.ComponentInitializer;

public class ComponentInitializerManager {
    public static final ComponentInitializerManager INSTANCE = new ComponentInitializerManager();
    private final Set<ComponentInitializer> initializerSet = new HashSet<ComponentInitializer>();

    public static ComponentInitializerManager get() {
        return INSTANCE;
    }

    private ComponentInitializerManager() {
        for (ComponentInitializer componentInitializer : ServiceLoader.load(ComponentInitializer.class)) {
            this.initializerSet.add(componentInitializer);
        }
    }

    public void apply(JAXXObject ui) {
        LinkedHashSet<ComponentInitializer> done = new LinkedHashSet<ComponentInitializer>();
        for (ComponentInitializer componentInitializer : this.initializerSet) {
            if (!componentInitializer.acceptUi(ui)) continue;
            componentInitializer.start(ui);
            done.add(componentInitializer);
            for (Map.Entry<String, Object> entry : ui.get$objectMap().entrySet()) {
                Object component = entry.getValue();
                if (!componentInitializer.acceptComponent(component)) continue;
                componentInitializer.init(ui, component);
            }
        }
        for (ComponentInitializer<Object> componentInitializer : done) {
            componentInitializer.end(ui);
        }
    }
}

