package org.nuiton.jaxx.runtime.spi.init;

/*-
 * #%L
 * JAXX :: Runtime Spi
 * %%
 * Copyright (C) 2008 - 2017 Code Lutin, Ultreia.io
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import com.google.common.collect.ArrayListMultimap;
import java.util.Collection;
import java.util.Map;
import org.nuiton.jaxx.runtime.JAXXObject;

/**
 * Created by tchemit on 20/09/17.
 *
 * @author Tony Chemit - dev@tchemit.fr
 */
public abstract class UIInitializerSupport<U extends JAXXObject, I extends UIInitializerContext<U>> {

    private final I context;

    public UIInitializerSupport(I context) {
        this.context = context;
    }

    public void init(U ui) {
        init(context);
    }

    public void init(I context) {
        U ui = context.getUi();
        ArrayListMultimap<Class, Object> objectsByType = ArrayListMultimap.create();

        for (Object o : ui.get$objectMap().values()) {
            if (o == null) {
                continue;
            }
            if (context.initializerComponentTypes().contains(o.getClass())) {
                objectsByType.put(o.getClass(), o);
            } else {
                for (UIComponentInitializer initializer : context.initializerComponents().values()) {
                    if (initializer.accept(o)) {
                        objectsByType.put(initializer.getComponentType(), o);
                        break;
                    }
                }
            }
        }

        for (Map.Entry<Class, Collection<Object>> entry : objectsByType.asMap().entrySet()) {
            Class key = entry.getKey();
            UIComponentInitializer initializer = context.initializerComponents().get(key);
            for (Object o1 : entry.getValue()) {
                initializer.init(context, o1);
            }
        }

        String[] acceptedComponentNames = context.acceptedComponentNames();
        if (acceptedComponentNames.length > 0) {
            initBlockLayerUI(context, acceptedComponentNames);
        }

        initEnd(context);
    }

    protected void initEnd(I context) {

    }

    protected void initBlockLayerUI(I context, String... doNotBlockComponentIds) {

    }

}
