/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.plugin;

import io.ultreia.java4all.i18n.I18n;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class NodeItem {
    String absoluteTarget;
    private String target;
    private String text;
    private List<NodeItem> childs;

    public NodeItem(String target, String text) {
        this.target = target;
        this.absoluteTarget = target;
        this.text = text;
    }

    public String getTarget() {
        return this.target;
    }

    public String getAbsoluteTarget() {
        return this.absoluteTarget;
    }

    public String getText() {
        return this.text;
    }

    public List<NodeItem> getChilds() {
        return this.childs;
    }

    public void setText(String text) {
        this.text = text;
    }

    public NodeItem findChild(String path) {
        String[] paths;
        NodeItem result = null;
        for (String p : paths = path.split("\\.")) {
            if (result == null) {
                if (this.target.equals(p)) {
                    result = this;
                    continue;
                }
                result = this.getChild(p);
                if (result != null) continue;
                result = new NodeItem(p, null);
                this.addChild(result);
                this.adjutsAbsoluteTarget(result);
                continue;
            }
            NodeItem child = result.getChild(p);
            if (child == null) {
                child = new NodeItem(p, null);
                result.addChild(child);
                result.adjutsAbsoluteTarget(child);
                result = child;
                continue;
            }
            result = child;
        }
        return result;
    }

    public NodeItem getChild(int index) {
        return this.childs.get(index);
    }

    public NodeItem getChild(String target) {
        if (this.isLeaf()) {
            return null;
        }
        for (NodeItem i : this.childs) {
            if (!i.target.equals(target)) continue;
            return i;
        }
        return null;
    }

    public void addChild(NodeItem child) {
        if (this.childs == null) {
            this.childs = new ArrayList<NodeItem>();
        }
        this.childs.add(child);
    }

    public void adjutsAbsoluteTarget(NodeItem child) {
        if (!"top".equals(this.target)) {
            child.absoluteTarget = this.absoluteTarget + "." + child.target;
        }
    }

    public void adjustTarget() {
        int index = this.target.lastIndexOf(".");
        if (index > -1) {
            this.target = this.target.substring(index + 1);
        }
    }

    public boolean isLeaf() {
        return this.childs == null || this.childs.isEmpty();
    }

    public void applyI18n(String prefix, String suffix) {
        String key = prefix + this.getAbsoluteTarget() + suffix;
        this.text = I18n.t((String)key, (Object[])new Object[0]);
        if (!this.isLeaf()) {
            for (NodeItem i : this.getChilds()) {
                i.applyI18n(prefix, suffix);
            }
        }
    }

    public void extractI18n(Set<String> keys, String prefix, String suffix) {
        String key = prefix + this.getAbsoluteTarget() + suffix;
        keys.add(key);
        if (!this.isLeaf()) {
            for (NodeItem i : this.getChilds()) {
                i.extractI18n(keys, prefix, suffix);
            }
        }
    }

    public String toString() {
        return super.toString() + "<target:" + this.target + ", text:" + this.text + ", nbChilds:" + (this.isLeaf() ? 0 : this.childs.size()) + ">";
    }
}

