/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.plugin;

import com.google.common.base.Charsets;
import com.google.common.io.Closeables;
import com.google.common.io.Files;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.nuiton.io.SortedProperties;
import org.nuiton.jaxx.compiler.decorators.HelpRootCompiledObjectDecorator;
import org.nuiton.jaxx.plugin.AbstractGenerateHelpMojo;

@Mojo(name="generate-help-ids", defaultPhase=LifecyclePhase.PROCESS_SOURCES, requiresProject=true)
public class GenerateHelpIdsMojo
extends AbstractGenerateHelpMojo {
    public static final String INPUT_FILENAME_FULL_FORMAT = "%s-%s_%s.properties";
    public static final String INPUT_FILENAME_FORMAT = "%s-%s.properties";
    @Parameter(property="jaxx.mergeIdsToInput", defaultValue="false", required=true)
    protected boolean mergeIdsToInput;
    @Parameter(property="jaxx.strictMode", defaultValue="false", required=true)
    protected boolean strictMode;
    @Parameter(property="jaxx.inputHelpDirectory", defaultValue="src/main/help", required=true)
    protected File inputHelpDirectory;
    @Parameter(property="jaxx.inputHelpFilenamePrefix", defaultValue="helpMapping", required=true)
    protected String inputHelpFilenamePrefix;
    protected Set<String> helpIds;

    @Override
    public void init() throws Exception {
        if (!this.generateHelp) {
            return;
        }
        super.init();
        if (this.getHelpIdsFilename() == null) {
            throw new MojoFailureException("you must set the 'helpIdStore' property.");
        }
        if (this.getMergeHelpIdsFilename() == null) {
            throw new MojoFailureException("you must set the 'helpIdStoreAll' property.");
        }
        this.helpIds = HelpRootCompiledObjectDecorator.getHelpIds();
        this.cleanHelpIdsStore();
        if (this.mergeIdsToInput) {
            this.createDirectoryIfNecessary(this.inputHelpDirectory);
        }
    }

    @Override
    protected boolean checkSkip() {
        boolean b = super.checkSkip();
        if (b) {
            if (this.strictMode) {
                this.getLog().info((CharSequence)"Strict mode is on, will use all detected ids.");
            } else if (this.helpIds.isEmpty()) {
                this.getLog().info((CharSequence)"No help ids to treate, will skip goal.");
                b = false;
            }
        }
        return b;
    }

    @Override
    protected void preDoAction() throws IOException {
        File idsStore = this.getHelpIdsStoreFile();
        this.getLog().info((CharSequence)("Store detected help ids to " + idsStore));
        this.storeHelpIds(idsStore, this.helpIds);
        File idsStoreAll = this.getMergeHelpIdsStoreFile();
        this.getLog().info((CharSequence)("Merge help ids to " + idsStoreAll));
        if (idsStoreAll.exists()) {
            Set<String> allIds = this.loadHelpIds(idsStoreAll);
            this.helpIds.addAll(allIds);
        }
        this.storeHelpIds(idsStoreAll, this.helpIds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doActionForLocale(Locale locale, boolean isDefaultLocale, File source, String localePath) throws Exception {
        if (this.mergeIdsToInput) {
            String filename = StringUtils.isNotEmpty((CharSequence)locale.getCountry()) ? String.format(INPUT_FILENAME_FULL_FORMAT, this.inputHelpFilenamePrefix, locale.getLanguage(), locale.getCountry()) : String.format(INPUT_FILENAME_FORMAT, this.inputHelpFilenamePrefix, locale.getLanguage());
            File inputFile = new File(this.inputHelpDirectory, filename);
            this.getLog().info((CharSequence)("Use input file: " + inputFile));
            SortedProperties p = new SortedProperties();
            if (inputFile.exists()) {
                BufferedReader reader = Files.newReader((File)inputFile, (Charset)Charsets.UTF_8);
                try {
                    p.load((Reader)reader);
                    ((Reader)reader).close();
                }
                finally {
                    Closeables.close((Closeable)reader, (boolean)true);
                }
            }
            Set existingId = p.stringPropertyNames();
            HashSet<String> newIds = new HashSet<String>();
            for (String helpId : this.helpIds) {
                newIds.add(this.removeQuote(helpId));
            }
            if (this.strictMode) {
                for (String s : existingId) {
                    if (newIds.contains(s)) continue;
                    p.remove((Object)s);
                }
                existingId.retainAll(newIds);
            } else {
                newIds.removeAll(existingId);
            }
            if (newIds.isEmpty()) {
                this.getLog().info((CharSequence)"No keys to add.");
            } else {
                if (this.strictMode) {
                    this.getLog().info((CharSequence)("Regenerate files with " + newIds.size() + " keys."));
                } else {
                    this.getLog().info((CharSequence)("Add " + newIds.size() + " keys."));
                }
                for (String helpId : newIds) {
                    if (p.containsKey((Object)helpId)) continue;
                    p.put((Object)helpId, (Object)"");
                }
                BufferedWriter writer = Files.newWriter((File)inputFile, (Charset)Charsets.UTF_8);
                try {
                    p.store((Writer)writer, "Generated by " + ((Object)((Object)this)).getClass().getName());
                    ((Writer)writer).close();
                }
                finally {
                    Closeables.close((Closeable)writer, (boolean)true);
                }
            }
        }
    }

    @Override
    protected void postDoAction() {
        this.helpIds.clear();
    }

    @Override
    public File getTargetDirectory() {
        return this.getOutputHelpIds();
    }

    @Override
    public void setTargetDirectory(File targetDirectory) {
        this.setOutputHelpIds(targetDirectory);
    }
}

