package org.nuiton.jaxx.demo.component.jaxx.editor;

/*
 * #%L
 * JAXX :: Demo
 * %%
 * Copyright (C) 2008 - 2020 Code Lutin, Ultreia.io
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import io.ultreia.java4all.decoration.Decorator;
import io.ultreia.java4all.decoration.DecoratorProvider;
import org.nuiton.jaxx.demo.entities.DemoDataProvider;
import org.nuiton.jaxx.demo.entities.People;
import org.nuiton.jaxx.runtime.spi.UIHandler;

import java.util.List;
import java.util.Locale;

import static io.ultreia.java4all.i18n.I18n.n;
import static io.ultreia.java4all.i18n.I18n.t;

/**
 * Handlerof {@link BeanComboBoxDemo}.
 *
 * @author Kevin Morin - morin@codelutin.com
 * @since 2.5.12
 */
public class BeanFilterableComboBoxDemoHandler implements UIHandler<BeanFilterableComboBoxDemo> {

    static {
        n("jaxxdemo.common.people");
        n("jaxxdemo.common.firstName");
        n("jaxxdemo.common.lastName");
        n("jaxxdemo.common.age");
    }

    private Decorator decorator;

    @Override
    public void beforeInit(BeanFilterableComboBoxDemo ui) {
        this.decorator = DecoratorProvider.get().decorator(Locale.ENGLISH, People.class);
    }

    @Override
    public void afterInit(BeanFilterableComboBoxDemo ui) {

        List<People> data = new DemoDataProvider().getPeoples();

        ui.getComboBox().init(decorator, data);
    }

    public String getSelectedResult(Object people) {
        String result;

        if (people instanceof People) {
            result = t("jaxxdemo.beanfilterablecomboboxdemo.selected.people", decorator.decorate(people));
        } else {
            result = t("jaxxdemo.beanfilterablecomboboxdemo.no.people.selected");
        }
        return result;
    }
}
