package org.nuiton.jaxx.demo.component.swing;

/*-
 * #%L
 * JAXX :: Demo
 * %%
 * Copyright (C) 2008 - 2021 Code Lutin, Ultreia.io
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.awt.LayoutManager;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuiton.jaxx.demo.DemoPanel;
import org.nuiton.jaxx.runtime.JAXXContext;
import org.nuiton.jaxx.runtime.JAXXObjectDescriptor;
import org.nuiton.jaxx.runtime.JAXXUtil;
import org.nuiton.jaxx.runtime.binding.DefaultJAXXBinding;
import org.nuiton.jaxx.runtime.swing.HBox;
import org.nuiton.jaxx.runtime.swing.JAXXButtonGroup;
import org.nuiton.jaxx.runtime.swing.VBox;
import static io.ultreia.java4all.i18n.I18n.t;

public class JRadioButtonDemo extends DemoPanel {

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JLABEL0_ICON = "$JLabel0.icon";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKWUz08TQRTHXysthYIIGEI8EalCAuyKifEAQfkRRFLFQEKIvTjtTtoh251xdhZWDxw8ePMf8ODVi+F/IJ5MvHjlfzDhT/DNbukWs11W28NuM33fz3zf63vv22/IuRLmuawbjscUd4xD4vuG9BzFmtTYXj042Kke0praoG5NMqG4hPCTyUK2AkWrfe4qMCplJJkhydQks0Uy13lTcIc6HaClMgy66p1N3QalSsFsV3HNdc29duSSLzzZuivWddxdPz8unmfoxucsgC/QfgHTnvsHQJR1XxmyzFIwVj4kR8S0iVNHc5I5dUxoWJ+t28R1X5ImfQsn0F+GvCASYQoW/qs8AS5A+UJBsbRBm/wVcaj9QMGjv1Ow8Eejdkkz3GP0ZWzvEovxNU9hmFYLEfDyCvKlrTXuI+hut1qEBB2lJQMdyv1Uyv2WcqitvFnq9IOESV00P8arFox00S3q09tJEQ9jIgql7TKpBqUbu3JrcHrV55CMWNjcC8l56lEJY59J7gkssYT73STY0EbU0FFvZSqQkx4eK5juPkt6HHYxKhyE6e6DoK8JAj+cnsivxxfnl90/jOamrlN1DDq2opBcUKmY9jYStr6nmG2+IGKpAgMutXFLBFtgJtn5XisS3aOLUU0yNMnYIm4Dabn+87PvE29+3YDsJgzanFibRMc/hwHVkFgxblu+ePI0MDd0XMDnLW1TwXiDS/aeO4rYqzarO81g6MaWmWMzh04RhVNa9RRd8bFsM8lla7s83bn48eXTvbPL0mXQdCmNMipf7jXkQw/B6mhthdhVURQu9SwejXzcEsjo97BoTXEpeM7GFWT0SP9jtY5y6NA539Ov+SAZ/c1IDSxWow5PQI2nQBXCjqFWj5w+Rf2ktNIwckfE9mhPEH38OIEwkYqw2jNhs2dCUhaTPWeRjpCUxfUEbApWwzUAN5ctoshUlTkWruiVeN4d5P0B7t8aUAgJAAA=";
    private static final Logger log = LogManager.getLogger(JRadioButtonDemo.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JAXXButtonGroup radioButtons;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JRadioButtonDemo $DemoPanel0;
    private HBox $HBox0;
    private JLabel $JLabel0;
    private JRadioButton $JRadioButton0;
    private JRadioButton $JRadioButton1;
    private JRadioButton $JRadioButton2;
    private VBox $VBox0;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public JRadioButtonDemo() {
        
    }

    public JRadioButtonDemo(JAXXContext param0) {
        super(param0);
    }

    public JRadioButtonDemo(boolean param0) {
        super(param0);
    }

    public JRadioButtonDemo(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
    }

    public JRadioButtonDemo(LayoutManager param0) {
        super(param0);
    }

    public JRadioButtonDemo(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
    }

    public JRadioButtonDemo(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
    }

    public JRadioButtonDemo(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JAXXButtonGroup getRadioButtons() {
        return radioButtons;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected HBox get$HBox0() {
        return $HBox0;
    }

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected JRadioButton get$JRadioButton0() {
        return $JRadioButton0;
    }

    protected JRadioButton get$JRadioButton1() {
        return $JRadioButton1;
    }

    protected JRadioButton get$JRadioButton2() {
        return $JRadioButton2;
    }

    protected VBox get$VBox0() {
        return $VBox0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void create$JRadioButton0() {
        $objectMap.put("$JRadioButton0", $JRadioButton0 = new JRadioButton());
        
        $JRadioButton0.setName("$JRadioButton0");
        $JRadioButton0.setSelected(true);
        $JRadioButton0.setText(t("Animal"));
        { $JRadioButton0.putClientProperty("$value", "Lynx.jpg");  Object $buttonGroup = $JRadioButton0.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
    }

    protected void create$JRadioButton1() {
        $objectMap.put("$JRadioButton1", $JRadioButton1 = new JRadioButton());
        
        $JRadioButton1.setName("$JRadioButton1");
        $JRadioButton1.setText(t("Vegetable"));
        { $JRadioButton1.putClientProperty("$value", "Tomato.jpg");  Object $buttonGroup = $JRadioButton1.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
    }

    protected void create$JRadioButton2() {
        $objectMap.put("$JRadioButton2", $JRadioButton2 = new JRadioButton());
        
        $JRadioButton2.setName("$JRadioButton2");
        $JRadioButton2.setText(t("Mineral"));
        { $JRadioButton2.putClientProperty("$value", "Amethyst.jpg");  Object $buttonGroup = $JRadioButton2.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
    }

    protected void createRadioButtons() {
        $objectMap.put("radioButtons", radioButtons = new JAXXButtonGroup());
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    protected void $initialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $DemoPanel0 = this;
        super.$initialize();
    }

    @Override
    protected void $initialize_01_createComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_01_createComponents();
        $objectMap.put("$DemoPanel0", $DemoPanel0);
        // inline creation of $HBox0
        $objectMap.put("$HBox0", $HBox0 = new HBox());
        
        $HBox0.setName("$HBox0");
        $HBox0.setHorizontalAlignment(0);
        $HBox0.setVerticalAlignment(0);
        // inline creation of $VBox0
        $objectMap.put("$VBox0", $VBox0 = new VBox());
        
        $VBox0.setName("$VBox0");
        create$JRadioButton0();
        create$JRadioButton1();
        create$JRadioButton2();
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        createRadioButtons();
        // inline creation of $DemoPanel0
        setName("$DemoPanel0");
    }

    @Override
    protected void $initialize_02_registerDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_02_registerDataBindings();
        // register 1 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_$JLABEL0_ICON, true) {
        
            @Override
            public void applyDataBinding() {
                if (radioButtons != null) {
                    radioButtons.addPropertyChangeListener("selectedValue", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (radioButtons != null) {
                    $JLabel0.setIcon(new ImageIcon(getClass().getResource("/org/nuiton/jaxx/demo/images/" + radioButtons.getSelectedValue())));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (radioButtons != null) {
                    radioButtons.removePropertyChangeListener("selectedValue", this);
                }
            }
        });
    }

    @Override
    protected void $initialize_03_finalizeCreateComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_03_finalizeCreateComponents();
        // inline complete setup of $DemoPanel0
        add($HBox0);
        // inline complete setup of $HBox0
        $HBox0.add($VBox0);
        $HBox0.add($JLabel0);
        // inline complete setup of $VBox0
        $VBox0.add($JRadioButton0);
        $VBox0.add($JRadioButton1);
        $VBox0.add($JRadioButton2);
        // inline complete setup of $JRadioButton0
        { ButtonGroup $buttonGroup = radioButtons; $JRadioButton0.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add($JRadioButton0); }
        
        // inline complete setup of $JRadioButton1
        { ButtonGroup $buttonGroup = radioButtons; $JRadioButton1.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add($JRadioButton1); }
        
        // inline complete setup of $JRadioButton2
        { ButtonGroup $buttonGroup = radioButtons; $JRadioButton2.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add($JRadioButton2); }
    }

    @Override
    protected void $initialize_04_applyDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_04_applyDataBindings();
    }

    @Override
    protected void $initialize_05_setProperties() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_05_setProperties();
    }

    @Override
    protected void $initialize_06_finalizeInitialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_06_finalizeInitialize();
    }

}
