package org.nuiton.jaxx.demo.feature.validation.list;

/*-
 * #%L
 * JAXX :: Demo
 * %%
 * Copyright (C) 2008 - 2020 Code Lutin, Ultreia.io
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.awt.BorderLayout;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jdesktop.swingx.JXTable;
import org.nuiton.jaxx.demo.DemoPanel;
import org.nuiton.jaxx.demo.entities.People;
import org.nuiton.jaxx.runtime.JAXXContext;
import org.nuiton.jaxx.runtime.JAXXObjectDescriptor;
import org.nuiton.jaxx.runtime.JAXXUtil;
import org.nuiton.jaxx.runtime.binding.DefaultJAXXBinding;
import org.nuiton.jaxx.runtime.swing.SwingUtil;
import org.nuiton.jaxx.runtime.swing.Table;
import org.nuiton.jaxx.validator.swing.SwingListValidatorMessageTableModel;
import org.nuiton.validator.bean.list.BeanListValidator;
import static io.ultreia.java4all.i18n.I18n.n;
import static io.ultreia.java4all.i18n.I18n.t;

public class ListBeanValidationDemo extends DemoPanel {

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JSCROLL_PANE0_COLUMN_HEADER_VIEW = "$JScrollPane0.columnHeaderView";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVWQW8bRRQeu3HSJDRpk0KBChGo2wBt1wkSHEiBNglVYzlNFadRRCTEeHewxxnvTGdn4w2HHjhw4w9w4MoF9T9UPSFx4Zr/gNSfwHu79m6crjfbOlJGyZv3vv3e93a+2b/+IyVPk1tSNy3X50a6VpsGgaV91/AOs6r39va2Gm1mm3Xm2ZorIzWJfgpFUtwn004c9wyx9muAVImQKohU6SFV1mRHSZe5J4BWamTKM0eCeS3GjCGfDC22Pa9SjzNXAuXr3rNSWac9659fl48LbP33IiGBAvqz0PbN1wBIuh6rkSJ3DJmrtekhrQjqNoGc5m4TGrqAsTVBPe8h7bAn5CmZqJFxRTWAGXL7jeQJ4UKoQBkyXV5nHfmIukwsGbJ2ugUHNq2fGDW+ZtYhFdyhhsOm4J6xarCsMuruxnHEUipEHzek1JEOE4Z8/Vqoj5hUgu3QhmCbWJ/gTfZSpTZk6QRmHLYawCZCQV7Ib7e/l8DMMq2lTh6Q0naC6HVhElYd1wG4TeZ5tJlKc6IcRkHOa8PeiAg1TMOiybj2fLnan8Uczj7opUZRTHo7zr0MRGiIUbe1FIJhjiFXBuqiLdzBqncTLeNiQ64izTYcvQMjVVQYWNW9mN7VV+gt4//vD9KZpo6z4cA7x82RIfMDLFZ9Axpg4kdx/oyGt+CQ9Uswen0woygPUqJ9Dp+ncLhQPtHwEgY/wOWzOGEqmf1pheN2byk4zDeGjQ7Mw0rMIznHhX1S0j6EYezDfQutZxuyItO5Ntx08DFh4i/Pnuo/uy+P+05zBcgtnFV1wlTh2CstFdOGI7fZyGZ8w0Vlk6qVfTLpMQGOHDruYjbzei8T2AOLS4hkIZL1gHotQCtNHD9/8c6P/54jxftkSkjq3KeYv0EmTUuDYlI4gfr2bkjure55WC/C7zmYi6LcNTvcPgAWY0b7IO3FDm3DrCBWV9SGGcEbsbyEce6eihe+CEDOxWw5Y/bPtl7+/cdv15/3JS1AM+U8lYmspe/JOHcFd1lo3z1nTrXraeUx35GJ7aYZMQErnqjWwVxY36m+DNevXlGrYMi4oEcSjhSZuYPHeKHBXQd0+CbwsWQ1bAn/Wi/gOqVyIDakhkfjfjUd5b08KC3Gmy3gNXcnEmeBGrjKGr5hQ7idjYrhjRF5lbpww7Zw+/Gbg8xT38g1DbcW25bdOlxCkV5DID/Mwyu8IDOaOxvkLHk+zkFjzLDAZLRSzsXiSQbC4sgIn+ZC2MpQ4mYuhJ0MDvkQsqaRD+GHkTiAQdpS+B33AaNwpHc562Ywup2LkZ3BqJKD0QyenW3m8Z/Dj6UR0S7bTIjIk+Gr8TsXL25nJEwMtzJUysNqXoMr9EndE0J2RyQFnzNeHy+Hav8D2teT9X0NAAA=";
    private static final Logger log = LogManager.getLogger(ListBeanValidationDemo.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JButton addIdentity;
    protected JXTable dataTable;
    protected JScrollPane dataTableScrollePane;
    protected JTable errorTable;
    protected SwingListValidatorMessageTableModel errorTableModel;
    protected ListBeanValidationDemoHandler handler;
    protected PeopleTableModel model;
    protected JButton ok;
    protected JButton removeIdentity;
    protected BeanListValidator<People> validator;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private ListBeanValidationDemo $DemoPanel0;
    private JPanel $JPanel0;
    private JPanel $JPanel1;
    private JPanel $JPanel2;
    private JScrollPane $JScrollPane0;
    private Table $Table0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    protected String[] getSources() {
        return addDefaultSources(
            "ListBeanValidationDemo.css",
            "/org.nuiton.jaxx.demo.entities.People.java",
            "/org.nuiton.jaxx.demo.entities.People-error-validation.xml",
            "/org.nuiton.jaxx.demo.entities.People-info-validation.xml",
            "/org.nuiton.jaxx.demo.entities.People-warning-validation.xml",
            "ListBeanValidationDemoHandler.java",
            "PeopleTableModel.java"
        );
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public ListBeanValidationDemo(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
    }

    public ListBeanValidationDemo(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
    }

    public ListBeanValidationDemo(LayoutManager param0) {
        super(param0);
    }

    public ListBeanValidationDemo(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
    }

    public ListBeanValidationDemo() {
        
    }

    public ListBeanValidationDemo(JAXXContext param0) {
        super(param0);
    }

    public ListBeanValidationDemo(boolean param0) {
        super(param0);
    }

    public ListBeanValidationDemo(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__addIdentity(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.addPeople();
    }

    public void doActionPerformed__on__ok(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        JOptionPane.showMessageDialog(this, ok.getText() + " clicked!", "onActionPerformed", JOptionPane.INFORMATION_MESSAGE);
    }

    public void doActionPerformed__on__removeIdentity(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.removePeople();
    }

    public void doTableChanged__on__errorTableModel(TableModelEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.updateOkEnabled();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JButton getAddIdentity() {
        return addIdentity;
    }

    public JXTable getDataTable() {
        return dataTable;
    }

    public JScrollPane getDataTableScrollePane() {
        return dataTableScrollePane;
    }

    public JTable getErrorTable() {
        return errorTable;
    }

    public SwingListValidatorMessageTableModel getErrorTableModel() {
        return errorTableModel;
    }

    public ListBeanValidationDemoHandler getHandler() {
        return handler;
    }

    public PeopleTableModel getModel() {
        return model;
    }

    public JButton getOk() {
        return ok;
    }

    public JButton getRemoveIdentity() {
        return removeIdentity;
    }

    public BeanListValidator<People> getValidator() {
        return validator;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected JPanel get$JPanel1() {
        return $JPanel1;
    }

    protected JPanel get$JPanel2() {
        return $JPanel2;
    }

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected Table get$Table0() {
        return $Table0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToDataTableScrollePane() {
        dataTableScrollePane.getViewport().add(dataTable);
    }

    protected void createAddIdentity() {
        $objectMap.put("addIdentity", addIdentity = new JButton());
        
        addIdentity.setName("addIdentity");
        addIdentity.setText(t("jaxx.demo.action.add"));
        addIdentity.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__addIdentity"));
    }

    protected void createDataTable() {
        $objectMap.put("dataTable", dataTable = new JXTable());
        
        dataTable.setName("dataTable");
        dataTable.setAutoCreateRowSorter(true);
    }

    protected void createDataTableScrollePane() {
        $objectMap.put("dataTableScrollePane", dataTableScrollePane = new JScrollPane());
        
        dataTableScrollePane.setName("dataTableScrollePane");
    }

    protected void createErrorTable() {
        $objectMap.put("errorTable", errorTable = new JTable());
        
        errorTable.setName("errorTable");
        errorTable.setAutoCreateRowSorter(true);
        errorTable.setAutoResizeMode(2);
        errorTable.setCellSelectionEnabled(false);
        errorTable.setRowSelectionAllowed(true);
        errorTable.setSelectionMode(0);
    }

    protected void createErrorTableModel() {
        $objectMap.put("errorTableModel", errorTableModel = new SwingListValidatorMessageTableModel());
        
        errorTableModel.addTableModelListener(JAXXUtil.getEventListener(TableModelListener.class, "tableChanged", this, "doTableChanged__on__errorTableModel"));
    }

    protected void createModel() {
        $objectMap.put("model", model = new PeopleTableModel());
    }

    protected void createOk() {
        $objectMap.put("ok", ok = new JButton());
        
        ok.setName("ok");
        ok.setText(t("jaxx.demo.action.ok"));
        ok.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__ok"));
    }

    protected void createRemoveIdentity() {
        $objectMap.put("removeIdentity", removeIdentity = new JButton());
        
        removeIdentity.setName("removeIdentity");
        removeIdentity.setText(t("jaxx.demo.action.remove"));
        removeIdentity.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__removeIdentity"));
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = BeanListValidator.newValidator(People.class, null));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    protected void $initialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $DemoPanel0 = this;
        handler = new ListBeanValidationDemoHandler();
        handler.beforeInit(this);
        super.$initialize();
        handler.afterInit(this);
    }

    @Override
    protected void $initialize_01_createComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_01_createComponents();
        $objectMap.put("$DemoPanel0", $DemoPanel0);
        createModel();
        createValidator();
        createErrorTableModel();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        SwingUtil.setComponentHeight($JPanel0,120);
        $JPanel0.setLayout(new GridLayout());
        SwingUtil.setComponentWidth($JPanel0,250);
        createDataTableScrollePane();
        createDataTable();
        // inline creation of $JPanel1
        $objectMap.put("$JPanel1", $JPanel1 = new JPanel());
        
        $JPanel1.setName("$JPanel1");
        $JPanel1.setLayout(new GridLayout(1,3,0,0));
        createAddIdentity();
        createRemoveIdentity();
        createOk();
        // inline creation of $JPanel2
        $objectMap.put("$JPanel2", $JPanel2 = new JPanel());
        
        $JPanel2.setName("$JPanel2");
        SwingUtil.setComponentHeight($JPanel2,200);
        $JPanel2.setLayout(new GridLayout());
        SwingUtil.setComponentWidth($JPanel2,500);
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createErrorTable();
        // inline creation of $DemoPanel0
        setName("$DemoPanel0");
        setLayout(new BorderLayout());
    }

    @Override
    protected void $initialize_02_registerDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_02_registerDataBindings();
        // register 1 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_$JSCROLL_PANE0_COLUMN_HEADER_VIEW, true) {
        
            @Override
            public void applyDataBinding() {
                if (errorTable != null) {
                    errorTable.addPropertyChangeListener("tableHeader", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (errorTable != null) {
                    $JScrollPane0.setColumnHeaderView(errorTable.getTableHeader());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (errorTable != null) {
                    errorTable.removePropertyChangeListener("tableHeader", this);
                }
            }
        });
    }

    @Override
    protected void $initialize_03_finalizeCreateComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_03_finalizeCreateComponents();
        // inline complete setup of $DemoPanel0
        add($Table0, BorderLayout.CENTER);
        // inline complete setup of $Table0
        $Table0.add($JPanel0, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(6, 3, 0, 0), 0, 0));
        $Table0.add($JPanel1, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JPanel2, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JPanel0
        $JPanel0.add(dataTableScrollePane, BorderLayout.CENTER);
        addChildrenToDataTableScrollePane();
        // inline complete setup of $JPanel1
        $JPanel1.add(addIdentity);
        $JPanel1.add(removeIdentity);
        $JPanel1.add(ok);
        // inline complete setup of $JPanel2
        $JPanel2.add($JScrollPane0);
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(errorTable);
    }

    @Override
    protected void $initialize_04_applyDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_04_applyDataBindings();
    }

    @Override
    protected void $initialize_05_setProperties() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_05_setProperties();
        
        // apply 8 property setters
        $JPanel0.setBorder(BorderFactory.createTitledBorder("Form"));
        dataTable.setModel(model);
        $JPanel2.setBorder(BorderFactory.createTitledBorder("Messages"));
        errorTable.setModel(errorTableModel);
    }

    @Override
    protected void $initialize_06_finalizeInitialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_06_finalizeInitialize();
    }

}
