package org.nuiton.jaxx.demo.feature.nav;

/*-
 * #%L
 * JAXX :: Demo
 * %%
 * Copyright (C) 2008 - 2020 Code Lutin, Ultreia.io
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.awt.BorderLayout;
import java.awt.LayoutManager;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTree;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jdesktop.swingx.JXTreeTable;
import org.nuiton.jaxx.demo.DemoPanel;
import org.nuiton.jaxx.demo.entities.DemoDataProvider;
import org.nuiton.jaxx.demo.feature.nav.tree.NavDemoTreeHelper;
import org.nuiton.jaxx.demo.feature.nav.treetable.NavDemoTreeTableHelper;
import org.nuiton.jaxx.runtime.JAXXContext;
import org.nuiton.jaxx.runtime.JAXXObjectDescriptor;
import org.nuiton.jaxx.runtime.JAXXUtil;
import org.nuiton.jaxx.runtime.swing.CardLayout2;
import org.nuiton.jaxx.runtime.swing.TabInfo;
import static io.ultreia.java4all.i18n.I18n.t;

public class NavDemo extends DemoPanel {

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAK2Wz28bRRTHxy52SNKmJa1aKg4NJKE/aNeUA0gklJakVWq5TdREKDQSYrw7iSeMZ4aZWWfTQw8cuPEPcODKBfV/qDghceGa/wGpfwLv7W527bJ2FkwOTjTz3ud935uZr/PrX6RmDbmpzJ4nQ+6U9PZpFHkmlI53mde8t7293t5nvltl1jdcO2VI8lOpkuoOmQ6ydeuIt9MCUiMhNZDUSEmNFdXVSjLZB1pqkSnrDgWzHcacI9eGJvvWNjazyKVIhyatVai6qNYfP9w+qrDVn6qERBrkz0DbH/wLQN71Gy1S5YEjs6192qMNQeUeiDNc7kFDZ3BtRVBrH9Mu+448JxMtUtfUAMyRW/9pPDEuRkXakemFVdZVG1Qy8SHM7PUWAtj0dhl1oWGepD3vMe1hgtYxou7IGV9JB5Va9FCFIOr6sCnYA+jJW6EmSEI/yhmnA+rohlE9HjAD516oAmpwx5n1sP5qX0LOmXKGsTUmNFI+ObEXjD5uaCvLzHFnMWCLtkXGvFeK6TClH9zHyOmTVgvucPKOXMRzjtIRNTePNzByMp/0QhNAbRbgFhzWpYGkfAvD387LLMDOQ7mrIGNx9Nmkgbq/4qZvlBCFFfMtDH8ny5qBOfA96riS2Lwjbw0KhTWMfPefEm/jwtyQ+vHm/GCp84Ol4jk7cgXb3Acr+dYpnZSNvOZ2FoHJ1zPGRHqB4QkO6IzfRDpLQ94fNjowEy83k/xdV3ZIzYSw7Mj8cB9DK3oCUYkJzQ83ISwTB37/4rn55eDV0bHzXABxcydl9Zks2IA2Cm8zR21nE9sJHReNR1Qv7cC9ZAIcOnbgq6OVb6aRoB5UxMfsIclbo7YDtNrE0cvfLn7z5ylSfUCmhKLBA4rxD8mk6xiYmBJBpD+/G4s7ffAmfJ5DmY7URWonM8voDXNtLgM4lTsRTOnq6Cllol6sv/r95x8XXx5PqgIaF8pk5tOqPSV1LgWXLHbp1IALXXlaWxYGKnfXIr+t4O8pnd7wj+PPT4v6nwX33lKh37kfaSqD5F7PLida5qiDL4h26BjMAxF34u7wr7txhcslKtTATZOncL8YcqUEpN5WBhwY9z8rprxXgnK5owx/Bq+QiuS5f0HNhhLcPxwTfKmH19z/v7GTu6D1luXPRo1vscwZdFWQeMwQNWUg00Yp9yW3vD3yOMugzsGLPLBPgLcGlw68ayweLjdHEK6VIqyPGM+NUoStsQlfjUVw5IKvRNiVK3Bt4B6efFY3S6n6emxCZ2xCdywC2Hv2L9ajE55COT3LIwgNIPwNYon71KIMAAA=";
    private static final Logger log = LogManager.getLogger(NavDemo.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel content;
    protected CardLayout2 contentLayout;
    protected DemoDataProvider dataProvider;
    protected NavDemoHandler handler;
    protected JTree navigationTree;
    protected JXTreeTable navigationTreeTable;
    protected JSplitPane splitPane;
    protected NavDemoTreeHelper treeHelper;
    protected NavDemoTreeTableHelper treeTableHelper;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private NavDemo $DemoPanel0;
    private JScrollPane $JScrollPane0;
    private JScrollPane $JScrollPane1;
    private JTabbedPane $JTabbedPane0;
    private TabInfo $TabInfo0;
    private TabInfo $TabInfo1;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    protected String[] getSources() {
        return addDefaultSources(
                "tree/NavDemoTreeNode.java",
                "tree/NavDemoTreeHelper.java",
                "tree/NavDemoTreeCellRenderer.java",
                "tree/ActorsTreeNodeLoador.java",
                "tree/MoviesTreeNodeLoador.java",
                "treetable/NavDemoTreeTableNode.java",
                "treetable/NavDemoTreeTableHelper.java",
                "treetable/ActorsTreeTableNodeLoador.java",
                "treetable/MoviesTreeTableNodeLoador.java"
         );
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public NavDemo(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
    }

    public NavDemo(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
    }

    public NavDemo(LayoutManager param0) {
        super(param0);
    }

    public NavDemo(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
    }

    public NavDemo() {
        
    }

    public NavDemo(JAXXContext param0) {
        super(param0);
    }

    public NavDemo(boolean param0) {
        super(param0);
    }

    public NavDemo(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JPanel getContent() {
        return content;
    }

    public CardLayout2 getContentLayout() {
        return contentLayout;
    }

    public DemoDataProvider getDataProvider() {
        return dataProvider;
    }

    public NavDemoHandler getHandler() {
        return handler;
    }

    public JTree getNavigationTree() {
        return navigationTree;
    }

    public JXTreeTable getNavigationTreeTable() {
        return navigationTreeTable;
    }

    public JSplitPane getSplitPane() {
        return splitPane;
    }

    public NavDemoTreeHelper getTreeHelper() {
        return treeHelper;
    }

    public NavDemoTreeTableHelper getTreeTableHelper() {
        return treeTableHelper;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected JScrollPane get$JScrollPane1() {
        return $JScrollPane1;
    }

    protected JTabbedPane get$JTabbedPane0() {
        return $JTabbedPane0;
    }

    protected TabInfo get$TabInfo0() {
        return $TabInfo0;
    }

    protected TabInfo get$TabInfo1() {
        return $TabInfo1;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToSplitPane() {
        splitPane.add($JTabbedPane0, JSplitPane.LEFT);
        splitPane.add(content, JSplitPane.RIGHT);
    }

    protected void createContent() {
        $objectMap.put("content", content = new JPanel());
        
        content.setName("content");
        content.setLayout(contentLayout);
    }

    protected void createContentLayout() {
        $objectMap.put("contentLayout", contentLayout = new CardLayout2());
    }

    protected void createDataProvider() {
        $objectMap.put("dataProvider", dataProvider = new DemoDataProvider());
    }

    protected void createNavigationTree() {
        $objectMap.put("navigationTree", navigationTree = new JTree());
        
        navigationTree.setName("navigationTree");
        if (navigationTree.getFont() != null) {
            navigationTree.setFont(navigationTree.getFont().deriveFont((float) 11));
        }
        navigationTree.setRootVisible(false);
        navigationTree.setShowsRootHandles(false);
    }

    protected void createNavigationTreeTable() {
        $objectMap.put("navigationTreeTable", navigationTreeTable = new JXTreeTable());
        
        navigationTreeTable.setName("navigationTreeTable");
        navigationTreeTable.setColumnControlVisible(true);
        if (navigationTreeTable.getFont() != null) {
            navigationTreeTable.setFont(navigationTreeTable.getFont().deriveFont((float) 11));
        }
        navigationTreeTable.setRootVisible(false);
        navigationTreeTable.setShowsRootHandles(false);
    }

    protected void createSplitPane() {
        $objectMap.put("splitPane", splitPane = new JSplitPane());
        
        splitPane.setName("splitPane");
        splitPane.setOneTouchExpandable(true);
    }

    protected void createTreeHelper() {
        $objectMap.put("treeHelper", treeHelper = new NavDemoTreeHelper(getDataProvider()));
    }

    protected void createTreeTableHelper() {
        $objectMap.put("treeTableHelper", treeTableHelper = new NavDemoTreeTableHelper(getDataProvider()));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    protected void $initialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $DemoPanel0 = this;
        handler = new NavDemoHandler();
        handler.beforeInit(this);
        super.$initialize();
        handler.afterInit(this);
    }

    @Override
    protected void $initialize_01_createComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_01_createComponents();
        $objectMap.put("$DemoPanel0", $DemoPanel0);
        createContentLayout();
        createDataProvider();
        createTreeHelper();
        createTreeTableHelper();
        createSplitPane();
        // inline creation of $JTabbedPane0
        $objectMap.put("$JTabbedPane0", $JTabbedPane0 = new JTabbedPane());
        
        $JTabbedPane0.setName("$JTabbedPane0");
        // inline creation of $TabInfo0
        $objectMap.put("$TabInfo0", $TabInfo0 = new TabInfo("$TabInfo0"));
        
        $TabInfo0.setTitle(t("jaxxdemo.tree.tabtitle"));
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createNavigationTree();
        // inline creation of $TabInfo1
        $objectMap.put("$TabInfo1", $TabInfo1 = new TabInfo("$TabInfo1"));
        
        $TabInfo1.setTitle(t("jaxxdemo.treeTable.tabtitle"));
        // inline creation of $JScrollPane1
        $objectMap.put("$JScrollPane1", $JScrollPane1 = new JScrollPane());
        
        $JScrollPane1.setName("$JScrollPane1");
        createNavigationTreeTable();
        createContent();
        // inline creation of $DemoPanel0
        setName("$DemoPanel0");
        setLayout(new BorderLayout());
    }

    @Override
    protected void $initialize_02_registerDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_02_registerDataBindings();
        // register 0 data bindings
    }

    @Override
    protected void $initialize_03_finalizeCreateComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_03_finalizeCreateComponents();
        // inline complete setup of $DemoPanel0
        add(splitPane, BorderLayout.CENTER);
        addChildrenToSplitPane();
        // inline complete setup of $JTabbedPane0
        $JTabbedPane0.add($JScrollPane0);
        $JTabbedPane0.add($JScrollPane1);
        $TabInfo0.install($JTabbedPane0, 0);
        $TabInfo1.install($JTabbedPane0, 1);
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(navigationTree);
        // inline complete setup of $JScrollPane1
        $JScrollPane1.getViewport().add(navigationTreeTable);
    }

    @Override
    protected void $initialize_04_applyDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_04_applyDataBindings();
    }

    @Override
    protected void $initialize_05_setProperties() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_05_setProperties();
        
        // apply 10 property setters
        $JScrollPane0.setBorder(null);
        $JScrollPane0.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);
        $JScrollPane0.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_NEVER);
        navigationTree.setModel(treeHelper.createModel());
        $JScrollPane1.setBorder(null);
        $JScrollPane1.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);
        $JScrollPane1.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_NEVER);
        navigationTreeTable.setTreeTableModel(treeTableHelper.createModel());
    }

    @Override
    protected void $initialize_06_finalizeInitialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_06_finalizeInitialize();
    }

}
