package org.nuiton.jaxx.demo.component.swing;

/*-
 * #%L
 * JAXX :: Demo
 * %%
 * Copyright (C) 2008 - 2020 Code Lutin, Ultreia.io
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.awt.LayoutManager;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuiton.jaxx.demo.DemoPanel;
import org.nuiton.jaxx.runtime.JAXXContext;
import org.nuiton.jaxx.runtime.JAXXObjectDescriptor;
import org.nuiton.jaxx.runtime.JAXXUtil;
import org.nuiton.jaxx.runtime.binding.DefaultJAXXBinding;
import org.nuiton.jaxx.runtime.swing.VBox;
import static io.ultreia.java4all.i18n.I18n.t;

public class JSpinnerDemo extends DemoPanel {

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$VBOX0_SPACING = "$VBox0.spacing";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAK2UTU8TQRjHn1baUhCEaojx1Ei1xJddq0eIb5BGmyLGJobYi9PupAzZnR1nZmW5cPDgzS/gwasXw3cgnky8eOU7mPARfGa3L1TbUoE9zLYz/+c3/3nmefbbb0gpCXd82bJ4wLTPrW0ShpYMuGYetSpPNjc3Gtu0qdeoakomtC8hfhJJSNZh2unOKw1WvYokOybZhmS3Sfaq7wmfU34MtFyFKaV3Xaq2KNUaloYGN5Wya13lcigC2d5roOtBe/38WDpM0LXPSYBQoP0MHvv2fwB6p56oQpI5GnLVbfKe2C7hLTQnGW/hgWbM3KpLlHpBPPoO9iBThbQgEmEa7p4qPREuQoVCw3RhjXr+S8Kpe09D6e8jOLhoNTs0S+2gL6tSE4xzKk2kEBErrWGyUKmSRoTJGdthRx3NGlG2q82omKDhSp+0De4Xpwuvn/ohYq8PS3AcbVT9kR1LJfN/1gy5f9buj1h7cHxNws1h+2NBWb2C6t1tog4pGeC0hsXhtWzK8RWq4kJcHF6IZptI+GF/T37dOTrsVF8WzeVPijrWaFgKQvoC88+Mt0tx6QWaufY6Ect1BFIXuzTqwuJo57W2Et2ji3lDsgzJekbUFtJSmcOD7wtvf12AZBmmXJ84ZWL0zyGrtyRmzHedUDx6HJm7uDOJ45yxibfgmjso+1glsysO0STfYNzBm34YYp6Ko/PUtbW/cfTjy6cbB51cJdBlYZzIXr5SbyDNuMs4jXq13YYDe3NaKBo4fq/HBnVdwrxnRLt18tFYGJSBCU1D7PPcSrx7nmj8MDQCTTEDJmgpOo/5dWts5rzDlHDJLnXWOfYvZ00jtU8PzHgkZF7gjcDMjYVh/DwwSpAm1ogRFAdjLp+IMdPWCCMLZyZcPTPhGhL+AJQ3CbRwBwAA";
    private static final Logger log = LogManager.getLogger(JSpinnerDemo.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JSpinner spinner;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JSpinnerDemo $DemoPanel0;
    private JLabel $JLabel0;
    private JLabel $JLabel1;
    private JLabel $JLabel2;
    private JLabel $JLabel3;
    private VBox $VBox0;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public JSpinnerDemo(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
    }

    public JSpinnerDemo(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
    }

    public JSpinnerDemo(LayoutManager param0) {
        super(param0);
    }

    public JSpinnerDemo(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
    }

    public JSpinnerDemo() {
        
    }

    public JSpinnerDemo(JAXXContext param0) {
        super(param0);
    }

    public JSpinnerDemo(boolean param0) {
        super(param0);
    }

    public JSpinnerDemo(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JSpinner getSpinner() {
        return spinner;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected JLabel get$JLabel2() {
        return $JLabel2;
    }

    protected JLabel get$JLabel3() {
        return $JLabel3;
    }

    protected VBox get$VBox0() {
        return $VBox0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void createSpinner() {
        $objectMap.put("spinner", spinner = new JSpinner(new SpinnerNumberModel(0, 0, 50, 1)));
        
        spinner.setName("spinner");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    protected void $initialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $DemoPanel0 = this;
        super.$initialize();
    }

    @Override
    protected void $initialize_01_createComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_01_createComponents();
        $objectMap.put("$DemoPanel0", $DemoPanel0);
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(t("Spacing:"));
        $JLabel0.setDisplayedMnemonic(83);
        createSpinner();
        // inline creation of $VBox0
        $objectMap.put("$VBox0", $VBox0 = new VBox());
        
        $VBox0.setName("$VBox0");
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new JLabel());
        
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(t("Use the spinner to"));
        // inline creation of $JLabel2
        $objectMap.put("$JLabel2", $JLabel2 = new JLabel());
        
        $JLabel2.setName("$JLabel2");
        $JLabel2.setText(t("adjust the spacing"));
        // inline creation of $JLabel3
        $objectMap.put("$JLabel3", $JLabel3 = new JLabel());
        
        $JLabel3.setName("$JLabel3");
        $JLabel3.setText(t("between these lines"));
        // inline creation of $DemoPanel0
        setName("$DemoPanel0");
    }

    @Override
    protected void $initialize_02_registerDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_02_registerDataBindings();
        // register 1 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_$VBOX0_SPACING, true) {
        
            @Override
            public void applyDataBinding() {
                if (spinner != null) {
                    $bindingSources.put("spinner.getModel()", spinner.getModel());
                    spinner.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u0"));
                    spinner.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(org.nuiton.jaxx.demo.component.swing.JSpinnerDemo.this, BINDING_$VBOX0_SPACING));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (spinner != null) {
                    $VBox0.setSpacing((Integer) spinner.getValue());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (spinner != null) {
                    SpinnerModel $target = (SpinnerModel) $bindingSources.remove("spinner.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u0"));
                    }
                    spinner.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(org.nuiton.jaxx.demo.component.swing.JSpinnerDemo.this, BINDING_$VBOX0_SPACING));
                }
            }
        
            public void $pr$u0(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
    }

    @Override
    protected void $initialize_03_finalizeCreateComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_03_finalizeCreateComponents();
        // inline complete setup of $DemoPanel0
        add($JLabel0);
        add(spinner);
        add($VBox0);
        // inline complete setup of $VBox0
        $VBox0.add($JLabel1);
        $VBox0.add($JLabel2);
        $VBox0.add($JLabel3);
    }

    @Override
    protected void $initialize_04_applyDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_04_applyDataBindings();
    }

    @Override
    protected void $initialize_05_setProperties() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_05_setProperties();
        
        // apply 1 property setters
        $JLabel0.setLabelFor(spinner);
    }

    @Override
    protected void $initialize_06_finalizeInitialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_06_finalizeInitialize();
    }

}
