package org.nuiton.jaxx.demo.component.swing;

/*-
 * #%L
 * JAXX :: Demo
 * %%
 * Copyright (C) 2008 - 2020 Code Lutin, Ultreia.io
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.awt.LayoutManager;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuiton.jaxx.demo.DemoPanel;
import org.nuiton.jaxx.runtime.JAXXContext;
import org.nuiton.jaxx.runtime.JAXXObjectDescriptor;
import org.nuiton.jaxx.runtime.JAXXUtil;
import org.nuiton.jaxx.runtime.binding.DefaultJAXXBinding;
import org.nuiton.jaxx.runtime.swing.HBox;
import org.nuiton.jaxx.runtime.swing.VBox;
import static io.ultreia.java4all.i18n.I18n.t;

public class JPasswordFieldDemo extends DemoPanel {

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JLABEL1_TEXT = "$JLabel1.text";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKWUz08TQRTHXystv0XAmOhFIhU06q7EgyYQFCENkiJEEkPsxWl30g6Zzowzs3TxwMGDN/8BD169GP4H4snEi1f+BxP+BN9sl7aQFivuYbadfe8z3/f2fffbb8gYDfelrngiZFYKb4dEkadDYVmNemtL29sbpR1ativUlDVTVmpoXKk0pIswHDT3jQWvWECS3yD5juQnJH9Z1pQUVLSB5gswZOwep6ZKqbVwp2ty2Rh/qxk5H6lQJ2d1VN3prJ8f545SdOVzGiBSKD+LZd/7B0Cr6r4CpFlgYaKwQ3aJz4mooDjNRAULGnV7y5wY85LU6DvYh/4CZBXRCLPw4ELtiXExKlIWhnMrtCY3iaD8oYXHZ0sI8KFXPqF5po66vLVNJNSlDvKM8sDlKxUTsxayudfPZYSoW9260WC4KJcy2Ja52lPmapI50swcyK0VSCkuYMI1LDrRGe+6oLFWrEq0W7hxKvZUTWdyEv6c+381OVvDTDedOF9ea75arzpVhIwOcdvCdPfRdtP5CqMaczndfS7dMXHgh4N9/bV+fNQ+jFN/y2rzHU6G0lJRbZnTNtaYxNAy7q8TNV+EQUM5mjY25ez5yreSSFSPKsYdyXMkb5WYKtIy/UeH36+9/XUJ0nkY4pIEeeLiX8CgrWrsmORBpJ4+i8WN1AdwveJkWpisSs3eS2EJX+KsImqxByYWmOBM0Cli0TSl0NLFCNs2e37bmioPNo5/fPl0+/CkdSkUnesls9W+zBvINjTETk5M2tG5w8rQMJAtB3byZMrdR1ViqZvxOt2pIeO77o2V29rhQmei0N1m42Lcr7s9Awe4m/K81BYuLwTEkqkSEwG6Y7Ezc7IHZp+l0Xm6emGMB8woTvZosC7wYyNY+b+AbvuJWx51JlxHwh+a9Jx+ygYAAA==";
    private static final Logger log = LogManager.getLogger(JPasswordFieldDemo.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPasswordField password;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JPasswordFieldDemo $DemoPanel0;
    private HBox $HBox0;
    private JLabel $JLabel0;
    private JLabel $JLabel1;
    private VBox $VBox0;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public JPasswordFieldDemo(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
    }

    public JPasswordFieldDemo(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
    }

    public JPasswordFieldDemo(LayoutManager param0) {
        super(param0);
    }

    public JPasswordFieldDemo(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
    }

    public JPasswordFieldDemo() {
        
    }

    public JPasswordFieldDemo(JAXXContext param0) {
        super(param0);
    }

    public JPasswordFieldDemo(boolean param0) {
        super(param0);
    }

    public JPasswordFieldDemo(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JPasswordField getPassword() {
        return password;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected HBox get$HBox0() {
        return $HBox0;
    }

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected VBox get$VBox0() {
        return $VBox0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void createPassword() {
        $objectMap.put("password", password = new JPasswordField());
        
        password.setName("password");
        password.setColumns(15);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    protected void $initialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $DemoPanel0 = this;
        super.$initialize();
    }

    @Override
    protected void $initialize_01_createComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_01_createComponents();
        $objectMap.put("$DemoPanel0", $DemoPanel0);
        // inline creation of $VBox0
        $objectMap.put("$VBox0", $VBox0 = new VBox());
        
        $VBox0.setName("$VBox0");
        $VBox0.setHorizontalAlignment(0);
        $VBox0.setVerticalAlignment(0);
        // inline creation of $HBox0
        $objectMap.put("$HBox0", $HBox0 = new HBox());
        
        $HBox0.setName("$HBox0");
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(t("Password:"));
        $JLabel0.setDisplayedMnemonic(80);
        createPassword();
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new JLabel());
        
        $JLabel1.setName("$JLabel1");
        // inline creation of $DemoPanel0
        setName("$DemoPanel0");
    }

    @Override
    protected void $initialize_02_registerDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_02_registerDataBindings();
        // register 1 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_$JLABEL1_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (password != null) {
                    $bindingSources.put("password.getDocument()", password.getDocument());
                    password.getDocument().addDocumentListener( JAXXUtil.getEventListener(DocumentListener.class, this, "$pr$u0"));
                    password.addPropertyChangeListener("document", JAXXUtil.getDataBindingUpdateListener(org.nuiton.jaxx.demo.component.swing.JPasswordFieldDemo.this, BINDING_$JLABEL1_TEXT));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (password != null) {
                    $JLabel1.setText("You entered: " + (new String(password.getPassword())));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (password != null) {
                    Document $target = (Document) $bindingSources.remove("password.getDocument()");
                    if ($target != null) {
                        $target.removeDocumentListener( JAXXUtil.getEventListener(DocumentListener.class, this, "$pr$u0"));
                    }
                    password.removePropertyChangeListener("document", JAXXUtil.getDataBindingUpdateListener(org.nuiton.jaxx.demo.component.swing.JPasswordFieldDemo.this, BINDING_$JLABEL1_TEXT));
                }
            }
        
            public void $pr$u0(DocumentEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
    }

    @Override
    protected void $initialize_03_finalizeCreateComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_03_finalizeCreateComponents();
        // inline complete setup of $DemoPanel0
        add($VBox0);
        // inline complete setup of $VBox0
        $VBox0.add($HBox0);
        $VBox0.add($JLabel1);
        // inline complete setup of $HBox0
        $HBox0.add($JLabel0);
        $HBox0.add(password);
    }

    @Override
    protected void $initialize_04_applyDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_04_applyDataBindings();
    }

    @Override
    protected void $initialize_05_setProperties() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_05_setProperties();
        
        // apply 1 property setters
        $JLabel0.setLabelFor(password);
    }

    @Override
    protected void $initialize_06_finalizeInitialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_06_finalizeInitialize();
    }

}
