package org.nuiton.jaxx.demo;

/*-
 * #%L
 * JAXX :: Demo
 * %%
 * Copyright (C) 2008 - 2020 Code Lutin, Ultreia.io
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.JTree;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuiton.jaxx.demo.tree.DemoCellRenderer;
import org.nuiton.jaxx.demo.tree.DemoTreeHelper;
import org.nuiton.jaxx.runtime.JAXXBinding;
import org.nuiton.jaxx.runtime.JAXXContext;
import org.nuiton.jaxx.runtime.JAXXObject;
import org.nuiton.jaxx.runtime.JAXXObjectDescriptor;
import org.nuiton.jaxx.runtime.JAXXUtil;
import org.nuiton.jaxx.runtime.binding.DefaultJAXXBinding;
import org.nuiton.jaxx.runtime.binding.SimpleJAXXObjectBinding;
import org.nuiton.jaxx.runtime.context.DefaultJAXXContext;
import org.nuiton.jaxx.runtime.swing.CardLayout2;
import org.nuiton.jaxx.runtime.swing.SwingUtil;
import org.nuiton.jaxx.runtime.swing.help.JAXXHelpUI;
import org.nuiton.jaxx.widgets.status.StatusMessagePanel;
import static io.ultreia.java4all.i18n.I18n.t;

public class DemoUI extends JFrame implements JAXXHelpUI<DemoHelpBroker>, JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_MAIN_FRAME_ICON_IMAGE = "mainFrame.iconImage";
    public static final String BINDING_MAIN_FRAME_UNDECORATED = "mainFrame.undecorated";
    public static final String BINDING_MENU_FILE_FULLSCREEN_VISIBLE = "menuFileFullscreen.visible";
    public static final String BINDING_MENU_FILE_LANGUAGE_FR_ENABLED = "menuFileLanguageFR.enabled";
    public static final String BINDING_MENU_FILE_LANGUAGE_UK_ENABLED = "menuFileLanguageUK.enabled";
    public static final String BINDING_MENU_FILE_NORMALSCREEN_VISIBLE = "menuFileNormalscreen.visible";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    private static final Logger log = LogManager.getLogger(DemoUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected DemoHelpBroker broker;
    protected DemoConfig config;
    protected JPanel content;
    protected CardLayout2 contentLayout;
    protected DemoUIHandler handler;
    protected DemoUI mainFrame;
    protected JPanel mainPane;
    protected JMenuBar menu;
    protected JMenu menuFile;
    protected JMenuItem menuFileConfiguration;
    protected JMenuItem menuFileExit;
    protected JMenuItem menuFileFullscreen;
    protected JMenu menuFileLanguage;
    protected JMenuItem menuFileLanguageFR;
    protected JMenuItem menuFileLanguageUK;
    protected JMenuItem menuFileNormalscreen;
    protected JMenu menuHelp;
    protected JMenuItem menuHelpAbout;
    protected JMenuItem menuHelpHelp;
    protected JMenuItem menuHelpSite;
    protected JTree navigation;
    protected JScrollPane navigationPane;
    protected StatusMessagePanel p;
    protected JButton showHelp;
    protected JSplitPane splitPane;
    protected DemoTreeHelper treeHelper;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JSeparator $JSeparator0;
    private JSeparator $JSeparator1;
    private JToolBar $JToolBar0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    public boolean acceptLocale(Locale l, String expected) {
      return l !=null && l.toString().equals(expected);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public DemoUI() {
        $initialize();
    }

    public DemoUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public DemoUI(String param0, GraphicsConfiguration param1) {
        super(param0 ,param1);
        $initialize();
    }

    public DemoUI(JAXXContext parentContext, String param1, GraphicsConfiguration param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public DemoUI(GraphicsConfiguration param0) {
        super(param0);
        $initialize();
    }

    public DemoUI(JAXXContext parentContext, GraphicsConfiguration param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public DemoUI(String param0) {
        super(param0);
        $initialize();
    }

    public DemoUI(JAXXContext parentContext, String param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if ($bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if ($bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if ($bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__menuFileConfiguration(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.showConfig(this);
    }

    public void doActionPerformed__on__menuFileExit(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.close(this);
    }

    public void doActionPerformed__on__menuFileFullscreen(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.changeScreen(this, true);
    }

    public void doActionPerformed__on__menuFileLanguageFR(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.changeLanguage(this, Locale.FRANCE);
    }

    public void doActionPerformed__on__menuFileLanguageUK(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.changeLanguage(this, Locale.UK);
    }

    public void doActionPerformed__on__menuFileNormalscreen(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.changeScreen(this, false);
    }

    public void doActionPerformed__on__menuHelpAbout(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.showAbout(this);
    }

    public void doActionPerformed__on__menuHelpHelp(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.showHelp(this, null);
    }

    public void doActionPerformed__on__menuHelpSite(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.gotoSite(this);
    }

    public void doWindowClosing__on__mainFrame(WindowEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.close(mainFrame);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public DemoHelpBroker getBroker() {
        return broker;
    }

    public DemoConfig getConfig() {
        return config;
    }

    public JPanel getContent() {
        return content;
    }

    public CardLayout2 getContentLayout() {
        return contentLayout;
    }

    public DemoUIHandler getHandler() {
        return handler;
    }

    public JPanel getMainPane() {
        return mainPane;
    }

    public JMenuBar getMenu() {
        return menu;
    }

    public JMenu getMenuFile() {
        return menuFile;
    }

    public JMenuItem getMenuFileConfiguration() {
        return menuFileConfiguration;
    }

    public JMenuItem getMenuFileExit() {
        return menuFileExit;
    }

    public JMenuItem getMenuFileFullscreen() {
        return menuFileFullscreen;
    }

    public JMenu getMenuFileLanguage() {
        return menuFileLanguage;
    }

    public JMenuItem getMenuFileLanguageFR() {
        return menuFileLanguageFR;
    }

    public JMenuItem getMenuFileLanguageUK() {
        return menuFileLanguageUK;
    }

    public JMenuItem getMenuFileNormalscreen() {
        return menuFileNormalscreen;
    }

    public JMenu getMenuHelp() {
        return menuHelp;
    }

    public JMenuItem getMenuHelpAbout() {
        return menuHelpAbout;
    }

    public JMenuItem getMenuHelpHelp() {
        return menuHelpHelp;
    }

    public JMenuItem getMenuHelpSite() {
        return menuHelpSite;
    }

    public JTree getNavigation() {
        return navigation;
    }

    public JScrollPane getNavigationPane() {
        return navigationPane;
    }

    public StatusMessagePanel getP() {
        return p;
    }

    public JButton getShowHelp() {
        return showHelp;
    }

    public JSplitPane getSplitPane() {
        return splitPane;
    }

    public DemoTreeHelper getTreeHelper() {
        return treeHelper;
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Other methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void registerHelpId(DemoHelpBroker broker, Component component, String helpId) {
        broker.installUI(component, helpId);
    }

    @Override
    public void showHelp(String helpId) {
        getBroker().showHelp(this, helpId);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JSeparator get$JSeparator0() {
        return $JSeparator0;
    }

    protected JSeparator get$JSeparator1() {
        return $JSeparator1;
    }

    protected JToolBar get$JToolBar0() {
        return $JToolBar0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToMainFrame() {
        add(mainPane);
        mainFrame.setJMenuBar(menu);
    }

    protected void addChildrenToMainPane() {
        mainPane.add(splitPane, BorderLayout.CENTER);
        mainPane.add(p, BorderLayout.SOUTH);
    }

    protected void addChildrenToMenu() {
        menu.add(menuFile);
        menu.add(menuHelp);
        menu.add($JToolBar0);
    }

    protected void addChildrenToMenuFile() {
        menuFile.add(menuFileConfiguration);
        menuFile.add(menuFileLanguage);
        menuFile.add($JSeparator0);
        menuFile.add(menuFileFullscreen);
        menuFile.add(menuFileNormalscreen);
        menuFile.add($JSeparator1);
        menuFile.add(menuFileExit);
    }

    protected void addChildrenToMenuFileLanguage() {
        menuFileLanguage.add(menuFileLanguageFR);
        menuFileLanguage.add(menuFileLanguageUK);
    }

    protected void addChildrenToMenuHelp() {
        menuHelp.add(menuHelpHelp);
        menuHelp.add(menuHelpSite);
        menuHelp.add(menuHelpAbout);
    }

    protected void addChildrenToNavigationPane() {
        navigationPane.getViewport().add(navigation);
    }

    protected void addChildrenToSplitPane() {
        splitPane.add(navigationPane, JSplitPane.LEFT);
        splitPane.add(content, JSplitPane.RIGHT);
    }

    protected void createBroker() {
        $objectMap.put("broker", broker = new DemoHelpBroker("ui.main.menu"));
    }

    protected void createConfig() {
        $objectMap.put("config", config = getContextValue(DemoConfig.class));
    }

    protected void createContent() {
        $objectMap.put("content", content = new JPanel());
        
        content.setName("content");
        content.setLayout(contentLayout);
        content.putClientProperty("help", "ui.main.body.db.view.content");
    }

    protected void createContentLayout() {
        $objectMap.put("contentLayout", contentLayout = new CardLayout2());
        
        contentLayout.setUseOnlyVisibleComponentDimension(true);
    }

    protected void createMainPane() {
        $objectMap.put("mainPane", mainPane = new JPanel());
        
        mainPane.setName("mainPane");
        mainPane.setLayout(new BorderLayout());
    }

    protected void createMenu() {
        $objectMap.put("menu", menu = new JMenuBar());
        
        menu.setName("menu");
        menu.putClientProperty("help", "ui.main.menu");
    }

    protected void createMenuFile() {
        $objectMap.put("menuFile", menuFile = new JMenu());
        
        menuFile.setName("menuFile");
        menuFile.setText(t("jaxxdemo.menu.file"));
        menuFile.putClientProperty("help", "ui.main.menu.file");
    }

    protected void createMenuFileConfiguration() {
        $objectMap.put("menuFileConfiguration", menuFileConfiguration = new JMenuItem());
        
        menuFileConfiguration.setName("menuFileConfiguration");
        menuFileConfiguration.setText(t("jaxxdemo.action.configuration"));
        menuFileConfiguration.setToolTipText(t("jaxxdemo.action.configuration.tip"));
        menuFileConfiguration.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__menuFileConfiguration"));
        menuFileConfiguration.putClientProperty("help", "ui.main.menu.file.configuration");
    }

    protected void createMenuFileExit() {
        $objectMap.put("menuFileExit", menuFileExit = new JMenuItem());
        
        menuFileExit.setName("menuFileExit");
        menuFileExit.setText(t("jaxxdemo.action.exit"));
        menuFileExit.setToolTipText(t("jaxxdemo.action.exit.tip"));
        menuFileExit.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__menuFileExit"));
        menuFileExit.putClientProperty("help", "ui.main.menu.file.exit");
    }

    protected void createMenuFileFullscreen() {
        $objectMap.put("menuFileFullscreen", menuFileFullscreen = new JMenuItem());
        
        menuFileFullscreen.setName("menuFileFullscreen");
        menuFileFullscreen.setText(t("jaxxdemo.action.fullscreen"));
        menuFileFullscreen.setToolTipText(t("jaxxdemo.action.fullscreen.tip"));
        menuFileFullscreen.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__menuFileFullscreen"));
        menuFileFullscreen.putClientProperty("help", "ui.main.menu.file.fullscreen");
    }

    protected void createMenuFileLanguage() {
        $objectMap.put("menuFileLanguage", menuFileLanguage = new JMenu());
        
        menuFileLanguage.setName("menuFileLanguage");
        menuFileLanguage.setText(t("jaxxdemo.menu.file.locale"));
        menuFileLanguage.setToolTipText(t("jaxxdemo.menu.file.locale"));
        menuFileLanguage.putClientProperty("help", "ui.main.menu.file.locale");
    }

    protected void createMenuFileLanguageFR() {
        $objectMap.put("menuFileLanguageFR", menuFileLanguageFR = new JMenuItem());
        
        menuFileLanguageFR.setName("menuFileLanguageFR");
        menuFileLanguageFR.setText(t("jaxxdemo.action.locale.fr"));
        menuFileLanguageFR.setToolTipText(t("jaxxdemo.action.locale.fr.tip"));
        menuFileLanguageFR.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__menuFileLanguageFR"));
        menuFileLanguageFR.putClientProperty("help", "ui.main.menu.file.locale.fr");
    }

    protected void createMenuFileLanguageUK() {
        $objectMap.put("menuFileLanguageUK", menuFileLanguageUK = new JMenuItem());
        
        menuFileLanguageUK.setName("menuFileLanguageUK");
        menuFileLanguageUK.setText(t("jaxxdemo.action.locale.uk"));
        menuFileLanguageUK.setToolTipText(t("jaxxdemo.action.locale.uk.tip"));
        menuFileLanguageUK.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__menuFileLanguageUK"));
        menuFileLanguageUK.putClientProperty("help", "ui.main.menu.file.locale.uk");
    }

    protected void createMenuFileNormalscreen() {
        $objectMap.put("menuFileNormalscreen", menuFileNormalscreen = new JMenuItem());
        
        menuFileNormalscreen.setName("menuFileNormalscreen");
        menuFileNormalscreen.setText(t("jaxxdemo.action.normalscreen"));
        menuFileNormalscreen.setToolTipText(t("jaxxdemo.action.normalscreen.tip"));
        menuFileNormalscreen.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__menuFileNormalscreen"));
        menuFileNormalscreen.putClientProperty("help", "ui.main.menu.file.leave-fullscreen");
    }

    protected void createMenuHelp() {
        $objectMap.put("menuHelp", menuHelp = new JMenu());
        
        menuHelp.setName("menuHelp");
        menuHelp.setText(t("jaxxdemo.menu.help"));
        menuHelp.putClientProperty("help", "ui.main.menu.help");
    }

    protected void createMenuHelpAbout() {
        $objectMap.put("menuHelpAbout", menuHelpAbout = new JMenuItem());
        
        menuHelpAbout.setName("menuHelpAbout");
        menuHelpAbout.setText(t("jaxxdemo.action.about"));
        menuHelpAbout.setToolTipText(t("jaxxdemo.action.about.tip"));
        menuHelpAbout.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__menuHelpAbout"));
        menuHelpAbout.putClientProperty("help", "ui.main.menu.help.about");
    }

    protected void createMenuHelpHelp() {
        $objectMap.put("menuHelpHelp", menuHelpHelp = new JMenuItem());
        
        menuHelpHelp.setName("menuHelpHelp");
        menuHelpHelp.setText(t("jaxxdemo.action.help"));
        menuHelpHelp.setToolTipText(t("jaxxdemo.action.help.tip"));
        menuHelpHelp.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__menuHelpHelp"));
        menuHelpHelp.putClientProperty("help", "ui.main.menu.help.help");
    }

    protected void createMenuHelpSite() {
        $objectMap.put("menuHelpSite", menuHelpSite = new JMenuItem());
        
        menuHelpSite.setName("menuHelpSite");
        menuHelpSite.setText(t("jaxxdemo.action.site"));
        menuHelpSite.setToolTipText(t("jaxxdemo.action.site.tip"));
        menuHelpSite.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__menuHelpSite"));
        menuHelpSite.putClientProperty("help", "ui.main.menu.help.site");
    }

    protected void createNavigation() {
        $objectMap.put("navigation", navigation = new JTree());
        
        navigation.setName("navigation");
        navigation.setLargeModel(true);
        navigation.setShowsRootHandles(false);
        if (navigation.getFont() != null) {
            navigation.setFont(navigation.getFont().deriveFont((float) 11));
        }
        navigation.setRootVisible(false);
    }

    protected void createNavigationPane() {
        $objectMap.put("navigationPane", navigationPane = new JScrollPane());
        
        navigationPane.setName("navigationPane");
    }

    protected void createP() {
        $objectMap.put("p", p = new StatusMessagePanel());
        
        p.setName("p");
    }

    protected void createShowHelp() {
        $objectMap.put("showHelp", showHelp = new JButton());
        
        showHelp.setName("showHelp");
        showHelp.setBorderPainted(false);
        showHelp.setVisible(true);
        showHelp.setToolTipText(t("jaxxdemo.action.showHelp.tip"));
    }

    protected void createSplitPane() {
        $objectMap.put("splitPane", splitPane = new JSplitPane());
        
        splitPane.setName("splitPane");
        splitPane.setContinuousLayout(true);
        splitPane.setOneTouchExpandable(true);
        splitPane.setDividerSize(6);
    }

    protected void createTreeHelper() {
        $objectMap.put("treeHelper", treeHelper = getContextValue(DemoTreeHelper.class));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected void $initialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        mainFrame = this;
        handler = new DemoUIHandler();
        handler.beforeInit(this);
        $initialize_01_createComponents();
        $initialize_02_registerDataBindings();
        $initialize_03_finalizeCreateComponents();
        $initialize_04_applyDataBindings();
        $initialize_05_setProperties();
        $initialize_06_finalizeInitialize();
        handler.afterInit(this);
    }

    protected void $initialize_01_createComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("mainFrame", mainFrame);
        createContentLayout();
        createConfig();
        createTreeHelper();
        createBroker();
        createMenu();
        createMenuFile();
        createMenuFileConfiguration();
        createMenuFileLanguage();
        createMenuFileLanguageFR();
        createMenuFileLanguageUK();
        // inline creation of $JSeparator0
        $objectMap.put("$JSeparator0", $JSeparator0 = new JSeparator());
        
        $JSeparator0.setName("$JSeparator0");
        createMenuFileFullscreen();
        createMenuFileNormalscreen();
        // inline creation of $JSeparator1
        $objectMap.put("$JSeparator1", $JSeparator1 = new JSeparator());
        
        $JSeparator1.setName("$JSeparator1");
        createMenuFileExit();
        createMenuHelp();
        createMenuHelpHelp();
        createMenuHelpSite();
        createMenuHelpAbout();
        // inline creation of $JToolBar0
        $objectMap.put("$JToolBar0", $JToolBar0 = new JToolBar());
        
        $JToolBar0.setName("$JToolBar0");
        $JToolBar0.setLayout(new BorderLayout());
        $JToolBar0.setBorderPainted(false);
        $JToolBar0.setOpaque(false);
        $JToolBar0.setFloatable(false);
        createShowHelp();
        createMainPane();
        createSplitPane();
        createNavigationPane();
        createNavigation();
        createContent();
        createP();
        // inline creation of mainFrame
        setName("mainFrame");
        SwingUtil.setComponentHeight(mainFrame,800);
        SwingUtil.setComponentWidth(mainFrame,1024);
        setTitle(t("JAXX Demo"));
        mainFrame.addWindowListener(JAXXUtil.getEventListener(WindowListener.class, "windowClosing", this, "doWindowClosing__on__mainFrame"));
    }

    protected void $initialize_02_registerDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // register 6 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MAIN_FRAME_UNDECORATED, true) {
        
            @Override
            public void applyDataBinding() {
                if (getConfig() != null) {
                    getConfig().addPropertyChangeListener("fullScreen", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getConfig() != null) {
                    setUndecorated(getConfig().isFullScreen());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (getConfig() != null) {
                    getConfig().removePropertyChangeListener("fullScreen", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MAIN_FRAME_ICON_IMAGE, true) {
        
            @Override
            public void applyDataBinding() {
                if (getConfig() != null) {
                    getConfig().addPropertyChangeListener("iconPath", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getConfig() != null) {
                    setIconImage(SwingUtil.createIcon(getConfig().getIconPath()).getImage());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (getConfig() != null) {
                    getConfig().removePropertyChangeListener("iconPath", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MENU_FILE_LANGUAGE_FR_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (getConfig() != null) {
                    getConfig().addPropertyChangeListener("locale", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getConfig() != null) {
                    menuFileLanguageFR.setEnabled(!acceptLocale(getConfig().getLocale(), "fr_FR"));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (getConfig() != null) {
                    getConfig().removePropertyChangeListener("locale", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MENU_FILE_LANGUAGE_UK_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (getConfig() != null) {
                    getConfig().addPropertyChangeListener("locale", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getConfig() != null) {
                    menuFileLanguageUK.setEnabled(!acceptLocale(getConfig().getLocale(), "en_GB"));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (getConfig() != null) {
                    getConfig().removePropertyChangeListener("locale", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_MENU_FILE_FULLSCREEN_VISIBLE, true ,"undecorated") {
        
            @Override
            public void processDataBinding() {
                menuFileFullscreen.setVisible(!isUndecorated());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_MENU_FILE_NORMALSCREEN_VISIBLE, true ,"undecorated") {
        
            @Override
            public void processDataBinding() {
                menuFileNormalscreen.setVisible(isUndecorated());
            }
        });
    }

    protected void $initialize_03_finalizeCreateComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToMainFrame();
        addChildrenToMenu();
        addChildrenToMenuFile();
        addChildrenToMenuFileLanguage();
        addChildrenToMenuHelp();
        // inline complete setup of $JToolBar0
        $JToolBar0.add(showHelp, BorderLayout.EAST);
        addChildrenToMainPane();
        addChildrenToSplitPane();
        addChildrenToNavigationPane();
    }

    protected void $initialize_04_applyDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        
        // apply 6 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
    }

    protected void $initialize_05_setProperties() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        
        // apply 31 property setters
        menuFile.setMnemonic(SwingUtil.getFirstCharAt(t("jaxxdemo.menu.file.mnemonic"),'Z'));
        menuFileConfiguration.setMnemonic(SwingUtil.getFirstCharAt(t("jaxxdemo.action.configuration.mnemonic"),'Z'));
        menuFileConfiguration.setIcon(SwingUtil.getUIManagerActionIcon("config"));
        menuFileLanguage.setMnemonic(SwingUtil.getFirstCharAt(t("jaxxdemo.menu.file.locale.mnemonic"),'Z'));
        menuFileLanguage.setIcon(SwingUtil.getUIManagerActionIcon("translate"));
        menuFileLanguageFR.setMnemonic(SwingUtil.getFirstCharAt(t("jaxxdemo.action.locale.fr.mnemonic"),'Z'));
        menuFileLanguageFR.setIcon(SwingUtil.getUIManagerActionIcon("i18n-fr"));
        menuFileLanguageUK.setMnemonic(SwingUtil.getFirstCharAt(t("jaxxdemo.action.locale.uk.mnemonic"),'Z'));
        menuFileLanguageUK.setIcon(SwingUtil.getUIManagerActionIcon("i18n-uk"));
        menuFileFullscreen.setMnemonic(SwingUtil.getFirstCharAt(t("jaxxdemo.action.fullscreen.mnemonic"),'Z'));
        menuFileFullscreen.setIcon(SwingUtil.getUIManagerActionIcon("fullscreen"));
        menuFileNormalscreen.setMnemonic(SwingUtil.getFirstCharAt(t("jaxxdemo.action.normalscreen.mnemonic"),'Z'));
        menuFileNormalscreen.setIcon(SwingUtil.getUIManagerActionIcon("leave-fullscreen"));
        menuFileExit.setMnemonic(SwingUtil.getFirstCharAt(t("jaxxdemo.action.exit.mnemonic"),'Z'));
        menuFileExit.setIcon(SwingUtil.getUIManagerActionIcon("exit"));
        menuHelp.setMnemonic(SwingUtil.getFirstCharAt(t("jaxxdemo.menu.help.mnemonic"),'Z'));
        menuHelpHelp.setMnemonic(SwingUtil.getFirstCharAt(t("jaxxdemo.action.help.mnemonic"),'Z'));
        menuHelpHelp.setIcon(SwingUtil.getUIManagerActionIcon("help"));
        menuHelpSite.setMnemonic(SwingUtil.getFirstCharAt(t("jaxxdemo.action.site.mnemonic"),'Z'));
        menuHelpSite.setIcon(SwingUtil.getUIManagerActionIcon("site"));
        menuHelpAbout.setMnemonic(SwingUtil.getFirstCharAt(t("jaxxdemo.action.about.mnemonic"),'Z'));
        menuHelpAbout.setIcon(SwingUtil.getUIManagerActionIcon("about"));
        showHelp.setIcon(SwingUtil.getUIManagerActionIcon("show-help"));
        navigationPane.setBorder(null);
        navigationPane.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);
        navigationPane.setMinimumSize(new Dimension(230,0));
        navigation.setCellRenderer(new DemoCellRenderer(getTreeHelper().getDataProvider()));
        navigation.setModel(getTreeHelper().createModel());// late initializer
        // help broker setup
        DemoHelpBroker _broker = getBroker();
        registerHelpId(_broker, menu, "ui.main.menu");
        registerHelpId(_broker, menuFile, "ui.main.menu.file");
        registerHelpId(_broker, menuFileConfiguration, "ui.main.menu.file.configuration");
        registerHelpId(_broker, menuFileLanguage, "ui.main.menu.file.locale");
        registerHelpId(_broker, menuFileLanguageFR, "ui.main.menu.file.locale.fr");
        registerHelpId(_broker, menuFileLanguageUK, "ui.main.menu.file.locale.uk");
        registerHelpId(_broker, menuFileFullscreen, "ui.main.menu.file.fullscreen");
        registerHelpId(_broker, menuFileNormalscreen, "ui.main.menu.file.leave-fullscreen");
        registerHelpId(_broker, menuFileExit, "ui.main.menu.file.exit");
        registerHelpId(_broker, menuHelp, "ui.main.menu.help");
        registerHelpId(_broker, menuHelpHelp, "ui.main.menu.help.help");
        registerHelpId(_broker, menuHelpSite, "ui.main.menu.help.site");
        registerHelpId(_broker, menuHelpAbout, "ui.main.menu.help.about");
        registerHelpId(_broker, content, "ui.main.body.db.view.content");
        _broker.prepareUI(this);
    }

    protected void $initialize_06_finalizeInitialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
    }

}
