package org.nuiton.jaxx.demo.feature.nav.content;

/*-
 * #%L
 * JAXX :: Demo
 * %%
 * Copyright (C) 2008 - 2020 Code Lutin, Ultreia.io
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.awt.BorderLayout;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuiton.jaxx.demo.entities.Movie;
import org.nuiton.jaxx.runtime.JAXXContext;
import org.nuiton.jaxx.runtime.JAXXObjectDescriptor;
import org.nuiton.jaxx.runtime.JAXXUtil;
import org.nuiton.jaxx.runtime.binding.DefaultJAXXBinding;
import org.nuiton.jaxx.runtime.binding.SimpleJAXXObjectBinding;
import org.nuiton.jaxx.runtime.swing.renderer.DecoratorProviderListCellRenderer;
import org.nuiton.jaxx.widgets.select.BeanListHeader;
import static io.ultreia.java4all.i18n.I18n.t;

public class MoviesContentUI extends AbstractContentUI<List<Movie>> {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_DATA = "data";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_LIST_HEADER_DATA = "listHeader.data";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JBUTTON0_ENABLED = "$JButton0.enabled";
    private static final String BINDING_$JBUTTON2_ENABLED = "$JButton2.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAK2VS08UQRDHe1deCyov4yMaxbCKiTgraowJxgcYo2RRAmiIXOydaaBJb/fYXcMOHjx48OYX8ODVi+E7EE8mXrzyHUz8CFbPrDsiu8PIuofZ3erqX/+rpqr68w/SaTQZV3rVkQEHJZ11GoaODiTwKnNm7i8tPa2sMxceMONq7oPSJP7k8iS/TPq8ht0AcZbLSCrFpJIlleqk0rSq+koy+Qdoskx6DWwKZtYYAyCXWm52jSktNDwnQz/Q9bOaqm521rd3Ezs59uBDnpDQR/l9GPblfwAkUXeUSZ57QIbK63SDlgSVqyhOc7mKAR2xtmlBjXlCq+wVeUO6y6TLpxphQK4cKD0RLkKFPpDh4v2KAU1dmFYScMezx1eB3Po7FI9VlbPCKASaOZJuOG7s7cyqDc5MY6/vR+guIB0eBQrkqI3ACYALp8wNJOs9xZk5KpnA04asT+iYGgbtxFbrVGj4HinOLLhaCWHXcMOJXRuSJevenygQeCCQwV3OVoRdH2q4dYNSokI1kGO7PBfRPEX1XsUT9v+gfZxsrBWKM1MBYLpQ3fAuTGy2bqf3ekeocy0WrzVZ7LUxPWLUY6j3yt9vqca9VQbGMUxgjzlTjMpyw78uWJOLreoU+8JJ+iIp0dwy6dQBmoGMtm5J21Xz6BX302jrfrLHRI5vt97oT7WfO7+baBjFjey36495gRXta+VjKrjV1h93kK210iz1J5dJIU5ENEzG0pUv1D1RPaoYTKr2ETVrSOvs3tn+cvzl90Mk/xDfgqLeQ2r9H5MCrGnMmBJe6N+9F4k7XOvB54CVCaRL0E2FL5QcvW1bYqTCpYeVcSfELI2lZ6khauvpz68f31/Y/p2pHGosZtmZZKvzBeniUnDJooFTnyVNB0yfb1jgqWRQNBsdOfs94NfbYzx6Xm0af0XpevldDwP7dSOKwP66GVGGM1AGXCWCqoxL+TlntTZ5p9aU5q9xbFERzw9s9TkluLvZJvjEhq1H939jD7tMiHkmMfrUXB7PwCqsYP0CrQhs8qHbcVGMUMBLpxIAu9McfGpfsDVfS5HWPuFMhuC6mbSReSmYsxkwHcDC6KJYPCjDmldSCOczEWhKHKNta9ifUL/IU1RcyMDo5RO35JxmKzxMUZOFFF3qbaop4LSuzTPD0l5wFlBPBW/YxU2f7SPoF2qo+0gYCwAA";
    private static final Logger log = LogManager.getLogger(MoviesContentUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Movie> data;
    protected JList list;
    protected BeanListHeader<Movie> listHeader;
    protected JToolBar toolbar;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private MoviesContentUI $AbstractContentUI0;
    private JButton $JButton0;
    private JButton $JButton1;
    private JButton $JButton2;
    private JPanel $JPanel0;
    private JPanel $JPanel1;
    private JScrollPane $JScrollPane0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    private void $afterCompleteSetup() {
        getHandler().initUI(this);    
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public MoviesContentUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
    }

    public MoviesContentUI(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
    }

    public MoviesContentUI(LayoutManager param0) {
        super(param0);
    }

    public MoviesContentUI(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
    }

    public MoviesContentUI() {
        
    }

    public MoviesContentUI(JAXXContext param0) {
        super(param0);
    }

    public MoviesContentUI(boolean param0) {
        super(param0);
    }

    public MoviesContentUI(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__$JButton0(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().selectChild(this, (Movie) list.getSelectedValue());
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public List<Movie> getData() {
        return data;
    }

    public JList getList() {
        return list;
    }

    public BeanListHeader<Movie> getListHeader() {
        return listHeader;
    }

    public JToolBar getToolbar() {
        return toolbar;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setData(List<Movie> data) {
        List<Movie> oldValue = this.data;
        this.data = data;
        firePropertyChange(PROPERTY_DATA, oldValue, data);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JButton get$JButton0() {
        return $JButton0;
    }

    protected JButton get$JButton1() {
        return $JButton1;
    }

    protected JButton get$JButton2() {
        return $JButton2;
    }

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected JPanel get$JPanel1() {
        return $JPanel1;
    }

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToToolbar() {
        toolbar.add($JPanel1, BorderLayout.CENTER);
        toolbar.add(listHeader, BorderLayout.EAST);
    }

    protected void createData() {
        $objectMap.put("data", data = null);
    }

    protected void createList() {
        $objectMap.put("list", list = new JList());
        
        list.setName("list");
    }

    protected void createListHeader() {
        $objectMap.put("listHeader", listHeader = new BeanListHeader<Movie>());
        
        listHeader.setName("listHeader");
        listHeader.setI18nPrefix("jaxxdemo.common.");
        listHeader.setShowReset(true);
    }

    protected void createToolbar() {
        $objectMap.put("toolbar", toolbar = new JToolBar());
        
        toolbar.setName("toolbar");
        toolbar.setFloatable(false);
        toolbar.setLayout(new BorderLayout());
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    protected void $initialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $AbstractContentUI0 = this;
        super.$initialize();
    }

    @Override
    protected void $initialize_01_createComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_01_createComponents();
        $objectMap.put("$AbstractContentUI0", $AbstractContentUI0);
        createData();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new BorderLayout());
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createList();
        createToolbar();
        // inline creation of $JPanel1
        $objectMap.put("$JPanel1", $JPanel1 = new JPanel());
        
        $JPanel1.setName("$JPanel1");
        $JPanel1.setLayout(new GridLayout(1,0));
        // inline creation of $JButton0
        $objectMap.put("$JButton0", $JButton0 = new JButton());
        
        $JButton0.setName("$JButton0");
        $JButton0.setText(t("jaxxdemo.action.show"));
        $JButton0.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton0"));
        // inline creation of $JButton1
        $objectMap.put("$JButton1", $JButton1 = new JButton());
        
        $JButton1.setName("$JButton1");
        $JButton1.setText(t("jaxxdemo.action.add"));
        // inline creation of $JButton2
        $objectMap.put("$JButton2", $JButton2 = new JButton());
        
        $JButton2.setName("$JButton2");
        $JButton2.setText(t("jaxxdemo.action.remove"));
        createListHeader();
        // inline creation of $AbstractContentUI0
        setName("$AbstractContentUI0");
    }

    @Override
    protected void $initialize_02_registerDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_02_registerDataBindings();
        // register 3 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_$JBUTTON0_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (list != null) {
                    $bindingSources.put("list.getSelectionModel()", list.getSelectionModel());
                    list.getSelectionModel().addListSelectionListener( JAXXUtil.getEventListener(ListSelectionListener.class, this, "$pr$u0"));
                    list.addPropertyChangeListener("selectionModel", JAXXUtil.getDataBindingUpdateListener(org.nuiton.jaxx.demo.feature.nav.content.MoviesContentUI.this, BINDING_$JBUTTON0_ENABLED));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (list != null) {
                    $JButton0.setEnabled(list.getSelectedIndex()!=-1);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (list != null) {
                    ListSelectionModel $target = (ListSelectionModel) $bindingSources.remove("list.getSelectionModel()");
                    if ($target != null) {
                        $target.removeListSelectionListener( JAXXUtil.getEventListener(ListSelectionListener.class, this, "$pr$u0"));
                    }
                    list.removePropertyChangeListener("selectionModel", JAXXUtil.getDataBindingUpdateListener(org.nuiton.jaxx.demo.feature.nav.content.MoviesContentUI.this, BINDING_$JBUTTON0_ENABLED));
                }
            }
        
            public void $pr$u0(ListSelectionEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_$JBUTTON2_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (list != null) {
                    $bindingSources.put("list.getSelectionModel()", list.getSelectionModel());
                    list.getSelectionModel().addListSelectionListener( JAXXUtil.getEventListener(ListSelectionListener.class, this, "$pr$u1"));
                    list.addPropertyChangeListener("selectionModel", JAXXUtil.getDataBindingUpdateListener(org.nuiton.jaxx.demo.feature.nav.content.MoviesContentUI.this, BINDING_$JBUTTON2_ENABLED));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (list != null) {
                    $JButton2.setEnabled(list.getSelectedIndex()!=-1);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (list != null) {
                    ListSelectionModel $target = (ListSelectionModel) $bindingSources.remove("list.getSelectionModel()");
                    if ($target != null) {
                        $target.removeListSelectionListener( JAXXUtil.getEventListener(ListSelectionListener.class, this, "$pr$u1"));
                    }
                    list.removePropertyChangeListener("selectionModel", JAXXUtil.getDataBindingUpdateListener(org.nuiton.jaxx.demo.feature.nav.content.MoviesContentUI.this, BINDING_$JBUTTON2_ENABLED));
                }
            }
        
            public void $pr$u1(ListSelectionEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_LIST_HEADER_DATA, true ,"data") {
        
            @Override
            public void processDataBinding() {
                listHeader.setData(getData());
            }
        });
    }

    @Override
    protected void $initialize_03_finalizeCreateComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_03_finalizeCreateComponents();
        // inline complete setup of $AbstractContentUI0
        add($JPanel0);
        // inline complete setup of $JPanel0
        $JPanel0.add($JScrollPane0, BorderLayout.CENTER);
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(list);
        addChildrenToToolbar();
        // inline complete setup of $JPanel1
        $JPanel1.add($JButton0);
        $JPanel1.add($JButton1);
        $JPanel1.add($JButton2);
    }

    @Override
    protected void $initialize_04_applyDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_04_applyDataBindings();
    }

    @Override
    protected void $initialize_05_setProperties() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_05_setProperties();
        
        // apply 10 property setters
        $JScrollPane0.setBorder(new TitledBorder(t("jaxxdemo.navigation.movies.title")));
        $JScrollPane0.setColumnHeaderView(toolbar);
        $JScrollPane0.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);
        $JScrollPane0.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED);
        list.setCellRenderer(getContextValue(DecoratorProviderListCellRenderer.class));
        listHeader.setList(list);
        listHeader.setBeanType(Movie.class);
    }

    @Override
    protected void $initialize_06_finalizeInitialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_06_finalizeInitialize();
    }

}
