package org.nuiton.jaxx.demo.component.swing;

/*-
 * #%L
 * JAXX :: Demo
 * %%
 * Copyright (C) 2008 - 2020 Code Lutin, Ultreia.io
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.awt.Color;
import java.awt.LayoutManager;
import javax.swing.BorderFactory;
import javax.swing.BoundedRangeModel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuiton.jaxx.demo.DemoPanel;
import org.nuiton.jaxx.runtime.JAXXContext;
import org.nuiton.jaxx.runtime.JAXXObjectDescriptor;
import org.nuiton.jaxx.runtime.JAXXUtil;
import org.nuiton.jaxx.runtime.binding.DefaultJAXXBinding;
import org.nuiton.jaxx.runtime.swing.HBox;
import org.nuiton.jaxx.runtime.swing.SwingUtil;
import org.nuiton.jaxx.runtime.swing.VBox;

public class JSliderDemo extends DemoPanel {

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JPANEL0_BACKGROUND = "$JPanel0.background";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKWVz0/UQBTH3y50l58iYIjxhLIIBm0x8WIgKEIIklWMJIS4F2e3k3awnRmnU7Z64ODBm/+AB69eDP8D8WTixSv/gwl/gjPd7g9Mdymwh3b39b3PfOf1fWd//AUjEHCfCcekIZGMmvsoikwRUkl8bG6t7u1tV/dxTa7joCYIl0xA45PLQ74Cw3YrHkgwK2VFshokS5OshGStMZ8zimkHaKkMQ4H84OHAxVhKmO9aXAsCa6eVuRTxUCRrpapOW+v354cnObz+NQ8QcSW/qLa9cAFAe9f9ZcgTW8JEeR8dIMtD1FHiBKGO2tCojq15KAheIh+/h0MolqHAkVAwCQ8u1Z4YF6MiLmG4tI599gpR7C1KWPx/C7Z6aNaaNDOoK13m1o5HbCx0IecxqiChUNp8xiLFuNOtDY1inaVLBjsqdzNV7iaVI63KPoFV5yZ1k6Kz2nTCWCvPcATGVP+4cfZBf9ULcUp8oLTVbMnEGXocTUQIuNtNsJowsz1h7Zedq4AhQhWWMNN9uPV8vlZZjcmc6T6Zepk48dPRofhePz1pjuOIEjd9XlWH89RscME4FpJobWONWQwl8awXiC9VYDDAnrJtbMu53sp3kkylXqkY1yRTk8xNFLiKZhRPjn9Ovf3TB/kNGPIYsjeQzn8Og9IVqmPMsyP+5GksbqQ+oK7XtUz1ol0myEdGJfJWPeJQP3bBxDKhHqF4Gkllm2oo8Uqk2jbXu20tlUfbp7++fZk9brYup0SXslS222e8gUJDQ+zlxKap3h3mAQ5t1vZgmitz+j7KE2/djq+zaQ0ZP9BvrNbRDp06H4X6di/ejP62kBlY9FFE/NDvgZnMgDEOUOKrS0N0+FEPwlQmwuMrE3ppuHllDecTJAxVUe2dI1hI1Vl3bdlGEk1XCbXVebSSTr2VgVqoMpGck9tXoLiYOG6vqctCMerqD9A9B/IPH2XRaVwIAAA=";
    private static final Logger log = LogManager.getLogger(JSliderDemo.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JSlider blue;
    protected JSlider green;
    protected JSlider red;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JSliderDemo $DemoPanel0;
    private HBox $HBox0;
    private JPanel $JPanel0;
    private VBox $VBox0;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public JSliderDemo(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
    }

    public JSliderDemo(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
    }

    public JSliderDemo(LayoutManager param0) {
        super(param0);
    }

    public JSliderDemo(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
    }

    public JSliderDemo() {
        
    }

    public JSliderDemo(JAXXContext param0) {
        super(param0);
    }

    public JSliderDemo(boolean param0) {
        super(param0);
    }

    public JSliderDemo(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JSlider getBlue() {
        return blue;
    }

    public JSlider getGreen() {
        return green;
    }

    public JSlider getRed() {
        return red;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected HBox get$HBox0() {
        return $HBox0;
    }

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected VBox get$VBox0() {
        return $VBox0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void createBlue() {
        $objectMap.put("blue", blue = new JSlider());
        
        blue.setName("blue");
        blue.setValue(0);
        blue.setMaximum(255);
        blue.setValue(240);
    }

    protected void createGreen() {
        $objectMap.put("green", green = new JSlider());
        
        green.setName("green");
        green.setValue(0);
        green.setMaximum(255);
        green.setValue(180);
    }

    protected void createRed() {
        $objectMap.put("red", red = new JSlider());
        
        red.setName("red");
        red.setValue(0);
        red.setMaximum(255);
        red.setValue(200);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    protected void $initialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $DemoPanel0 = this;
        super.$initialize();
    }

    @Override
    protected void $initialize_01_createComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_01_createComponents();
        $objectMap.put("$DemoPanel0", $DemoPanel0);
        // inline creation of $HBox0
        $objectMap.put("$HBox0", $HBox0 = new HBox());
        
        $HBox0.setName("$HBox0");
        $HBox0.setHorizontalAlignment(0);
        $HBox0.setVerticalAlignment(0);
        // inline creation of $VBox0
        $objectMap.put("$VBox0", $VBox0 = new VBox());
        
        $VBox0.setName("$VBox0");
        createRed();
        createGreen();
        createBlue();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        SwingUtil.setComponentHeight($JPanel0,64);
        SwingUtil.setComponentWidth($JPanel0,64);
        // inline creation of $DemoPanel0
        setName("$DemoPanel0");
    }

    @Override
    protected void $initialize_02_registerDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_02_registerDataBindings();
        // register 1 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_$JPANEL0_BACKGROUND, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (red != null) {
                    $bindingSources.put("red.getModel()", red.getModel());
                    red.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u0"));
                    red.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(org.nuiton.jaxx.demo.component.swing.JSliderDemo.this, BINDING_$JPANEL0_BACKGROUND));
                }
                if (green != null) {
                    $bindingSources.put("green.getModel()", green.getModel());
                    green.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u0"));
                    green.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(org.nuiton.jaxx.demo.component.swing.JSliderDemo.this, BINDING_$JPANEL0_BACKGROUND));
                }
                if (blue != null) {
                    $bindingSources.put("blue.getModel()", blue.getModel());
                    blue.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u0"));
                    blue.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(org.nuiton.jaxx.demo.component.swing.JSliderDemo.this, BINDING_$JPANEL0_BACKGROUND));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (red != null && blue != null && green != null) {
                    $JPanel0.setBackground(new Color(red.getValue(), green.getValue(), blue.getValue()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (red != null) {
                    BoundedRangeModel $target = (BoundedRangeModel) $bindingSources.remove("red.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u0"));
                    }
                    red.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(org.nuiton.jaxx.demo.component.swing.JSliderDemo.this, BINDING_$JPANEL0_BACKGROUND));
                }
                if (green != null) {
                    BoundedRangeModel $target = (BoundedRangeModel) $bindingSources.remove("green.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u0"));
                    }
                    green.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(org.nuiton.jaxx.demo.component.swing.JSliderDemo.this, BINDING_$JPANEL0_BACKGROUND));
                }
                if (blue != null) {
                    BoundedRangeModel $target = (BoundedRangeModel) $bindingSources.remove("blue.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u0"));
                    }
                    blue.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(org.nuiton.jaxx.demo.component.swing.JSliderDemo.this, BINDING_$JPANEL0_BACKGROUND));
                }
            }
        
            public void $pr$u0(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
    }

    @Override
    protected void $initialize_03_finalizeCreateComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_03_finalizeCreateComponents();
        // inline complete setup of $DemoPanel0
        add($HBox0);
        // inline complete setup of $HBox0
        $HBox0.add($VBox0);
        $HBox0.add($JPanel0);
        // inline complete setup of $VBox0
        $VBox0.add(red);
        $VBox0.add(green);
        $VBox0.add(blue);
    }

    @Override
    protected void $initialize_04_applyDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_04_applyDataBindings();
    }

    @Override
    protected void $initialize_05_setProperties() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_05_setProperties();
        
        // apply 1 property setters
        $JPanel0.setBorder(BorderFactory.createEtchedBorder());
    }

    @Override
    protected void $initialize_06_finalizeInitialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_06_finalizeInitialize();
    }

}
