package org.nuiton.jaxx.demo.component.jaxx.widgets.gis;

/*-
 * #%L
 * JAXX :: Demo
 * %%
 * Copyright (C) 2008 - 2020 Code Lutin, Ultreia.io
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.awt.BorderLayout;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.ButtonModel;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuiton.jaxx.demo.DemoPanel;
import org.nuiton.jaxx.runtime.JAXXContext;
import org.nuiton.jaxx.runtime.JAXXObjectDescriptor;
import org.nuiton.jaxx.runtime.JAXXUtil;
import org.nuiton.jaxx.runtime.binding.DefaultJAXXBinding;
import org.nuiton.jaxx.runtime.swing.Table;
import org.nuiton.jaxx.widgets.gis.absolute.CoordinatesEditor;
import static io.ultreia.java4all.i18n.I18n.t;

public class CoordinatesEditorDemo extends DemoPanel {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_EDITOR_DISPLAY_ZERO_WHEN_NULL = "editor.displayZeroWhenNull";
    public static final String BINDING_EDITOR_ENABLED = "editor.enabled";
    public static final String BINDING_EDITOR_LATITUDE = "editor.latitude";
    public static final String BINDING_EDITOR_LONGITUDE = "editor.longitude";
    public static final String BINDING_EDITOR_QUADRANT = "editor.quadrant";
    public static final String BINDING_EDITOR_SHOW_RESET_BUTTON = "editor.showResetButton";
    public static final String BINDING_RESULT_LATITUDE_TEXT = "resultLatitude.text";
    public static final String BINDING_RESULT_LONGITUDE_TEXT = "resultLongitude.text";
    public static final String BINDING_RESULT_QUADRANT_TEXT = "resultQuadrant.text";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAK1VS3MbRRBuKZYUP4jzIIGConDZBst5rEhRwMEUENtJgUt5EKeKVHxhpJ1Ia0Yzm5lZtC5VcuDAifwBDly5UPkPKU5UceHq/0BVfgI9u6vVrjSylyQ6bK16u7/u/nr6mz/+hYqScFnIjsMDTwvu7JMwdGTAtdejzs61+/dvt/ZpW29T1Zaer4WE+FcqQ3kP5t3UrjQ4e01EasRIDYPUSJAaW6LnC055BmijCXNKHzCqupRqDfWpwW2lGrup50boBzLJZa3aluvvn68eluj2r2WA0MfyF7DtS/8DYNT1TBPKnqvhbHOf/EgajPAOFic93sGG3jC2LUaUukV69BE8gVoTqj6RCKbhykvRE8FFUKGvYX51m/bEHcIp+0jD9fEWXPzotIdosa3vuR2qldPxFLYmpOtxoqm67mKYNGi+H+FXNVR6wqVMw85rwb1pwEbgtdV7pMUolr0yjXnVRx6dyM0Ezaax1bbgD70O0m4YDhPHnYgH47KYes6qrujfpcocqfM5560ubf+wKULjeDb1X6DcpNsMNFZjbG/lv59zPeUzcvCASvFdl/JbAWMWtyqN2tbw6XhvWZpISwkWaDrJV76JqqQqYNr8ezP/5VT85duAuJKYQ5UnpElaMSHvj0c0ifZ04Ea8ruQ9FhMPwTsTLhI+nDYsXEtntJajDSntQUUGaMZBT1cEs9R30Ste55Xp62zSRI4/PXsif++/OMzu8NJxURm5woXypfCp1J6pbTFe4EB7rHGT+Bt7eHQoQ62LtGzt6Mp3E0+sHqs4Y5Acg+R8TVQX0Sq1w+d/Xvj+nxNQvgFzTBD3BjH+38Cs7iLdXcHc0P/yq6i4hf5JfJ42ZeLoW3gysEa4NuC0v3TP04y6m5GtruvLppJkGcdOkBOvSCBx0IIvr68/DpHYtaOJTft4dvvFX789/eD5kNwStrVaJHJEcOUBVD3OPE4jiUzUzyqJ876igStG0mYTO0jX3k9E5Er0vDpBW1nDjKYhbsN7Fn6cjCKcjEdMXRMhAxoGBvGTqGHz9hlkFaR43ndseWNlKZY0J0PF867Z8loUq1gRNq07rpY5DWeStTpIFQRJZKP3xZTQuD0Nbw9Sk+Op3aSy+vpjDadTsESwsHQ2en2UCt/5QXRZOSiuQzXMA4w0MhOVwcoADHNFADYWNCwPLObx4mdaFLNALUZGQy0eK5L+7iA74fHALF0XMnUNrXWzzZMDS26d42aUlZWPi8qKE98KsZBYUsefC6ROjurFQZdwl1GZm5hlhvZ8YxffS+ZNB20Z/ZF5h27F817O5U0HaZutPfP4tVxkyng+BR4wOPW5SzRZankch9n5YgK+ZJ5zxyIa8y/m8dSOcO6VEZYQ4T+YghhFhwwAAA==";
    private static final Logger log = LogManager.getLogger(CoordinatesEditorDemo.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel config;
    protected JCheckBox displayZeroWhenNull;
    protected CoordinatesEditor editor;
    protected JCheckBox enableButton;
    protected CoordinatesEditorDemoHandler handler;
    protected CoordinatesEditorDemoModel model;
    protected JPanel result;
    protected JLabel resultLatitude;
    protected JLabel resultLongitude;
    protected JLabel resultQuadrant;
    protected JCheckBox showReset;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private CoordinatesEditorDemo $DemoPanel0;
    private Table $Table0;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public CoordinatesEditorDemo(LayoutManager param0) {
        super(param0);
    }

    public CoordinatesEditorDemo(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
    }

    public CoordinatesEditorDemo(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
    }

    public CoordinatesEditorDemo(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
    }

    public CoordinatesEditorDemo() {
        
    }

    public CoordinatesEditorDemo(JAXXContext param0) {
        super(param0);
    }

    public CoordinatesEditorDemo(boolean param0) {
        super(param0);
    }

    public CoordinatesEditorDemo(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JPanel getConfig() {
        return config;
    }

    public JCheckBox getDisplayZeroWhenNull() {
        return displayZeroWhenNull;
    }

    public CoordinatesEditor getEditor() {
        return editor;
    }

    public JCheckBox getEnableButton() {
        return enableButton;
    }

    public CoordinatesEditorDemoHandler getHandler() {
        return handler;
    }

    public CoordinatesEditorDemoModel getModel() {
        return model;
    }

    public JPanel getResult() {
        return result;
    }

    public JLabel getResultLatitude() {
        return resultLatitude;
    }

    public JLabel getResultLongitude() {
        return resultLongitude;
    }

    public JLabel getResultQuadrant() {
        return resultQuadrant;
    }

    public JCheckBox getShowReset() {
        return showReset;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected Table get$Table0() {
        return $Table0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToConfig() {
        config.add(showReset);
        config.add(enableButton);
        config.add(displayZeroWhenNull);
    }

    protected void addChildrenToResult() {
        result.add(resultQuadrant);
        result.add(resultLatitude);
        result.add(resultLongitude);
    }

    protected void createConfig() {
        $objectMap.put("config", config = new JPanel());
        
        config.setName("config");
        config.setLayout(new GridLayout(0,1));
    }

    protected void createDisplayZeroWhenNull() {
        $objectMap.put("displayZeroWhenNull", displayZeroWhenNull = new JCheckBox());
        
        displayZeroWhenNull.setName("displayZeroWhenNull");
        displayZeroWhenNull.setText(t("jaxxdemo.coordinate.displayZeroWhenNull"));
        displayZeroWhenNull.setSelected(true);
    }

    protected void createEditor() {
        $objectMap.put("editor", editor = new CoordinatesEditor());
        
        editor.setName("editor");
        editor.setPropertyLongitude("longitude");
        editor.setPropertyLatitude("latitude");
        editor.setPropertyQuadrant("quadrant");
    }

    protected void createEnableButton() {
        $objectMap.put("enableButton", enableButton = new JCheckBox());
        
        enableButton.setName("enableButton");
        enableButton.setText(t("jaxxdemo.coordinate.enable"));
        enableButton.setSelected(true);
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(CoordinatesEditorDemoModel.class));
    }

    protected void createResult() {
        $objectMap.put("result", result = new JPanel());
        
        result.setName("result");
        result.setLayout(new GridLayout(0,1));
    }

    protected void createResultLatitude() {
        $objectMap.put("resultLatitude", resultLatitude = new JLabel());
        
        resultLatitude.setName("resultLatitude");
    }

    protected void createResultLongitude() {
        $objectMap.put("resultLongitude", resultLongitude = new JLabel());
        
        resultLongitude.setName("resultLongitude");
    }

    protected void createResultQuadrant() {
        $objectMap.put("resultQuadrant", resultQuadrant = new JLabel());
        
        resultQuadrant.setName("resultQuadrant");
    }

    protected void createShowReset() {
        $objectMap.put("showReset", showReset = new JCheckBox());
        
        showReset.setName("showReset");
        showReset.setText(t("jaxxdemo.coordinate.showReset"));
        showReset.setSelected(true);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    protected void $initialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $DemoPanel0 = this;
        handler = new CoordinatesEditorDemoHandler();
        handler.beforeInit(this);
        super.$initialize();
        handler.afterInit(this);
    }

    @Override
    protected void $initialize_01_createComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_01_createComponents();
        $objectMap.put("$DemoPanel0", $DemoPanel0);
        createModel();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        createConfig();
        createShowReset();
        createEnableButton();
        createDisplayZeroWhenNull();
        createEditor();
        createResult();
        createResultQuadrant();
        createResultLatitude();
        createResultLongitude();
        // inline creation of $DemoPanel0
        setName("$DemoPanel0");
        setLayout(new BorderLayout());
    }

    @Override
    protected void $initialize_02_registerDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_02_registerDataBindings();
        // register 9 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_EDITOR_SHOW_RESET_BUTTON, true) {
        
            @Override
            public void applyDataBinding() {
                if (showReset != null) {
                    $bindingSources.put("showReset.getModel()", showReset.getModel());
                    showReset.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u0"));
                    showReset.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(org.nuiton.jaxx.demo.component.jaxx.widgets.gis.CoordinatesEditorDemo.this, BINDING_EDITOR_SHOW_RESET_BUTTON));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (showReset != null) {
                    editor.setShowResetButton(showReset.isSelected());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (showReset != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("showReset.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u0"));
                    }
                    showReset.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(org.nuiton.jaxx.demo.component.jaxx.widgets.gis.CoordinatesEditorDemo.this, BINDING_EDITOR_SHOW_RESET_BUTTON));
                }
            }
        
            public void $pr$u0(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_EDITOR_QUADRANT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("quadrant", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    editor.setQuadrant(model.getQuadrant());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("quadrant", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_EDITOR_LATITUDE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("latitude", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    editor.setLatitude(model.getLatitude());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("latitude", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_EDITOR_DISPLAY_ZERO_WHEN_NULL, true) {
        
            @Override
            public void applyDataBinding() {
                if (displayZeroWhenNull != null) {
                    $bindingSources.put("displayZeroWhenNull.getModel()", displayZeroWhenNull.getModel());
                    displayZeroWhenNull.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u1"));
                    displayZeroWhenNull.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(org.nuiton.jaxx.demo.component.jaxx.widgets.gis.CoordinatesEditorDemo.this, BINDING_EDITOR_DISPLAY_ZERO_WHEN_NULL));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (displayZeroWhenNull != null) {
                    editor.setDisplayZeroWhenNull(displayZeroWhenNull.isSelected());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (displayZeroWhenNull != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("displayZeroWhenNull.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u1"));
                    }
                    displayZeroWhenNull.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(org.nuiton.jaxx.demo.component.jaxx.widgets.gis.CoordinatesEditorDemo.this, BINDING_EDITOR_DISPLAY_ZERO_WHEN_NULL));
                }
            }
        
            public void $pr$u1(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_EDITOR_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (enableButton != null) {
                    $bindingSources.put("enableButton.getModel()", enableButton.getModel());
                    enableButton.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u2"));
                    enableButton.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(org.nuiton.jaxx.demo.component.jaxx.widgets.gis.CoordinatesEditorDemo.this, BINDING_EDITOR_ENABLED));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (enableButton != null) {
                    editor.setEnabled(enableButton.isSelected());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (enableButton != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("enableButton.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u2"));
                    }
                    enableButton.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(org.nuiton.jaxx.demo.component.jaxx.widgets.gis.CoordinatesEditorDemo.this, BINDING_EDITOR_ENABLED));
                }
            }
        
            public void $pr$u2(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_EDITOR_LONGITUDE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("longitude", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    editor.setLongitude(model.getLongitude());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("longitude", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_RESULT_QUADRANT_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("quadrant", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    resultQuadrant.setText(handler.getQuadrant(model.getQuadrant()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("quadrant", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_RESULT_LATITUDE_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("latitude", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    resultLatitude.setText(handler.getLatitude(model.getLatitude()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("latitude", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_RESULT_LONGITUDE_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("longitude", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    resultLongitude.setText(handler.getLongitude(model.getLongitude()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("longitude", this);
                }
            }
        });
    }

    @Override
    protected void $initialize_03_finalizeCreateComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_03_finalizeCreateComponents();
        // inline complete setup of $DemoPanel0
        add($Table0, BorderLayout.NORTH);
        // inline complete setup of $Table0
        $Table0.add(config, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        $Table0.add(editor, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        $Table0.add(result, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        addChildrenToConfig();
        addChildrenToResult();
    }

    @Override
    protected void $initialize_04_applyDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_04_applyDataBindings();
    }

    @Override
    protected void $initialize_05_setProperties() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_05_setProperties();
        
        // apply 6 property setters
        config.setBorder(new TitledBorder(t("jaxxdemo.coordinatesEditor.configuration")));
        editor.setBean(model);
        result.setBorder(new TitledBorder(t("jaxxdemo.coordinate.result")));
    }

    @Override
    protected void $initialize_06_finalizeInitialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_06_finalizeInitialize();
    }

}
