package org.nuiton.jaxx.demo.component.jaxx.editor;

/*-
 * #%L
 * JAXX :: Demo
 * %%
 * Copyright (C) 2008 - 2020 Code Lutin, Ultreia.io
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.awt.BorderLayout;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.ButtonModel;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuiton.jaxx.demo.DemoPanel;
import org.nuiton.jaxx.demo.entities.People;
import org.nuiton.jaxx.runtime.JAXXContext;
import org.nuiton.jaxx.runtime.JAXXObjectDescriptor;
import org.nuiton.jaxx.runtime.JAXXUtil;
import org.nuiton.jaxx.runtime.binding.DefaultJAXXBinding;
import org.nuiton.jaxx.runtime.swing.Table;
import org.nuiton.jaxx.widgets.select.BeanFilterableComboBox;
import static io.ultreia.java4all.i18n.I18n.t;

public class BeanFilterableComboBoxDemo extends DemoPanel {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_COMBO_BOX_FILTERABLE = "comboBox.filterable";
    public static final String BINDING_COMBO_BOX_INVALID_COMBO_EDITOR_TEXT_COLOR = "comboBox.invalidComboEditorTextColor";
    public static final String BINDING_COMBO_BOX_SHOW_DECORATOR = "comboBox.showDecorator";
    public static final String BINDING_COMBO_BOX_SHOW_RESET = "comboBox.showReset";
    public static final String BINDING_SELECTED_RESULT_TEXT = "selectedResult.text";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVWTW8bRRgemzofTtqk5eMCaq00bR3RrhukCkQQBduJSGRIleRQkQtj78SeMJ7ZzszWG6z0wIEbf4ADVy6o/6HihMSFa/4DUn8C78yu1/ZmN1lKDqvonfd95pln3vcZ//4PKimJ7gvZdbhPteDOMQ4CR/pc0z5xdr58+nS3fUw6uklUR1JPC4nCv0IRFQ/RghvHlUbOYQuQaiFSzSDVIqRaQ/Q9wQmfANpoobLSJ4yoHiFao2pmcUep2n6cuRF4voz2SmWdttdfP62fFUjzlyJCgQf0y3DsD/8DwPjUV1qoSF2NbrSO8XNcY5h3gZykvAsHumpiDYaV+gb3yTP0As220IyHJYBp9OCN5LFwFirwNFpYbZK+eII5YQ812kwewYVFpzNCC2PEhXXp1AnmW5RpInEbUEW/LeoiMGieZ/FnNJpdPTCLgHw7Sxw1gKM6Ns0Uzce1NzqCH9GuL7GmgluGEDSCBFHRjg2a9MW4avkoplT3Neym0btTNY0e6XwPRE3+Uly2pHpisEcU0WGVCb8znfK2SWmSjgBCQmamrXYEE5L+QLb5c8yoa4XZtJIdkCAbfq4TKajRo6RWA+p2iVaOIgxmJ0P5aR0WJFE+07FC16eXr4VQxN2zaUlhW7gdlt30oLHvZt0dDJIzHqRxTxcOUUn6EIZ7z55hM4Z7kBUO4O3sATTb2MQfX76Qvw1en42mbhHIVS6rmjAYGAFPCo9ITQ23pXDkfE1Z7WvsbRyi+VAW6z73Lma+H2UCe2Bx3SA5Bsn5CqseoJVmz1798d53f7+FiluozAR2t7DJ30bzugeX0xPMDbzHX1hyi4M5+C4bmhrNtIV0gSPaGXIyqBxQzYhbt7Gqrq4YJnYs29AG42637dMWQTSxE6OzsrZ2GoDC9y5WOD7Qy93Xf/76851XI5ULcL7VPJVjpUvfohnKGeXEultkXKlutuAp4rti7EppPoVS7cCLjKZqv/fPaVnU6IqGmYOXJI9o4zBM42g+DIT0SeCbLR5aNcx/H6EUq8nP50EePrEl5aOTtLD8bNbzsondLx+jNMfMz6qer9EvMtt8NHM59mW8SxqV6fon/IkkRxQ8fDlmD3z7MDWwPtlgt4bJ7nGo2o/IVtdONbqaUHxlmCJnsmh+omluDhMdkUx+n6YeuGHk0Gh3mEeXKczK44r1QTzQjkVx9jablU8r3GfsNE36+NG7TN5JW2y8sS2Gb2Loh+fJTD6ZOfhEbfrxsIe5y4h04Inen3pVq6PTTS5ta9KvZjBIvMp5RGH4RMBFoGufuVjjSptyF17wz8+hF8y3fCmiCdtfEifpCMs5OM2ZGzg48cgFOB/8bya3AOFfHZRvTXAMAAA=";
    private static final Logger log = LogManager.getLogger(BeanFilterableComboBoxDemo.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JCheckBox colorizeInvalidComboEditorTextButton;
    protected BeanFilterableComboBox<People> comboBox;
    protected JPanel configurationPanel;
    protected JCheckBox filterableButton;
    protected BeanFilterableComboBoxDemoHandler handler;
    protected JPanel resultPanel;
    protected JLabel selectedResult;
    protected JCheckBox showDecoratorButton;
    protected JCheckBox showResetButton;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private BeanFilterableComboBoxDemo $DemoPanel0;
    private Table $Table0;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public BeanFilterableComboBoxDemo(LayoutManager param0) {
        super(param0);
    }

    public BeanFilterableComboBoxDemo(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
    }

    public BeanFilterableComboBoxDemo(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
    }

    public BeanFilterableComboBoxDemo(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
    }

    public BeanFilterableComboBoxDemo() {
        
    }

    public BeanFilterableComboBoxDemo(JAXXContext param0) {
        super(param0);
    }

    public BeanFilterableComboBoxDemo(boolean param0) {
        super(param0);
    }

    public BeanFilterableComboBoxDemo(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JCheckBox getColorizeInvalidComboEditorTextButton() {
        return colorizeInvalidComboEditorTextButton;
    }

    public BeanFilterableComboBox<People> getComboBox() {
        return comboBox;
    }

    public JPanel getConfigurationPanel() {
        return configurationPanel;
    }

    public JCheckBox getFilterableButton() {
        return filterableButton;
    }

    public BeanFilterableComboBoxDemoHandler getHandler() {
        return handler;
    }

    public JPanel getResultPanel() {
        return resultPanel;
    }

    public JLabel getSelectedResult() {
        return selectedResult;
    }

    public JCheckBox getShowDecoratorButton() {
        return showDecoratorButton;
    }

    public JCheckBox getShowResetButton() {
        return showResetButton;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected Table get$Table0() {
        return $Table0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToConfigurationPanel() {
        configurationPanel.add(filterableButton);
        configurationPanel.add(showResetButton);
        configurationPanel.add(showDecoratorButton);
        configurationPanel.add(colorizeInvalidComboEditorTextButton);
    }

    protected void addChildrenToResultPanel() {
        resultPanel.add(selectedResult, BorderLayout.CENTER);
    }

    protected void createColorizeInvalidComboEditorTextButton() {
        $objectMap.put("colorizeInvalidComboEditorTextButton", colorizeInvalidComboEditorTextButton = new JCheckBox());
        
        colorizeInvalidComboEditorTextButton.setName("colorizeInvalidComboEditorTextButton");
        colorizeInvalidComboEditorTextButton.setText(t("jaxxdemo.beanfilterablecomboboxdemo.colorizeInvalidComboEditorText"));
        colorizeInvalidComboEditorTextButton.setSelected(true);
    }

    protected void createComboBox() {
        $objectMap.put("comboBox", comboBox = new BeanFilterableComboBox<People>());
        
        comboBox.setName("comboBox");
        comboBox.setI18nPrefix("jaxxdemo.common.");
    }

    protected void createConfigurationPanel() {
        $objectMap.put("configurationPanel", configurationPanel = new JPanel());
        
        configurationPanel.setName("configurationPanel");
        configurationPanel.setLayout(new GridLayout(0,1));
    }

    protected void createFilterableButton() {
        $objectMap.put("filterableButton", filterableButton = new JCheckBox());
        
        filterableButton.setName("filterableButton");
        filterableButton.setText(t("jaxxdemo.beanfilterablecomboboxdemo.filterable"));
        filterableButton.setSelected(true);
    }

    protected void createResultPanel() {
        $objectMap.put("resultPanel", resultPanel = new JPanel());
        
        resultPanel.setName("resultPanel");
        resultPanel.setLayout(new BorderLayout());
    }

    protected void createSelectedResult() {
        $objectMap.put("selectedResult", selectedResult = new JLabel());
        
        selectedResult.setName("selectedResult");
    }

    protected void createShowDecoratorButton() {
        $objectMap.put("showDecoratorButton", showDecoratorButton = new JCheckBox());
        
        showDecoratorButton.setName("showDecoratorButton");
        showDecoratorButton.setText(t("jaxxdemo.beanfilterablecomboboxdemo.showDecorator"));
        showDecoratorButton.setSelected(true);
    }

    protected void createShowResetButton() {
        $objectMap.put("showResetButton", showResetButton = new JCheckBox());
        
        showResetButton.setName("showResetButton");
        showResetButton.setText(t("jaxxdemo.beanfilterablecomboboxdemo.showReset"));
        showResetButton.setSelected(true);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    protected void $initialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $DemoPanel0 = this;
        handler = new BeanFilterableComboBoxDemoHandler();
        handler.beforeInit(this);
        super.$initialize();
        handler.afterInit(this);
    }

    @Override
    protected void $initialize_01_createComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_01_createComponents();
        $objectMap.put("$DemoPanel0", $DemoPanel0);
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        createConfigurationPanel();
        createFilterableButton();
        createShowResetButton();
        createShowDecoratorButton();
        createColorizeInvalidComboEditorTextButton();
        createComboBox();
        createResultPanel();
        createSelectedResult();
        // inline creation of $DemoPanel0
        setName("$DemoPanel0");
        setLayout(new BorderLayout());
    }

    @Override
    protected void $initialize_02_registerDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_02_registerDataBindings();
        // register 5 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_COMBO_BOX_FILTERABLE, true) {
        
            @Override
            public void applyDataBinding() {
                if (filterableButton != null) {
                    $bindingSources.put("filterableButton.getModel()", filterableButton.getModel());
                    filterableButton.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u0"));
                    filterableButton.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(org.nuiton.jaxx.demo.component.jaxx.editor.BeanFilterableComboBoxDemo.this, BINDING_COMBO_BOX_FILTERABLE));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (filterableButton != null) {
                    comboBox.setFilterable(filterableButton.isSelected());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (filterableButton != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("filterableButton.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u0"));
                    }
                    filterableButton.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(org.nuiton.jaxx.demo.component.jaxx.editor.BeanFilterableComboBoxDemo.this, BINDING_COMBO_BOX_FILTERABLE));
                }
            }
        
            public void $pr$u0(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_COMBO_BOX_SHOW_DECORATOR, true) {
        
            @Override
            public void applyDataBinding() {
                if (showDecoratorButton != null) {
                    $bindingSources.put("showDecoratorButton.getModel()", showDecoratorButton.getModel());
                    showDecoratorButton.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u1"));
                    showDecoratorButton.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(org.nuiton.jaxx.demo.component.jaxx.editor.BeanFilterableComboBoxDemo.this, BINDING_COMBO_BOX_SHOW_DECORATOR));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (showDecoratorButton != null) {
                    comboBox.setShowDecorator(showDecoratorButton.isSelected());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (showDecoratorButton != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("showDecoratorButton.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u1"));
                    }
                    showDecoratorButton.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(org.nuiton.jaxx.demo.component.jaxx.editor.BeanFilterableComboBoxDemo.this, BINDING_COMBO_BOX_SHOW_DECORATOR));
                }
            }
        
            public void $pr$u1(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_COMBO_BOX_SHOW_RESET, true) {
        
            @Override
            public void applyDataBinding() {
                if (showResetButton != null) {
                    $bindingSources.put("showResetButton.getModel()", showResetButton.getModel());
                    showResetButton.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u2"));
                    showResetButton.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(org.nuiton.jaxx.demo.component.jaxx.editor.BeanFilterableComboBoxDemo.this, BINDING_COMBO_BOX_SHOW_RESET));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (showResetButton != null) {
                    comboBox.setShowReset(showResetButton.isSelected());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (showResetButton != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("showResetButton.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u2"));
                    }
                    showResetButton.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(org.nuiton.jaxx.demo.component.jaxx.editor.BeanFilterableComboBoxDemo.this, BINDING_COMBO_BOX_SHOW_RESET));
                }
            }
        
            public void $pr$u2(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_COMBO_BOX_INVALID_COMBO_EDITOR_TEXT_COLOR, true) {
        
            @Override
            public void applyDataBinding() {
                if (colorizeInvalidComboEditorTextButton != null) {
                    $bindingSources.put("colorizeInvalidComboEditorTextButton.getModel()", colorizeInvalidComboEditorTextButton.getModel());
                    colorizeInvalidComboEditorTextButton.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u3"));
                    colorizeInvalidComboEditorTextButton.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(org.nuiton.jaxx.demo.component.jaxx.editor.BeanFilterableComboBoxDemo.this, BINDING_COMBO_BOX_INVALID_COMBO_EDITOR_TEXT_COLOR));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (colorizeInvalidComboEditorTextButton != null) {
                    comboBox.setInvalidComboEditorTextColor(colorizeInvalidComboEditorTextButton.isSelected() ? java.awt.Color.RED : null);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (colorizeInvalidComboEditorTextButton != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("colorizeInvalidComboEditorTextButton.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u3"));
                    }
                    colorizeInvalidComboEditorTextButton.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(org.nuiton.jaxx.demo.component.jaxx.editor.BeanFilterableComboBoxDemo.this, BINDING_COMBO_BOX_INVALID_COMBO_EDITOR_TEXT_COLOR));
                }
            }
        
            public void $pr$u3(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SELECTED_RESULT_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (comboBox != null) {
                    comboBox.addPropertyChangeListener("selectedItem", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (comboBox != null) {
                    selectedResult.setText(handler.getSelectedResult(comboBox.getSelectedItem()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (comboBox != null) {
                    comboBox.removePropertyChangeListener("selectedItem", this);
                }
            }
        });
    }

    @Override
    protected void $initialize_03_finalizeCreateComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_03_finalizeCreateComponents();
        // inline complete setup of $DemoPanel0
        add($Table0, BorderLayout.NORTH);
        // inline complete setup of $Table0
        $Table0.add(configurationPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        $Table0.add(comboBox, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        $Table0.add(resultPanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        addChildrenToConfigurationPanel();
        addChildrenToResultPanel();
    }

    @Override
    protected void $initialize_04_applyDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_04_applyDataBindings();
    }

    @Override
    protected void $initialize_05_setProperties() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_05_setProperties();
        
        // apply 6 property setters
        comboBox.setBeanType(People.class);
        configurationPanel.setBorder(new TitledBorder(t("jaxxdemo.beanfilterablecomboboxdemo.configuration")));
        resultPanel.setBorder(new TitledBorder(t("jaxxdemo.beanfilterablecomboboxdemo.result")));
    }

    @Override
    protected void $initialize_06_finalizeInitialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_06_finalizeInitialize();
    }

}
