package org.nuiton.jaxx.demo.component.jaxx.editor;

/*-
 * #%L
 * JAXX :: Demo
 * %%
 * Copyright (C) 2008 - 2018 Code Lutin, Ultreia.io
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.awt.BorderLayout;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JLabel;
import javax.swing.JTextArea;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuiton.i18n.CountryEnum;
import org.nuiton.i18n.LanguageEnum;
import org.nuiton.jaxx.demo.DemoPanel;
import org.nuiton.jaxx.runtime.JAXXContext;
import org.nuiton.jaxx.runtime.JAXXObjectDescriptor;
import org.nuiton.jaxx.runtime.JAXXUtil;
import org.nuiton.jaxx.runtime.binding.DefaultJAXXBinding;
import org.nuiton.jaxx.runtime.swing.SwingUtil;
import org.nuiton.jaxx.runtime.swing.Table;
import org.nuiton.jaxx.runtime.swing.editor.EnumEditor;
import org.nuiton.jaxx.runtime.swing.editor.LocaleEditor;
import static org.nuiton.i18n.I18n.t;

public class ComboEditorDemo extends DemoPanel {

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JTEXT_AREA0_TEXT = "$JTextArea0.text";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKWUz08TQRTHXysthQICiSTGgyRUMCi71HgRCEr4ESWrGOFA7MVpd1K2me6Ms7OyXDh48OY/4MGrF8P/QDyZePHK/2DCn+Cb2W1LTVsL9DC7nXnv877v7bz3/Q9kAgkPuaxafugp7ls1EkWWDH3l1am1vba/v1Ou0YraoEFFekJxCfEvlYZ0CfJucz9QYJUcJNkxydYkOyHZ67wuuE/9C6BlB4YDdcRocECpUnC/q3MlCOzdpuVyJEKZxOqoulOsX5+KZym68SUNEAmUP4RpP7gEoJX1gANpz1Uw6dTIB2Iz4ldRnPT8KiY0qvfWGQmCV6RO38MxDDqQFUQiTMHClcpjcAYVCQX5wgat89fEp2xRwdK/Kbh4aFUatHiPungudVZlvmneNUIIA80qGCzskTKjiJvpVpHgEPOzjJl2Gmr65grbDikbLZM69ygxjXe10UjTdoTxCmE0lqCg2DtYotq54NOOa4Qu6v8T7Wdj+rOEpNoMZvcVbNMP671CPeoQarTCESWPWn632w3yhe09Gqk1SQlW6VZblRoHiYeE2W46sQesVg+0rmOqBBkZ4jZ+ve7tpzvoDVrFvTPTvXd0GGP48eRYfjs8P2s0TA7FTf/P68JswNsrJBdUKk9ruxl3S6g8Zr8kYrmEHUgZDhYzOOZ6K99NLFE9qpjQJEuTrOckOEBaZvDs9MfUu983IL0Fw4wTd4to+xcwpA4kVowzNxJPnxlxI4c5XMe1TAVZRo54iK05tuISRabLnu/ih1mNsEpzvavUFHWyc/7z6+d7p41KpVBjoR/PVrUybyHr+czzqRkuydzoOEzyIqChy1tDodOYSOnnsEhafNas853yzzF9rbfie7sQhfphmRz026LhjPfBGVB4kXEErMRZTBOFE7EcKrp6VabeftxD1VRfhCd6WboOoZeGO9fWcAlCFw13kfAXX/yFxccHAAA=";
    private static final Logger log = LogManager.getLogger(ComboEditorDemo.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected EnumEditor<CountryEnum> countryEditor;
    protected EnumEditor<LanguageEnum> languageEditor;
    protected LocaleEditor localeEditor;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private ComboEditorDemo $DemoPanel0;
    private JLabel $JLabel0;
    private JLabel $JLabel1;
    private JLabel $JLabel2;
    private JTextArea $JTextArea0;
    private Table $Table0;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public ComboEditorDemo(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
    }

    public ComboEditorDemo(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
    }

    public ComboEditorDemo(LayoutManager param0) {
        super(param0);
    }

    public ComboEditorDemo(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
    }

    public ComboEditorDemo() {
        
    }

    public ComboEditorDemo(JAXXContext param0) {
        super(param0);
    }

    public ComboEditorDemo(boolean param0) {
        super(param0);
    }

    public ComboEditorDemo(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public EnumEditor<CountryEnum> getCountryEditor() {
        return countryEditor;
    }

    public EnumEditor<LanguageEnum> getLanguageEditor() {
        return languageEditor;
    }

    public LocaleEditor getLocaleEditor() {
        return localeEditor;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected JLabel get$JLabel2() {
        return $JLabel2;
    }

    protected JTextArea get$JTextArea0() {
        return $JTextArea0;
    }

    protected Table get$Table0() {
        return $Table0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void createCountryEditor() {
        $objectMap.put("countryEditor", countryEditor = new EnumEditor<CountryEnum>(CountryEnum.class));
        
        countryEditor.setName("countryEditor");
    }

    protected void createLanguageEditor() {
        $objectMap.put("languageEditor", languageEditor = new EnumEditor<LanguageEnum>(LanguageEnum.class));
        
        languageEditor.setName("languageEditor");
    }

    protected void createLocaleEditor() {
        $objectMap.put("localeEditor", localeEditor = new LocaleEditor());
        
        localeEditor.setName("localeEditor");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    protected void $initialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $DemoPanel0 = this;
        super.$initialize();
    }

    @Override
    protected void $initialize_01_createComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_01_createComponents();
        $objectMap.put("$DemoPanel0", $DemoPanel0);
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(t("Locale editor:"));
        createLocaleEditor();
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new JLabel());
        
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText("EnumEditor (language) :");
        createLanguageEditor();
        // inline creation of $JLabel2
        $objectMap.put("$JLabel2", $JLabel2 = new JLabel());
        
        $JLabel2.setName("$JLabel2");
        $JLabel2.setText("EnumEditor (country) :");
        createCountryEditor();
        // inline creation of $JTextArea0
        $objectMap.put("$JTextArea0", $JTextArea0 = new JTextArea());
        
        $JTextArea0.setName("$JTextArea0");
        $JTextArea0.setColumns(15);
        $JTextArea0.setLineWrap(true);
        $JTextArea0.setWrapStyleWord(true);
        // inline creation of $DemoPanel0
        setName("$DemoPanel0");
        setLayout(new BorderLayout());
    }

    @Override
    protected void $initialize_02_registerDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_02_registerDataBindings();
        // register 1 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_$JTEXT_AREA0_TEXT, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (localeEditor != null) {
                    $bindingSources.put("localeEditor", localeEditor);
                    localeEditor.addItemListener( JAXXUtil.getEventListener(ItemListener.class, this, "$pr$u0"));
                }
                if (languageEditor != null) {
                    $bindingSources.put("languageEditor", languageEditor);
                    languageEditor.addItemListener( JAXXUtil.getEventListener(ItemListener.class, this, "$pr$u0"));
                }
                if (countryEditor != null) {
                    $bindingSources.put("countryEditor", countryEditor);
                    countryEditor.addItemListener( JAXXUtil.getEventListener(ItemListener.class, this, "$pr$u0"));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (localeEditor != null && countryEditor != null && languageEditor != null) {
                    SwingUtil.setText($JTextArea0, "locale : "+ localeEditor.getSelectedItem() + "\nlanguage : "+ languageEditor.getSelectedItem() + "\ncountry : " + countryEditor.getSelectedItem());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (localeEditor != null) {
                    LocaleEditor $target = (LocaleEditor) $bindingSources.remove("localeEditor");
                    if ($target != null) {
                        $target.removeItemListener( JAXXUtil.getEventListener(ItemListener.class, this, "$pr$u0"));
                    }
                }
                if (languageEditor != null) {
                    EnumEditor $target = (EnumEditor) $bindingSources.remove("languageEditor");
                    if ($target != null) {
                        $target.removeItemListener( JAXXUtil.getEventListener(ItemListener.class, this, "$pr$u0"));
                    }
                }
                if (countryEditor != null) {
                    EnumEditor $target = (EnumEditor) $bindingSources.remove("countryEditor");
                    if ($target != null) {
                        $target.removeItemListener( JAXXUtil.getEventListener(ItemListener.class, this, "$pr$u0"));
                    }
                }
            }
        
            public void $pr$u0(ItemEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
    }

    @Override
    protected void $initialize_03_finalizeCreateComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_03_finalizeCreateComponents();
        // inline complete setup of $DemoPanel0
        add($Table0, BorderLayout.CENTER);
        // inline complete setup of $Table0
        $Table0.add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(localeEditor, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel1, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(languageEditor, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel2, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(countryEditor, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JTextArea0, new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    @Override
    protected void $initialize_04_applyDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_04_applyDataBindings();
    }

    @Override
    protected void $initialize_05_setProperties() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_05_setProperties();
        
        // apply 4 property setters
        $JLabel0.setLabelFor(localeEditor);
        $JLabel1.setLabelFor(languageEditor);
        $JLabel2.setLabelFor(countryEditor);
    }

    @Override
    protected void $initialize_06_finalizeInitialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_06_finalizeInitialize();
    }

}
