package org.nuiton.jaxx.demo.fun;

/*-
 * #%L
 * JAXX :: Demo
 * %%
 * Copyright (C) 2008 - 2018 Code Lutin, Ultreia.io
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.awt.BorderLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JTextField;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.jaxx.demo.DemoPanel;
import org.nuiton.jaxx.runtime.JAXXContext;
import org.nuiton.jaxx.runtime.JAXXObjectDescriptor;
import org.nuiton.jaxx.runtime.JAXXUtil;
import org.nuiton.jaxx.runtime.binding.SimpleJAXXObjectBinding;
import org.nuiton.jaxx.runtime.swing.HBox;
import org.nuiton.jaxx.runtime.swing.SwingUtil;
import static org.nuiton.i18n.I18n.t;

public class CounterDemo extends DemoPanel {

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JTEXT_FIELD0_TEXT = "$JTextField0.text";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVTPW8TQRAdG9vBcUKAIIsKWYlJIhHuCK0jPhLLCpYhiFBEuMnat9hnne+W3Tl8NCko6PgDFLQ0KP8hokKiofV/QMpPYPbO8TnYDl8u1qfZN2/ezM77/APSSsK6J1uG69vouUaHBYEhfRftLjeqD/f3dxsd3sQyV01pC/QkRL9EEpJ1yFnDuEIw6jViMiMmUzOZAyZz2+sKz+XuCFGpBrMK3zhctTlHhLWpyU2lzL0hshQIXw5qTVQ9qda3dxv9BC9/SAIEguRnqO1bf0EQd52qQdK2EK7WOuw1Mx3mtkictN0WNTSvY9sOU+oJ6/JXcAgzNcgIJokM4fY/jSekC6kCgZArlnnXe8pc7txBKP7agkWXxkvfpR6ImksNFiJMzyDMFavPeYAVmzsWZee12sBQPRJvxDcanB3mZIo7W15A6KVp44ryNepsZrZY3fKR4JS8eKZUFNawhXH0hg5cm3J5d/RSwso0TbQyRrwy8esl6pCWPoURlqdvq164Z4SKVm15+qrpMiHw7dGh/NQ76Z/uV4rEFX6XNWIlemwhPcEl2lrbQrRcPtqO+ZiJUh2yijvkw9Bnq+cr3xsgST2puKKZDM1k7DDVJrb0TP/4S/7g+wVIVmDW8ZhVYRr/CLLYljQxz7ECcf9BKG6ud5HOy1omQgppRxAubVoMWaFhuxY9572AZrR6/oyGko52T75+fH/z+HROCVI4tsSTMuNZpV9AxnYd2+WhEwcmm+i8nFDct7zYQZM8ldD/82LgkhvhuTTevQ4XyfabUe0CQzJ9w0dO/eu7lbAb/bUWYhf/jFEf65MZ8v/NcJ0YfgKR6QGO5AUAAA==";
    private static final Log log = LogFactory.getLog(CounterDemo.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private CounterDemo $DemoPanel0;
    private HBox $HBox0;
    private JButton $JButton0;
    private JButton $JButton1;
    private JButton $JButton2;
    private JTextField $JTextField0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    int count;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public CounterDemo(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
    }

    public CounterDemo(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
    }

    public CounterDemo(LayoutManager param0) {
        super(param0);
    }

    public CounterDemo(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
    }

    public CounterDemo() {
        
    }

    public CounterDemo(JAXXContext param0) {
        super(param0);
    }

    public CounterDemo(boolean param0) {
        super(param0);
    }

    public CounterDemo(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__$JButton0(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        count--;
    }

    public void doActionPerformed__on__$JButton1(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        count = 0;
    }

    public void doActionPerformed__on__$JButton2(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        count++;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected HBox get$HBox0() {
        return $HBox0;
    }

    protected JButton get$JButton0() {
        return $JButton0;
    }

    protected JButton get$JButton1() {
        return $JButton1;
    }

    protected JButton get$JButton2() {
        return $JButton2;
    }

    protected JTextField get$JTextField0() {
        return $JTextField0;
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    protected void $initialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $DemoPanel0 = this;
        super.$initialize();
    }

    @Override
    protected void $initialize_01_createComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_01_createComponents();
        $objectMap.put("$DemoPanel0", $DemoPanel0);
        // inline creation of $JTextField0
        $objectMap.put("$JTextField0", $JTextField0 = new JTextField());
        
        $JTextField0.setName("$JTextField0");
        $JTextField0.setColumns(15);
        // inline creation of $HBox0
        $objectMap.put("$HBox0", $HBox0 = new HBox());
        
        $HBox0.setName("$HBox0");
        // inline creation of $JButton0
        $objectMap.put("$JButton0", $JButton0 = new JButton());
        
        $JButton0.setName("$JButton0");
        $JButton0.setText("Dec (-)");
        $JButton0.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton0"));
        // inline creation of $JButton1
        $objectMap.put("$JButton1", $JButton1 = new JButton());
        
        $JButton1.setName("$JButton1");
        $JButton1.setText(t("Reset"));
        $JButton1.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton1"));
        // inline creation of $JButton2
        $objectMap.put("$JButton2", $JButton2 = new JButton());
        
        $JButton2.setName("$JButton2");
        $JButton2.setText("Inc (+)");
        $JButton2.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton2"));
        // inline creation of $DemoPanel0
        setName("$DemoPanel0");
    }

    @Override
    protected void $initialize_02_registerDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_02_registerDataBindings();
        // register 1 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JTEXT_FIELD0_TEXT, true ,"count") {
        
            @Override
            public void processDataBinding() {
                SwingUtil.setText($JTextField0, count+"");
            }
        });
    }

    @Override
    protected void $initialize_03_finalizeCreateComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_03_finalizeCreateComponents();
        // inline complete setup of $DemoPanel0
        add($JTextField0, BorderLayout.NORTH);
        add($HBox0, BorderLayout.SOUTH);
        // inline complete setup of $HBox0
        $HBox0.add($JButton0);
        $HBox0.add($JButton1);
        $HBox0.add($JButton2);
    }

    @Override
    protected void $initialize_04_applyDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_04_applyDataBindings();
        
        // apply 1 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
    }

    @Override
    protected void $initialize_05_setProperties() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_05_setProperties();
    }

    @Override
    protected void $initialize_06_finalizeInitialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_06_finalizeInitialize();
    }

}
