package org.nuiton.jaxx.demo.component.jaxx.widgets.select;

/*-
 * #%L
 * JAXX :: Demo
 * %%
 * Copyright (C) 2008 - 2018 Code Lutin, Ultreia.io
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.awt.BorderLayout;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.ButtonModel;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.jaxx.demo.DemoPanel;
import org.nuiton.jaxx.demo.entities.People;
import org.nuiton.jaxx.runtime.JAXXContext;
import org.nuiton.jaxx.runtime.JAXXObjectDescriptor;
import org.nuiton.jaxx.runtime.JAXXUtil;
import org.nuiton.jaxx.runtime.binding.DefaultJAXXBinding;
import org.nuiton.jaxx.runtime.swing.SwingUtil;
import org.nuiton.jaxx.runtime.swing.Table;
import org.nuiton.jaxx.widgets.select.FilterableDoubleList;
import static org.nuiton.i18n.I18n.t;

public class FilterableDoubleListDemo extends DemoPanel {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_DOUBLE_LIST_ENABLED = "doubleList.enabled";
    public static final String BINDING_DOUBLE_LIST_FILTERABLE = "doubleList.filterable";
    public static final String BINDING_DOUBLE_LIST_HIGHLIGHT_FILTER_TEXT = "doubleList.highlightFilterText";
    public static final String BINDING_DOUBLE_LIST_SELECTED = "doubleList.selected";
    public static final String BINDING_DOUBLE_LIST_SHOW_DECORATOR = "doubleList.showDecorator";
    public static final String BINDING_DOUBLE_LIST_SHOW_RESET = "doubleList.showReset";
    public static final String BINDING_RESULT_TEXT = "result.text";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAK1Wz28bRRQeu3ESxy0piVqEkCCkaeuosEtVVaoUxI/EiqC4NEpyqJpLx96Jd8J4Z5l5W29ktQcOSCDxD3DgygX1f6g4IXHhmv8BqX8Cb3a3u/ZmbS+ISFlZs+99873vzftmf/ub1LQiH0jVs7yAg/SsExqGlgo84H1m3f/80aOHnRPWhRbTXcV9kIrEf5UqqR6RhpOuayDWURuR7BjJNkh2gmTvyL4vPeaNAG21yZKGU8G0yxgAaU5M7mptH6SRW6EfqGSvQtZFe/35/e2zCmv9XCUk9JF+A8u+9S8Asqrn2qTKHSAr7RP6lNqCej0kp7jXw4IumbUdQbX+mvbZt+Q5WWiTeZ8qBAPy4X+SJ4KLoEIfSGOjxfpyj3pMfATkq3wJDr60uq/R4rUBd3oMtKWZwE5au1wAU7QjWEsG+GxzDQbT96Nd5oHU+tJhAsje/4j+wEBmWyxsHJoYLOHapC7oAWpqRWEmqZ7mrnSld8x7gaLApRdJgYtG+TBJuh8tmvDlNOvyccpsOwDcDciVsZwdl3W/2ZahiV9J0952ec8V+A9xZYcshDjfBLw1HrysXTnYZ5pNDlk1IS3WlcheqolhF5mXMS14v+Sk6gK5k5ewRE/GxZlXTAcC8pKYYo2USbAiNyY1C0fUykY0m5bKEampAJex0ZPdwQz4PkbFo31t8mibbaLA7148V78OXp2NzvParKwR68Lh8pX0mQJuuC3HwxwAF/YD6m8dkXqsXeRrN6czP0gikT2yeNMgWQbJ+oJqF9FqC2cvf7/65K8LpLpLloSkzi418V+SOrgovCuFE/qffhaRuzhYxOdlQxPb0pHKQY5ke+ixwdohB8Gc7WitCc11wyQayQ6jXnwgBLY2mdKRGVnf3HwWorI3pyubFvLi4as/fvnp+svX6lawro0ymZnCtcdknnuCeyzyy8QKC/2x4WsWODLzuSLnI4Vz7yeOcit62uc0rAKZAzzEQG5MEyuzBiCLceOZY1JVwMLAQN+JVDC/7pICLynPw57Go8BrxgjVjqnQhYwm21R5atenUUudrZxCeScsz2JzFovUPMsxKTLc8mymzljs0eVojBn6rP3raPD89j1vT7FjHuJ5S1ng5dvHAcT3o2f2vWH+QFpcHySkmpvPgFzKKbc+LJAln7SYWOTpWIn1kaPw7jDX5zzEauGRbg4nHtc8wJzRHb8XhtE3CS4sxEIikXeGo5qeI58xvhInW3gnjoQUdWnkWp3Vowu4BXM4xB2IJzOb8qGLp0UwZQW+Q4HtR9erqbJZQMXQbaC5AX5UHZ76CFM3MLYLfVHEMrmtZzE0F4igpxLlIW98jDToWod7Dt7sn5xDrZjn0kxEs/yDefxYjLBagtOi6agpcwrO+4jzD5nWEVydDAAA";
    private static final Log log = LogFactory.getLog(FilterableDoubleListDemo.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel configurationPanel;
    protected FilterableDoubleList<People> doubleList;
    protected JCheckBox enableButton;
    protected JCheckBox filterableButton;
    protected FilterableDoubleListDemoHandler handler;
    protected JCheckBox highlightFilterTextButton;
    protected FilterableDoubleListDemoModel model;
    protected JTextPane result;
    protected JCheckBox showDecoratorButton;
    protected JCheckBox showResetButton;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private FilterableDoubleListDemo $DemoPanel0;
    private Table $Table0;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public FilterableDoubleListDemo(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
    }

    public FilterableDoubleListDemo(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
    }

    public FilterableDoubleListDemo(LayoutManager param0) {
        super(param0);
    }

    public FilterableDoubleListDemo(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
    }

    public FilterableDoubleListDemo() {
        
    }

    public FilterableDoubleListDemo(JAXXContext param0) {
        super(param0);
    }

    public FilterableDoubleListDemo(boolean param0) {
        super(param0);
    }

    public FilterableDoubleListDemo(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JPanel getConfigurationPanel() {
        return configurationPanel;
    }

    public FilterableDoubleList<People> getDoubleList() {
        return doubleList;
    }

    public JCheckBox getEnableButton() {
        return enableButton;
    }

    public JCheckBox getFilterableButton() {
        return filterableButton;
    }

    public FilterableDoubleListDemoHandler getHandler() {
        return handler;
    }

    public JCheckBox getHighlightFilterTextButton() {
        return highlightFilterTextButton;
    }

    public FilterableDoubleListDemoModel getModel() {
        return model;
    }

    public JTextPane getResult() {
        return result;
    }

    public JCheckBox getShowDecoratorButton() {
        return showDecoratorButton;
    }

    public JCheckBox getShowResetButton() {
        return showResetButton;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected Table get$Table0() {
        return $Table0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToConfigurationPanel() {
        configurationPanel.add(filterableButton);
        configurationPanel.add(highlightFilterTextButton);
        configurationPanel.add(showResetButton);
        configurationPanel.add(showDecoratorButton);
        configurationPanel.add(enableButton);
    }

    protected void createConfigurationPanel() {
        $objectMap.put("configurationPanel", configurationPanel = new JPanel());
        
        configurationPanel.setName("configurationPanel");
        configurationPanel.setLayout(new GridLayout(0,1));
    }

    protected void createDoubleList() {
        $objectMap.put("doubleList", doubleList = new FilterableDoubleList<People>());
        
        doubleList.setName("doubleList");
        doubleList.setI18nPrefix("jaxxdemo.common.");
        doubleList.setProperty("selected");
    }

    protected void createEnableButton() {
        $objectMap.put("enableButton", enableButton = new JCheckBox());
        
        enableButton.setName("enableButton");
        enableButton.setText(t("jaxxdemo.beandoublelistdemo.enable"));
        enableButton.setSelected(true);
    }

    protected void createFilterableButton() {
        $objectMap.put("filterableButton", filterableButton = new JCheckBox());
        
        filterableButton.setName("filterableButton");
        filterableButton.setText(t("jaxxdemo.beandoublelistdemo.filterable"));
        filterableButton.setSelected(true);
    }

    protected void createHighlightFilterTextButton() {
        $objectMap.put("highlightFilterTextButton", highlightFilterTextButton = new JCheckBox());
        
        highlightFilterTextButton.setName("highlightFilterTextButton");
        highlightFilterTextButton.setText(t("jaxxdemo.beandoublelistdemo.highlightFilterText"));
        highlightFilterTextButton.setSelected(false);
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(FilterableDoubleListDemoModel.class));
    }

    protected void createResult() {
        $objectMap.put("result", result = new JTextPane());
        
        result.setName("result");
        result.setEditable(false);
        result.setContentType("text/html");
    }

    protected void createShowDecoratorButton() {
        $objectMap.put("showDecoratorButton", showDecoratorButton = new JCheckBox());
        
        showDecoratorButton.setName("showDecoratorButton");
        showDecoratorButton.setText(t("jaxxdemo.beandoublelistdemo.showDecorator"));
        showDecoratorButton.setSelected(true);
    }

    protected void createShowResetButton() {
        $objectMap.put("showResetButton", showResetButton = new JCheckBox());
        
        showResetButton.setName("showResetButton");
        showResetButton.setText(t("jaxxdemo.beandoublelistdemo.showReset"));
        showResetButton.setSelected(true);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    protected void $initialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $DemoPanel0 = this;
        handler = new FilterableDoubleListDemoHandler();
        handler.beforeInit(this);
        super.$initialize();
        handler.afterInit(this);
    }

    @Override
    protected void $initialize_01_createComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_01_createComponents();
        $objectMap.put("$DemoPanel0", $DemoPanel0);
        createModel();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        createConfigurationPanel();
        createFilterableButton();
        createHighlightFilterTextButton();
        createShowResetButton();
        createShowDecoratorButton();
        createEnableButton();
        createDoubleList();
        createResult();
        // inline creation of $DemoPanel0
        setName("$DemoPanel0");
        setLayout(new BorderLayout());
    }

    @Override
    protected void $initialize_02_registerDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_02_registerDataBindings();
        // register 7 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_DOUBLE_LIST_FILTERABLE, true) {
        
            @Override
            public void applyDataBinding() {
                if (filterableButton != null) {
                    $bindingSources.put("filterableButton.getModel()", filterableButton.getModel());
                    filterableButton.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u0"));
                    filterableButton.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(org.nuiton.jaxx.demo.component.jaxx.widgets.select.FilterableDoubleListDemo.this, BINDING_DOUBLE_LIST_FILTERABLE));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (filterableButton != null) {
                    doubleList.setFilterable(filterableButton.isSelected());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (filterableButton != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("filterableButton.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u0"));
                    }
                    filterableButton.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(org.nuiton.jaxx.demo.component.jaxx.widgets.select.FilterableDoubleListDemo.this, BINDING_DOUBLE_LIST_FILTERABLE));
                }
            }
        
            public void $pr$u0(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_DOUBLE_LIST_SHOW_DECORATOR, true) {
        
            @Override
            public void applyDataBinding() {
                if (showDecoratorButton != null) {
                    $bindingSources.put("showDecoratorButton.getModel()", showDecoratorButton.getModel());
                    showDecoratorButton.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u1"));
                    showDecoratorButton.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(org.nuiton.jaxx.demo.component.jaxx.widgets.select.FilterableDoubleListDemo.this, BINDING_DOUBLE_LIST_SHOW_DECORATOR));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (showDecoratorButton != null) {
                    doubleList.setShowDecorator(showDecoratorButton.isSelected());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (showDecoratorButton != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("showDecoratorButton.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u1"));
                    }
                    showDecoratorButton.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(org.nuiton.jaxx.demo.component.jaxx.widgets.select.FilterableDoubleListDemo.this, BINDING_DOUBLE_LIST_SHOW_DECORATOR));
                }
            }
        
            public void $pr$u1(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_DOUBLE_LIST_SHOW_RESET, true) {
        
            @Override
            public void applyDataBinding() {
                if (showResetButton != null) {
                    $bindingSources.put("showResetButton.getModel()", showResetButton.getModel());
                    showResetButton.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u2"));
                    showResetButton.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(org.nuiton.jaxx.demo.component.jaxx.widgets.select.FilterableDoubleListDemo.this, BINDING_DOUBLE_LIST_SHOW_RESET));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (showResetButton != null) {
                    doubleList.setShowReset(showResetButton.isSelected());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (showResetButton != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("showResetButton.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u2"));
                    }
                    showResetButton.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(org.nuiton.jaxx.demo.component.jaxx.widgets.select.FilterableDoubleListDemo.this, BINDING_DOUBLE_LIST_SHOW_RESET));
                }
            }
        
            public void $pr$u2(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_DOUBLE_LIST_HIGHLIGHT_FILTER_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (highlightFilterTextButton != null) {
                    $bindingSources.put("highlightFilterTextButton.getModel()", highlightFilterTextButton.getModel());
                    highlightFilterTextButton.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u3"));
                    highlightFilterTextButton.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(org.nuiton.jaxx.demo.component.jaxx.widgets.select.FilterableDoubleListDemo.this, BINDING_DOUBLE_LIST_HIGHLIGHT_FILTER_TEXT));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (highlightFilterTextButton != null) {
                    doubleList.setHighlightFilterText(highlightFilterTextButton.isSelected());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (highlightFilterTextButton != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("highlightFilterTextButton.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u3"));
                    }
                    highlightFilterTextButton.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(org.nuiton.jaxx.demo.component.jaxx.widgets.select.FilterableDoubleListDemo.this, BINDING_DOUBLE_LIST_HIGHLIGHT_FILTER_TEXT));
                }
            }
        
            public void $pr$u3(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_DOUBLE_LIST_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (enableButton != null) {
                    $bindingSources.put("enableButton.getModel()", enableButton.getModel());
                    enableButton.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u4"));
                    enableButton.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(org.nuiton.jaxx.demo.component.jaxx.widgets.select.FilterableDoubleListDemo.this, BINDING_DOUBLE_LIST_ENABLED));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (enableButton != null) {
                    doubleList.setEnabled(enableButton.isSelected());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (enableButton != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("enableButton.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u4"));
                    }
                    enableButton.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(org.nuiton.jaxx.demo.component.jaxx.widgets.select.FilterableDoubleListDemo.this, BINDING_DOUBLE_LIST_ENABLED));
                }
            }
        
            public void $pr$u4(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_DOUBLE_LIST_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("selected", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    doubleList.setSelected(model.getSelected());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("selected", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_RESULT_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("selected", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(result, handler.updateResultText(model.getSelected()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("selected", this);
                }
            }
        });
    }

    @Override
    protected void $initialize_03_finalizeCreateComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_03_finalizeCreateComponents();
        // inline complete setup of $DemoPanel0
        add($Table0);
        // inline complete setup of $Table0
        $Table0.add(configurationPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(doubleList, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.5, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(result, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.5, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        addChildrenToConfigurationPanel();
    }

    @Override
    protected void $initialize_04_applyDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_04_applyDataBindings();
        
        // apply 7 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
    }

    @Override
    protected void $initialize_05_setProperties() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_05_setProperties();
        
        // apply 5 property setters
        doubleList.setBeanType(People.class);
        configurationPanel.setBorder(new TitledBorder(t("jaxxdemo.beandoublelistdemo.configuration")));
        doubleList.setBean(model);
    }

    @Override
    protected void $initialize_06_finalizeInitialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_06_finalizeInitialize();
    }

}
