package org.nuiton.jaxx.demo.component.swing;

/*-
 * #%L
 * JAXX :: Demo
 * %%
 * Copyright (C) 2008 - 2018 Code Lutin, Ultreia.io
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.awt.LayoutManager;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.jaxx.demo.DemoPanel;
import org.nuiton.jaxx.runtime.JAXXContext;
import org.nuiton.jaxx.runtime.JAXXObjectDescriptor;
import org.nuiton.jaxx.runtime.JAXXUtil;

public class JSplitPaneDemo extends DemoPanel {

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAJ1Ty27TQBS9MU3aNCmlBQorVNH0IQE2FcsgHmpVQWQoIpuKbDqxR4kjxx5mxsRsumDBjh9gwZYN6j9UrJDYsM0/IPUTuDNx7JY65eHFjHXvPWfOfX35CUXB4XbIO2YQeTIMzB6JY5NHgfT61Gw83tvbbfeoI7epcLjHZMhh9BUMMFpQcVO7kGC2bGSyRkyWYrISJmsr7LMwoMEJoroNs0K+9anoUiolbEwEO0JYzTSyHrOIJ2/lqs576/v7zWGBbn80AGKG8kuY9q1/IMiynrLB8FwJi3aPvCGWT4IOiuNe0MGE5pRtyydCPCd9+hoOYNqGEiMcySTc+a/yaDpNFTMJldo27YcvSED9uxLu/Z6Ci07TGbOZYoC6zEaT+Z5UGIVlTLOVJFRrmQfJlpT4+AxGBZdTzBxiHB76fgK6dhqUulR4NUXN1Bo2aWvJi6cA2qqC5vNf2FTGhXwy7buijqsM27k2qZ04PmY2PlknCy0o8gjNElYmT64avpcYNRq7lcljp57Rge8OD/jnwfFwPGsGilv+E+rEWmHjGQ8Z5dJT2uZHgxZJz7eeEVZvQVlQH3dS79z6+cqbSSSqRxULislUTOYTIrrIVpweHn1d2v9xAYwdmPVD4u4QFf8UyrLLsWKh78bs4SMtrjqYwfOSkilhynPCQMLF+y6RZLntBS429EGMNVo/v0appMPd42+fPqwejetUQIW1v0FmtSq+gpIX+F5A9VYmC5e7hRUmaOSG2Tbl7VdB3ZdZsiI39HnzbPbKXFPHahypa02rV38b2ncdGX4BtsaralwFAAA=";
    private static final Log log = LogFactory.getLog(JSplitPaneDemo.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JSplitPaneDemo $DemoPanel0;
    private JLabel $JLabel0;
    private JLabel $JLabel1;
    private JScrollPane $JScrollPane0;
    private JScrollPane $JScrollPane1;
    private JSplitPane $JSplitPane0;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public JSplitPaneDemo(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
    }

    public JSplitPaneDemo(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
    }

    public JSplitPaneDemo(LayoutManager param0) {
        super(param0);
    }

    public JSplitPaneDemo(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
    }

    public JSplitPaneDemo() {
        
    }

    public JSplitPaneDemo(JAXXContext param0) {
        super(param0);
    }

    public JSplitPaneDemo(boolean param0) {
        super(param0);
    }

    public JSplitPaneDemo(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected JScrollPane get$JScrollPane1() {
        return $JScrollPane1;
    }

    protected JSplitPane get$JSplitPane0() {
        return $JSplitPane0;
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    protected void $initialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $DemoPanel0 = this;
        super.$initialize();
    }

    @Override
    protected void $initialize_01_createComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_01_createComponents();
        $objectMap.put("$DemoPanel0", $DemoPanel0);
        // inline creation of $JSplitPane0
        $objectMap.put("$JSplitPane0", $JSplitPane0 = new JSplitPane());
        
        $JSplitPane0.setName("$JSplitPane0");
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        // inline creation of $JScrollPane1
        $objectMap.put("$JScrollPane1", $JScrollPane1 = new JScrollPane());
        
        $JScrollPane1.setName("$JScrollPane1");
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new JLabel());
        
        $JLabel1.setName("$JLabel1");
        // inline creation of $DemoPanel0
        setName("$DemoPanel0");
    }

    @Override
    protected void $initialize_02_registerDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_02_registerDataBindings();
        // register 0 data bindings
    }

    @Override
    protected void $initialize_03_finalizeCreateComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_03_finalizeCreateComponents();
        // inline complete setup of $DemoPanel0
        add($JSplitPane0);
        // inline complete setup of $JSplitPane0
        $JSplitPane0.add($JScrollPane0, JSplitPane.LEFT);
        $JSplitPane0.add($JScrollPane1, JSplitPane.RIGHT);
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add($JLabel0);
        // inline complete setup of $JScrollPane1
        $JScrollPane1.getViewport().add($JLabel1);
    }

    @Override
    protected void $initialize_04_applyDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_04_applyDataBindings();
    }

    @Override
    protected void $initialize_05_setProperties() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_05_setProperties();
        
        // apply 2 property setters
        $JLabel0.setIcon(new ImageIcon(getClass().getResource("/org/nuiton/jaxx/demo/images/Amethyst.jpg")));
        $JLabel1.setIcon(new ImageIcon(getClass().getResource("/org/nuiton/jaxx/demo/images/Lynx.jpg")));
    }

    @Override
    protected void $initialize_06_finalizeInitialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_06_finalizeInitialize();
    }

}
