package org.nuiton.jaxx.demo.component.jaxx.editor;

/*-
 * #%L
 * JAXX :: Demo
 * %%
 * Copyright (C) 2008 - 2017 Code Lutin, Ultreia.io
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.awt.BorderLayout;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.ButtonModel;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.jaxx.demo.DemoPanel;
import org.nuiton.jaxx.demo.entities.People;
import org.nuiton.jaxx.runtime.JAXXContext;
import org.nuiton.jaxx.runtime.JAXXObjectDescriptor;
import org.nuiton.jaxx.runtime.JAXXUtil;
import org.nuiton.jaxx.runtime.binding.DefaultJAXXBinding;
import org.nuiton.jaxx.runtime.swing.Table;
import org.nuiton.jaxx.widgets.select.BeanComboBox;
import static org.nuiton.i18n.I18n.t;

public class BeanComboBoxDemo extends DemoPanel {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_COMBO_BOX_AUTO_COMPLETE = "comboBox.autoComplete";
    public static final String BINDING_COMBO_BOX_SHOW_DECORATOR = "comboBox.showDecorator";
    public static final String BINDING_COMBO_BOX_SHOW_RESET = "comboBox.showReset";
    public static final String BINDING_SELECTED_RESULT_TEXT = "selectedResult.text";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVVTW/bRhBdKf6WEztJ00PRFq7t2HI+qOSWwEXr2kbQBGpj2D4E8SUrcSKtQ3HZ3WFEQ0gOPfTWP9BDr70U+Q9BTwV66dX/oUB+QmeXFPVF2kqiAyEMZ96+eTvz+Od/bFIrdkuqhuOHAqXvHPMoclToo2iB8+i7J08e146hjrug60oEKBWLf4UiKx6xkpvGNTLnqEpIlRipYpAqCVJlR7YC6YPfB7RZZXMaTzzQTQBEVs4trmtdOUgzN6MgVMlZmayzzvrnl7unBdj9rchYFBD9WWr75nsA9LqeqLKicJFdqR7zl7zicb9B5JTwG9TQRRPb8bjWP/IW/MRes+kqmwq4IjBktz9IHgtnoaIAWWl1F1pyj/vg3UG2OdyCSy+dehctjoFL75WzDdync2pyW0YGIwgs6hSy6dVDXvOA8FbyJNFtatCxaaZoNq29Upf+c9EIFUchfcuLgkaGKCl6ZIMmfb5XxUOUpmkPELZDpPOQXRuo2mlC/QVRNRULaeGCbsr2PmjAuMqEPxlMuWpSdqEuiZJUuWkz9UQLHB2EtnAbgNrR4NHsDyg32EdJgQ49TDu8PPj6UgwA7r5NGxamymtx2ecBjeNanvY0/k5v/HuTWDhikyqkMN1b/uaZ5dmnrHhtVvLXxhxjE39+81r90X532t2VEpFbOq+qzxZocAMlA1AoDLeFeFFCFF7lBx5sHtHyWVmsZ6yfzfwgyST2xOKyQXIMkvM9101Cm5w+ffvXp8/+vcCKD9icJ7n7gJv8h2wWm3Q5Tem5UfDtliU3356h56KhiWyqJpVLHNlWx4f20qFAD9xtGytjedkwsctUo8u3o1KTUbJdfQO/vLHxKiJd18/WNW3jzeN3f//+6/W3XW0L1NXqOJU9fSefsinhe8IH60SJyWQ6TynQELqy5yBZnsIylzhI7GHNPm+MKFhENoEQ0Uyv5UvVv+W0cd1tMKUqhCg00I5Vwfy7wzKNYXwmK/lMUtsYj8awzYzPYf1sDqkvjccjy8vO4zKBbH5Q+K86o6o6Qh8k55c3XiGbE3fv+XsKngsyxMW0CWqgRcnILg6xX+5kUBsGne2T/cvOkKaDyVndpxZ9Xsv963z/Pdc5dvB4j0cp9Bv8GCySIdjqNLnveqAc+owcDHwDyuU9kHQPG0vd5vpzHiK0yjlUhj4m42ji8RNJWrNLX7sc+VJN+C59eL4ZQS+Y59y5iCb8wjy8bITFMTjNmAs4PAngDJzPPprJF4TwP6hSQ1LdCgAA";
    private static final Log log = LogFactory.getLog(BeanComboBoxDemo.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JCheckBox autoCompleteButton;
    protected BeanComboBox<People> comboBox;
    protected JPanel configurationPanel;
    protected BeanComboBoxDemoHandler handler;
    protected JPanel resultPanel;
    protected JLabel selectedResult;
    protected JCheckBox showDecoratorButton;
    protected JCheckBox showResetButton;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private BeanComboBoxDemo $DemoPanel0;
    private Table $Table0;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public BeanComboBoxDemo(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
    }

    public BeanComboBoxDemo(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
    }

    public BeanComboBoxDemo(LayoutManager param0) {
        super(param0);
    }

    public BeanComboBoxDemo(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
    }

    public BeanComboBoxDemo() {
        
    }

    public BeanComboBoxDemo(JAXXContext param0) {
        super(param0);
    }

    public BeanComboBoxDemo(boolean param0) {
        super(param0);
    }

    public BeanComboBoxDemo(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JCheckBox getAutoCompleteButton() {
        return autoCompleteButton;
    }

    public BeanComboBox<People> getComboBox() {
        return comboBox;
    }

    public JPanel getConfigurationPanel() {
        return configurationPanel;
    }

    public BeanComboBoxDemoHandler getHandler() {
        return handler;
    }

    public JPanel getResultPanel() {
        return resultPanel;
    }

    public JLabel getSelectedResult() {
        return selectedResult;
    }

    public JCheckBox getShowDecoratorButton() {
        return showDecoratorButton;
    }

    public JCheckBox getShowResetButton() {
        return showResetButton;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected Table get$Table0() {
        return $Table0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToConfigurationPanel() {
        configurationPanel.add(autoCompleteButton);
        configurationPanel.add(showResetButton);
        configurationPanel.add(showDecoratorButton);
    }

    protected void addChildrenToResultPanel() {
        resultPanel.add(selectedResult, BorderLayout.CENTER);
    }

    protected void createAutoCompleteButton() {
        $objectMap.put("autoCompleteButton", autoCompleteButton = new JCheckBox());
        
        autoCompleteButton.setName("autoCompleteButton");
        autoCompleteButton.setText(t("jaxxdemo.beancomboboxdemo.autoComplete"));
        autoCompleteButton.setSelected(true);
    }

    protected void createComboBox() {
        $objectMap.put("comboBox", comboBox = new BeanComboBox<People>(this));
        
        comboBox.setName("comboBox");
        comboBox.setI18nPrefix("jaxxdemo.common.");
    }

    protected void createConfigurationPanel() {
        $objectMap.put("configurationPanel", configurationPanel = new JPanel());
        
        configurationPanel.setName("configurationPanel");
        configurationPanel.setLayout(new GridLayout(0,1));
    }

    protected void createResultPanel() {
        $objectMap.put("resultPanel", resultPanel = new JPanel());
        
        resultPanel.setName("resultPanel");
        resultPanel.setLayout(new BorderLayout());
    }

    protected void createSelectedResult() {
        $objectMap.put("selectedResult", selectedResult = new JLabel());
        
        selectedResult.setName("selectedResult");
    }

    protected void createShowDecoratorButton() {
        $objectMap.put("showDecoratorButton", showDecoratorButton = new JCheckBox());
        
        showDecoratorButton.setName("showDecoratorButton");
        showDecoratorButton.setText(t("jaxxdemo.beancomboboxdemo.showDecorator"));
        showDecoratorButton.setSelected(true);
    }

    protected void createShowResetButton() {
        $objectMap.put("showResetButton", showResetButton = new JCheckBox());
        
        showResetButton.setName("showResetButton");
        showResetButton.setText(t("jaxxdemo.beancomboboxdemo.showReset"));
        showResetButton.setSelected(true);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    protected void $initialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $DemoPanel0 = this;
        handler = new BeanComboBoxDemoHandler();
        handler.beforeInit(this);
        super.$initialize();
        handler.afterInit(this);
    }

    @Override
    protected void $initialize_01_createComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_01_createComponents();
        $objectMap.put("$DemoPanel0", $DemoPanel0);
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        createConfigurationPanel();
        createAutoCompleteButton();
        createShowResetButton();
        createShowDecoratorButton();
        createComboBox();
        createResultPanel();
        createSelectedResult();
        // inline creation of $DemoPanel0
        setName("$DemoPanel0");
        setLayout(new BorderLayout());
    }

    @Override
    protected void $initialize_02_registerDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_02_registerDataBindings();
        // register 4 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_COMBO_BOX_AUTO_COMPLETE, true) {
        
            @Override
            public void applyDataBinding() {
                if (autoCompleteButton != null) {
                    $bindingSources.put("autoCompleteButton.getModel()", autoCompleteButton.getModel());
                    autoCompleteButton.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u0"));
                    autoCompleteButton.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(org.nuiton.jaxx.demo.component.jaxx.editor.BeanComboBoxDemo.this, BINDING_COMBO_BOX_AUTO_COMPLETE));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (autoCompleteButton != null) {
                    comboBox.setAutoComplete(autoCompleteButton.isSelected());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (autoCompleteButton != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("autoCompleteButton.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u0"));
                    }
                    autoCompleteButton.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(org.nuiton.jaxx.demo.component.jaxx.editor.BeanComboBoxDemo.this, BINDING_COMBO_BOX_AUTO_COMPLETE));
                }
            }
        
            public void $pr$u0(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_COMBO_BOX_SHOW_DECORATOR, true) {
        
            @Override
            public void applyDataBinding() {
                if (showDecoratorButton != null) {
                    $bindingSources.put("showDecoratorButton.getModel()", showDecoratorButton.getModel());
                    showDecoratorButton.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u1"));
                    showDecoratorButton.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(org.nuiton.jaxx.demo.component.jaxx.editor.BeanComboBoxDemo.this, BINDING_COMBO_BOX_SHOW_DECORATOR));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (showDecoratorButton != null) {
                    comboBox.setShowDecorator(showDecoratorButton.isSelected());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (showDecoratorButton != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("showDecoratorButton.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u1"));
                    }
                    showDecoratorButton.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(org.nuiton.jaxx.demo.component.jaxx.editor.BeanComboBoxDemo.this, BINDING_COMBO_BOX_SHOW_DECORATOR));
                }
            }
        
            public void $pr$u1(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_COMBO_BOX_SHOW_RESET, true) {
        
            @Override
            public void applyDataBinding() {
                if (showResetButton != null) {
                    $bindingSources.put("showResetButton.getModel()", showResetButton.getModel());
                    showResetButton.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u2"));
                    showResetButton.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(org.nuiton.jaxx.demo.component.jaxx.editor.BeanComboBoxDemo.this, BINDING_COMBO_BOX_SHOW_RESET));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (showResetButton != null) {
                    comboBox.setShowReset(showResetButton.isSelected());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (showResetButton != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("showResetButton.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u2"));
                    }
                    showResetButton.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(org.nuiton.jaxx.demo.component.jaxx.editor.BeanComboBoxDemo.this, BINDING_COMBO_BOX_SHOW_RESET));
                }
            }
        
            public void $pr$u2(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SELECTED_RESULT_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (comboBox != null) {
                    comboBox.addPropertyChangeListener("selectedItem", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (comboBox != null && handler != null) {
                    selectedResult.setText(handler.getSelectedResult((People) comboBox.getSelectedItem()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (comboBox != null) {
                    comboBox.removePropertyChangeListener("selectedItem", this);
                }
            }
        });
    }

    @Override
    protected void $initialize_03_finalizeCreateComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_03_finalizeCreateComponents();
        // inline complete setup of $DemoPanel0
        add($Table0, BorderLayout.NORTH);
        // inline complete setup of $Table0
        $Table0.add(configurationPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        $Table0.add(comboBox, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        $Table0.add(resultPanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        addChildrenToConfigurationPanel();
        addChildrenToResultPanel();
    }

    @Override
    protected void $initialize_04_applyDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_04_applyDataBindings();
        
        // apply 4 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
    }

    @Override
    protected void $initialize_05_setProperties() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_05_setProperties();
        
        // apply 6 property setters
        comboBox.setBeanType(People.class);
        configurationPanel.setBorder(new TitledBorder(t("jaxxdemo.beancomboboxdemo.configuration")));
        resultPanel.setBorder(new TitledBorder(t("jaxxdemo.beancomboboxdemo.result")));
    }

    @Override
    protected void $initialize_06_finalizeInitialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_06_finalizeInitialize();
    }

}
