package org.nuiton.jaxx.demo.component.jaxx;

/*-
 * #%L
 * JAXX :: Demo
 * %%
 * Copyright (C) 2008 - 2017 Code Lutin, Ultreia.io
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.ButtonModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.jaxx.demo.DemoPanel;
import org.nuiton.jaxx.runtime.JAXXContext;
import org.nuiton.jaxx.runtime.JAXXObjectDescriptor;
import org.nuiton.jaxx.runtime.JAXXUtil;
import org.nuiton.jaxx.runtime.binding.DefaultJAXXBinding;
import org.nuiton.jaxx.runtime.swing.BlockingLayerUI;
import org.nuiton.jaxx.runtime.swing.BlockingLayerUI2;
import org.nuiton.jaxx.runtime.swing.SwingUtil;
import org.nuiton.jaxx.runtime.swing.Table;
import static org.nuiton.i18n.I18n.t;

public class BoxedDecoratorDemo extends DemoPanel {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_TOGGLE_TEXT = "toggle.text";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVWy27bRhQdKZEty3abB/LYFCBstVFQh3RctBunTS0JaWwoTVEnQFAv2hF5I9MecdiZYcXASFAESHf9gS667abIPwRdFegmW/9DgXxC7wypV0LKciVIhDj3zLln7ov8819SkoKscdGxg8hXPLAPaBzbIgqU3wV7Z+vRo/vtA3BVE6Qr/FBxQZJPoUiKe2TRG6xLRey9FjI5CZOjmZyUyWnwbsgDCEaINlukItUTBnIfQClSy93sSunsDpCbcRiJ1Fem6ixf//xy87gAzd+KhMQhyl/CY398CoLhqc+2SNH3FLnQOqA/UYfRoIPihB908EDLeq3BqJRf0y78SJ6R+RaZC6lAMkVu/K/wGDpDFYeKLFab0OXf0ADYuiKfvX0ED42222dL1uo8Bq8JLhcUefX2MDSEc4rMM/oExMNtFJcXDdnDs9l1xt1D/NNK8EOGcsqwgfk/FcXGiIrqA9pmgAdanUxhYHrTwmDvnOKdDgNFLunYxylwp7EP7iGeXKMuDMCVdqSQWocPMzi2wYR0HD2foLcUuTgGrZtlDbr6Nraubz/INDXyTc0M03J1Z9cVnDEtDCNzZUzC0DQuudwFKWkHsBvPj21o+VJpTDXEyv8oL8rYafaw04ZFX9gjJRExTbua3+S6T79FVNKhq/kdqt0Y4POXz8QfvTfH/bZcRnHWSbtGJhD2SCh4CEL5Wtv7SU9GymfOPRpu7pEFCQzHlxlP1yYr302RqB5VmOjZmsm+S+U+spXmj1/9dfmH12dI8Q6pME69O1Tjt8mC2hcYMc68OLz9pRG31Cvj9Rz+zmKWIwnbLg8U3ogI41qhrguhStbWj3Z1ih5qV64AqmC7ixnUxtoKevB5cCPB22HQWbn+FGujnbZSgzMusPSPAuhZ5qb26fqa+WrcgsElbpwp3Bh46iXGFF6bnMJBxF7ef/P3779++KqfxgIGsDrNzmEqS9+ROT9gfgBmvqajM3OeLoYSIo8P52LWpCTD2Ramg8Yx10/eyVBx9oTMFmgt63MTNv3vNhkZqidpL+AARCzHMZJWwVfC91pmpba+tpFNPzIGpwjO0vcu891D8B5AjG6uHq0k260tq0ellRpXnuryNohy357luz9UZ3FcP8FxfYLj+iyOGzmOLw3stccRY5bJ7/UJKhqzqGjmqLgysI+osDYm6WhOUWClLveAaQG6vprwmEZM6efJPb1ey6ng/oPoNBX83i2PKmq1/cDDDvriHd6CvlamYFxK+nPLdJtG/ZzNtXwil15+MYHh3BRqyslDCPRb461kyFlU4Tsj5gByTnl5Cl6T9gnaNMd/nvoNWOMLAAA=";
    private static final Log log = LogFactory.getLog(BoxedDecoratorDemo.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JButton buttonA;
    protected JButton buttonB;
    protected JButton buttonC;
    protected JButton buttonD;
    protected JPanel buttonPane;
    protected BlockingLayerUI layerUI;
    protected BlockingLayerUI2 layerUI2;
    protected JList messages;
    protected JCheckBox toggle;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private BoxedDecoratorDemo $DemoPanel0;
    private JScrollPane $JScrollPane0;
    private Table $Table0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    void $afterCompleteSetup() {
        for (JComponent boxed : SwingUtil.getLayeredComponents(this)) {
            if (boxed == buttonD) {
                SwingUtil.setLayerUI(boxed, layerUI2);
                continue;
            }
    
            BlockingLayerUI ui = null;
            try {
                ui = layerUI.clone();
            } catch (CloneNotSupportedException e) {
                throw new RuntimeException(e);
            }
            if (boxed == buttonC) {
                ui.setBlock(true);
            }
            SwingUtil.setLayerUI(boxed, ui);
        }
    }
    
    public void setLayer(boolean active) {
        for (JComponent boxed : SwingUtil.getLayeredComponents(this)) {
            if (boxed == buttonD) {
                continue;
            }
            BlockingLayerUI ui = (BlockingLayerUI) SwingUtil.getLayer(boxed).getUI();
            if (boxed == buttonC) {
                ui.setBlock(active);
            } 
            ui.setUseIcon(active);
        }
    }
    
    protected void accept(ActionEvent e, String suffix) {
        JButton source = (JButton) e.getSource();
        String clickedMessage = (String) source.getClientProperty("clickedText");
        String msg = "'" + source.getText() + "' clicked - " + suffix + " : " + clickedMessage;
        ((DefaultListModel)messages.getModel()).addElement(msg);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public BoxedDecoratorDemo(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
    }

    public BoxedDecoratorDemo(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
    }

    public BoxedDecoratorDemo(LayoutManager param0) {
        super(param0);
    }

    public BoxedDecoratorDemo(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
    }

    public BoxedDecoratorDemo() {
        
    }

    public BoxedDecoratorDemo(JAXXContext param0) {
        super(param0);
    }

    public BoxedDecoratorDemo(boolean param0) {
        super(param0);
    }

    public BoxedDecoratorDemo(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__buttonA(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        accept(event, "from button (no layer)");
    }

    public void doActionPerformed__on__buttonB(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        accept(event, "from button (no layer)");
    }

    public void doActionPerformed__on__buttonC(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        accept(event, "from button (no layer)");
    }

    public void doActionPerformed__on__buttonD(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        accept(event, "from button (no layer)");
    }

    public void doActionPerformed__on__toggle(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        setLayer(toggle.isSelected());
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JButton getButtonA() {
        return buttonA;
    }

    public JButton getButtonB() {
        return buttonB;
    }

    public JButton getButtonC() {
        return buttonC;
    }

    public JButton getButtonD() {
        return buttonD;
    }

    public JPanel getButtonPane() {
        return buttonPane;
    }

    public BlockingLayerUI getLayerUI() {
        return layerUI;
    }

    public BlockingLayerUI2 getLayerUI2() {
        return layerUI2;
    }

    public JList getMessages() {
        return messages;
    }

    public JCheckBox getToggle() {
        return toggle;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected Table get$Table0() {
        return $Table0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToButtonPane() {
        buttonPane.add(SwingUtil.boxComponentWithJxLayer(buttonA));
        buttonPane.add(SwingUtil.boxComponentWithJxLayer(buttonB));
        buttonPane.add(SwingUtil.boxComponentWithJxLayer(buttonC));
        buttonPane.add(SwingUtil.boxComponentWithJxLayer(buttonD));
    }

    protected void createButtonA() {
        $objectMap.put("buttonA", buttonA = new JButton());
        
        buttonA.setName("buttonA");
        buttonA.setText(t("button A"));
        buttonA.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__buttonA"));
        buttonA.putClientProperty("clickedText", "button A was clicked");
    }

    protected void createButtonB() {
        $objectMap.put("buttonB", buttonB = new JButton());
        
        buttonB.setName("buttonB");
        buttonB.setText(t("button B"));
        buttonB.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__buttonB"));
        buttonB.putClientProperty("clickedText", "button B was clicked");
    }

    protected void createButtonC() {
        $objectMap.put("buttonC", buttonC = new JButton());
        
        buttonC.setName("buttonC");
        buttonC.setText("button C (full block)");
        buttonC.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__buttonC"));
        buttonC.putClientProperty("clickedText", "button C was clicked");
    }

    protected void createButtonD() {
        $objectMap.put("buttonD", buttonD = new JButton());
        
        buttonD.setName("buttonD");
        buttonD.setText("button D (full block 2)");
        buttonD.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__buttonD"));
        buttonD.putClientProperty("clickedText", "button D was clicked");
    }

    protected void createButtonPane() {
        $objectMap.put("buttonPane", buttonPane = new JPanel());
        
        buttonPane.setName("buttonPane");
        buttonPane.setLayout(new GridLayout(0,2));
    }

    protected void createLayerUI() {
        $objectMap.put("layerUI", layerUI = new BlockingLayerUI());
        
        layerUI.setUseIcon(true);
    }

    protected void createLayerUI2() {
        $objectMap.put("layerUI2", layerUI2 = new BlockingLayerUI2());
    }

    protected void createMessages() {
        $objectMap.put("messages", messages = new JList());
        
        messages.setName("messages");
    }

    protected void createToggle() {
        $objectMap.put("toggle", toggle = new JCheckBox());
        
        toggle.setName("toggle");
        toggle.setSelected(true);
        toggle.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__toggle"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    protected void $initialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $DemoPanel0 = this;
        super.$initialize();
    }

    @Override
    protected void $initialize_01_createComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_01_createComponents();
        $objectMap.put("$DemoPanel0", $DemoPanel0);
        createLayerUI();
        createLayerUI2();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        createToggle();
        createButtonPane();
        createButtonA();
        createButtonB();
        createButtonC();
        createButtonD();
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createMessages();
        // inline creation of $DemoPanel0
        setName("$DemoPanel0");
        setLayout(new BorderLayout());
    }

    @Override
    protected void $initialize_02_registerDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_02_registerDataBindings();
        // register 1 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_TOGGLE_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (toggle != null) {
                    $bindingSources.put("toggle.getModel()", toggle.getModel());
                    toggle.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u0"));
                    toggle.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(org.nuiton.jaxx.demo.component.jaxx.BoxedDecoratorDemo.this, BINDING_TOGGLE_TEXT));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (toggle != null) {
                    toggle.setText(toggle.isSelected() ? "Active layer" : "No layer");
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (toggle != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("toggle.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u0"));
                    }
                    toggle.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(org.nuiton.jaxx.demo.component.jaxx.BoxedDecoratorDemo.this, BINDING_TOGGLE_TEXT));
                }
            }
        
            public void $pr$u0(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
    }

    @Override
    protected void $initialize_03_finalizeCreateComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_03_finalizeCreateComponents();
        // inline complete setup of $DemoPanel0
        add($Table0, BorderLayout.CENTER);
        // inline complete setup of $Table0
        $Table0.add(toggle, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(buttonPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.5, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JScrollPane0, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.5, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        addChildrenToButtonPane();
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(messages);
    }

    @Override
    protected void $initialize_04_applyDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_04_applyDataBindings();
        
        // apply 1 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
    }

    @Override
    protected void $initialize_05_setProperties() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_05_setProperties();
        
        // apply 10 property setters
        layerUI.setAcceptAction(new AbstractAction() {                      private static final long serialVersionUID = 1L;                      @Override                      public void actionPerformed(ActionEvent e) {                         accept(e, "from icon of layer");                      }                      });
        layerUI2.setAcceptAction(new AbstractAction() {                      private static final long serialVersionUID = 1L;                      @Override                      public void actionPerformed(ActionEvent e) {                         accept(e, "from icon of layer");                      }                      });
        layerUI.setAcceptIcon(SwingUtil.createImageIcon("action-accept.png"));
        layerUI.setBlockingColor(new Color(50,50,50));
        layerUI.setBlockIcon(SwingUtil.createImageIcon("action-block.png"));
        layerUI2.setAcceptIcon(SwingUtil.createImageIcon("action-accept.png"));
        layerUI2.setBlockIcon(SwingUtil.createImageIcon("action-block.png"));
        messages.setModel(new DefaultListModel());
    }

    @Override
    protected void $initialize_06_finalizeInitialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_06_finalizeInitialize();
    }

}
