package org.nuiton.jaxx.demo.feature.nav.content;

/*-
 * #%L
 * JAXX :: Demo
 * %%
 * Copyright (C) 2008 - 2017 Ultreia.io
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.awt.BorderLayout;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.jaxx.demo.entities.People;
import org.nuiton.jaxx.runtime.JAXXContext;
import org.nuiton.jaxx.runtime.JAXXObjectDescriptor;
import org.nuiton.jaxx.runtime.JAXXUtil;
import org.nuiton.jaxx.runtime.binding.DefaultJAXXBinding;
import org.nuiton.jaxx.runtime.binding.SimpleJAXXObjectBinding;
import org.nuiton.jaxx.runtime.swing.renderer.DecoratorProviderListCellRenderer;
import org.nuiton.jaxx.widgets.select.BeanListHeader;
import static org.nuiton.i18n.I18n.t;

public class ActorsContentUI extends AbstractContentUI<List<People>> {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_DATA = "data";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_LIST_HEADER_DATA = "listHeader.data";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JBUTTON0_ENABLED = "$JButton0.enabled";
    private static final String BINDING_$JBUTTON2_ENABLED = "$JButton2.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAK1VS2/TQBDehL7SB/SBeAgERQ0PCXAoIIRUVOhDqEQBqrYgRC9s7G271WbX7I4blwMHDtz4Axy4ckH8B8QJiQvX/gckfgKzdohpSVxDyMF2Zr/59pvZmdkP30m30eSS0uuODDgo6WzSMHR0IIHXmFOeefLkYXWTuTDPjKu5D0qT+JfLk/wqGfCadgPEWa0gUylmKlmmUoOpNKdqvpJM/kY0VSH9BrYFMxuMAZALbZ1dY0rLTeRU6Ae6sVdL1a32+vp6cifH5t/mCQl9lD+AYV/8C4Ik6q4KyXMPyGhlk27RkqByHcVpLtcxoCFrmxPUmAe0xp6Tl6S3Qnp8qpEMyOV/Sk9EF1GFPpCx4kzVgKYuzCkJ6PHo3hUgN/eG4rGactYYhUAzR9Itx43Rzoxrz6rp6/sRdQ+QLo8CBXLQRuAEwIVT4QaS9b5ieZFKJnC3UYsJHVPHoJ3YakGFJnaoWF52tRLCrqHD0V0OyZKFH0oUCNwQyMgusBVh10ebsF5QSlSpBnJ4F3IFzbNU/6l40v4fsY9jzbVCsTwbAKYL1Y3toonNFnbiT3REdbrN4tUWi/02pgVGPYZ6L+89pTr31hkYxzCBPebMMiorTXxDsCbn2tUp9oWT9EVSorlV0q0DNAOZaN+StquWEBX300T7frLbRMBXH1/q9/UfO7+aaAzFje/n9du8wIr2tfIxFdxqOxR3kK210n3qT62SQpyIaJicT1e+3ECielQxklTtAjUbyNbdu/Pp85Fn3w6Q/F08BUW9u9Ti75ECbGjMmBJe6N++E4kbrPfhc9jKBNIj6LbCAyUHb9mWGK9y6WFlTIeYpfPpWWqK+vjwx5d3b85++pWpHGosZvFMstX9lPRwKbhk0cBpzJKWA2bANyzwVDIoWo2OnH0P+432uBQ9r7SMv6p0o/yuhYF9XY8isF83IpaxDCzDrhJBTcal/Jizeod8xzeU5i9wbFERzw9s9UUluLvdIfHRLVuP7v+mHXSZEEtMYvSpuTySgauwhvULtCqwyUdvxUUxTgEvnWoAbLo18fF9ia35aoq0zhlOZgiul0kbmZdCcyoDTRewMLooVv6Vw5rXUhjOZGKgKXFMdKxhf4bGRZ6i4mwGjn4+eVMuarbGwxQ1WZiiS71DNQWc1vUlZljaAWch6qviDbuy7bN9BP0EcrzdKBgLAAA=";
    private static final Log log = LogFactory.getLog(ActorsContentUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<People> data;
    protected JList list;
    protected BeanListHeader<People> listHeader;
    protected JToolBar toolbar;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private ActorsContentUI $AbstractContentUI0;
    private JButton $JButton0;
    private JButton $JButton1;
    private JButton $JButton2;
    private JPanel $JPanel0;
    private JPanel $JPanel1;
    private JScrollPane $JScrollPane0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    private void $afterCompleteSetup() {
        getHandler().initUI(this);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public ActorsContentUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
    }

    public ActorsContentUI(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
    }

    public ActorsContentUI(LayoutManager param0) {
        super(param0);
    }

    public ActorsContentUI(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
    }

    public ActorsContentUI() {
        
    }

    public ActorsContentUI(JAXXContext param0) {
        super(param0);
    }

    public ActorsContentUI(boolean param0) {
        super(param0);
    }

    public ActorsContentUI(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__$JButton0(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().selectChild(this, (People) list.getSelectedValue());
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public List<People> getData() {
        return data;
    }

    public JList getList() {
        return list;
    }

    public BeanListHeader<People> getListHeader() {
        return listHeader;
    }

    public JToolBar getToolbar() {
        return toolbar;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setData(List<People> data) {
        List<People> oldValue = this.data;
        this.data = data;
        firePropertyChange(PROPERTY_DATA, oldValue, data);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JButton get$JButton0() {
        return $JButton0;
    }

    protected JButton get$JButton1() {
        return $JButton1;
    }

    protected JButton get$JButton2() {
        return $JButton2;
    }

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected JPanel get$JPanel1() {
        return $JPanel1;
    }

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToToolbar() {
        toolbar.add($JPanel1, BorderLayout.CENTER);
        toolbar.add(listHeader, BorderLayout.EAST);
    }

    protected void createData() {
        $objectMap.put("data", data = null);
    }

    protected void createList() {
        $objectMap.put("list", list = new JList());
        
        list.setName("list");
    }

    protected void createListHeader() {
        $objectMap.put("listHeader", listHeader = new BeanListHeader<People>());
        
        listHeader.setName("listHeader");
        listHeader.setI18nPrefix("jaxxdemo.common.");
        listHeader.setShowReset(true);
    }

    protected void createToolbar() {
        $objectMap.put("toolbar", toolbar = new JToolBar());
        
        toolbar.setName("toolbar");
        toolbar.setFloatable(false);
        toolbar.setLayout(new BorderLayout());
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    protected void $initialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $AbstractContentUI0 = this;
        super.$initialize();
    }

    @Override
    protected void $initialize_01_createComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_01_createComponents();
        $objectMap.put("$AbstractContentUI0", $AbstractContentUI0);
        createData();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new BorderLayout());
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createList();
        createToolbar();
        // inline creation of $JPanel1
        $objectMap.put("$JPanel1", $JPanel1 = new JPanel());
        
        $JPanel1.setName("$JPanel1");
        $JPanel1.setLayout(new GridLayout(1,0));
        // inline creation of $JButton0
        $objectMap.put("$JButton0", $JButton0 = new JButton());
        
        $JButton0.setName("$JButton0");
        $JButton0.setText(t("jaxxdemo.action.show"));
        $JButton0.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton0"));
        // inline creation of $JButton1
        $objectMap.put("$JButton1", $JButton1 = new JButton());
        
        $JButton1.setName("$JButton1");
        $JButton1.setText(t("jaxxdemo.action.add"));
        // inline creation of $JButton2
        $objectMap.put("$JButton2", $JButton2 = new JButton());
        
        $JButton2.setName("$JButton2");
        $JButton2.setText(t("jaxxdemo.action.remove"));
        createListHeader();
        // inline creation of $AbstractContentUI0
        setName("$AbstractContentUI0");
    }

    @Override
    protected void $initialize_02_registerDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_02_registerDataBindings();
        // register 3 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_$JBUTTON0_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (list != null) {
                    $bindingSources.put("list.getSelectionModel()", list.getSelectionModel());
                    list.getSelectionModel().addListSelectionListener( JAXXUtil.getEventListener(ListSelectionListener.class, this, "$pr$u0"));
                    list.addPropertyChangeListener("selectionModel", JAXXUtil.getDataBindingUpdateListener(org.nuiton.jaxx.demo.feature.nav.content.ActorsContentUI.this, BINDING_$JBUTTON0_ENABLED));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (list != null) {
                    $JButton0.setEnabled(list.getSelectedIndex()!=-1);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (list != null) {
                    ListSelectionModel $target = (ListSelectionModel) $bindingSources.remove("list.getSelectionModel()");
                    if ($target != null) {
                        $target.removeListSelectionListener( JAXXUtil.getEventListener(ListSelectionListener.class, this, "$pr$u0"));
                    }
                    list.removePropertyChangeListener("selectionModel", JAXXUtil.getDataBindingUpdateListener(org.nuiton.jaxx.demo.feature.nav.content.ActorsContentUI.this, BINDING_$JBUTTON0_ENABLED));
                }
            }
        
            public void $pr$u0(ListSelectionEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_$JBUTTON2_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (list != null) {
                    $bindingSources.put("list.getSelectionModel()", list.getSelectionModel());
                    list.getSelectionModel().addListSelectionListener( JAXXUtil.getEventListener(ListSelectionListener.class, this, "$pr$u1"));
                    list.addPropertyChangeListener("selectionModel", JAXXUtil.getDataBindingUpdateListener(org.nuiton.jaxx.demo.feature.nav.content.ActorsContentUI.this, BINDING_$JBUTTON2_ENABLED));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (list != null) {
                    $JButton2.setEnabled(list.getSelectedIndex()!=-1);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (list != null) {
                    ListSelectionModel $target = (ListSelectionModel) $bindingSources.remove("list.getSelectionModel()");
                    if ($target != null) {
                        $target.removeListSelectionListener( JAXXUtil.getEventListener(ListSelectionListener.class, this, "$pr$u1"));
                    }
                    list.removePropertyChangeListener("selectionModel", JAXXUtil.getDataBindingUpdateListener(org.nuiton.jaxx.demo.feature.nav.content.ActorsContentUI.this, BINDING_$JBUTTON2_ENABLED));
                }
            }
        
            public void $pr$u1(ListSelectionEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_LIST_HEADER_DATA, true ,"data") {
        
            @Override
            public void processDataBinding() {
                listHeader.setData(getData());
            }
        });
    }

    @Override
    protected void $initialize_03_finalizeCreateComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_03_finalizeCreateComponents();
        // inline complete setup of $AbstractContentUI0
        add($JPanel0);
        // inline complete setup of $JPanel0
        $JPanel0.add($JScrollPane0, BorderLayout.CENTER);
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(list);
        addChildrenToToolbar();
        // inline complete setup of $JPanel1
        $JPanel1.add($JButton0);
        $JPanel1.add($JButton1);
        $JPanel1.add($JButton2);
    }

    @Override
    protected void $initialize_04_applyDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_04_applyDataBindings();
        
        // apply 3 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
    }

    @Override
    protected void $initialize_05_setProperties() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_05_setProperties();
        
        // apply 10 property setters
        $JScrollPane0.setBorder(new TitledBorder(t("jaxxdemo.navigation.actors.title")));
        $JScrollPane0.setColumnHeaderView(toolbar);
        $JScrollPane0.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);
        $JScrollPane0.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED);
        list.setCellRenderer(getContextValue(DecoratorProviderListCellRenderer.class));
        listHeader.setList(list);
        listHeader.setBeanType(People.class);
    }

    @Override
    protected void $initialize_06_finalizeInitialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_06_finalizeInitialize();
    }

}
