package org.nuiton.jaxx.demo.feature.databinding;

/*-
 * #%L
 * JAXX :: Demo
 * %%
 * Copyright (C) 2008 - 2017 Ultreia.io
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.awt.LayoutManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.jaxx.demo.DemoPanel;
import org.nuiton.jaxx.runtime.JAXXContext;
import org.nuiton.jaxx.runtime.JAXXObjectDescriptor;
import org.nuiton.jaxx.runtime.JAXXUtil;

public class BaseBeanDataBinding extends DemoPanel {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_CONTENT_MESSAGE = "contentMessage";
    public static final String PROPERTY_EDITING = "editing";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAJ2SPU7DQBCFJ1YSEBERcIUghASsgTY0JK6Q+RE0kVJt7ME4cnbN7hhMk4KCQ3ABGsRJOEHugMQRWNshRigpwJ3fvv1m3uy8fkBNK9iVKmAiCUkKNuRpylQiKBwhOznu9c4HQ/TIQe2pMCapoPgqFlh9aPgzXROwvmtIdkGyM5I9JdldOYqlQPED1HZhRdNDhPoGkQi2F172tLavZs52GidqWmtu1/NqvT8dTCroPFsAaWzar5rYO38AlKmrLlihT7DhDvkdtyMuAtOcCkVgAq1mWjfiWp/xEd7CGJZcqMdcGRjB3r/Gk+NyVBoTNDYdHMkLLjDaJzj6HcE3h+waOSUKmc+JD0Lhm95Yh2vsIBeO0TqFFsc5tk6whH5IRiFYzwKwLBTrSBmZC6Vreeo6zP6bpd70pCDT+ylqzQMkWCshxWSMV8HWonGb52Xl85aTrvShphIjE7QWb1a2HJfGVaxFa/FaZGVy4+PbWL3cf06+dwG+AKo7oqsHAwAA";
    private static final Log log = LogFactory.getLog(BaseBeanDataBinding.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected String contentMessage;
    protected Boolean editing;
    protected Boolean editing2;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private BaseBeanDataBinding $DemoPanel0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    void $afterCompleteSetup(){
        }
    
        public Boolean isEditing2() {
        return editing2;
        }
    
        public void setEditing2(Boolean editing2) {
        Boolean oldValue = this.editing2;
        this.editing2 = editing2;
        firePropertyChange("editing2", oldValue, editing2);
        }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public BaseBeanDataBinding(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
    }

    public BaseBeanDataBinding(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
    }

    public BaseBeanDataBinding(LayoutManager param0) {
        super(param0);
    }

    public BaseBeanDataBinding(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
    }

    public BaseBeanDataBinding() {
        
    }

    public BaseBeanDataBinding(JAXXContext param0) {
        super(param0);
    }

    public BaseBeanDataBinding(boolean param0) {
        super(param0);
    }

    public BaseBeanDataBinding(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public String getContentMessage() {
        return contentMessage;
    }

    public Boolean getEditing() {
        return editing;
    }

    public Boolean getEditing2() {
        return editing2;
    }

    public Boolean isEditing() {
        return editing !=null && editing;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setContentMessage(String contentMessage) {
        String oldValue = this.contentMessage;
        this.contentMessage = contentMessage;
        firePropertyChange(PROPERTY_CONTENT_MESSAGE, oldValue, contentMessage);
    }

    public void setEditing(Boolean editing) {
        Boolean oldValue = this.editing;
        this.editing = editing;
        firePropertyChange(PROPERTY_EDITING, oldValue, editing);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void createContentMessage() {
        $objectMap.put("contentMessage", contentMessage = "message...");
    }

    protected void createEditing() {
        $objectMap.put("editing", editing = false);
    }

    protected void createEditing2() {
        $objectMap.put("editing2", editing2 = new Boolean(false));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    protected void $initialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $DemoPanel0 = this;
        super.$initialize();
    }

    @Override
    protected void $initialize_01_createComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_01_createComponents();
        $objectMap.put("$DemoPanel0", $DemoPanel0);
        createEditing();
        createEditing2();
        createContentMessage();
        // inline creation of $DemoPanel0
        setName("$DemoPanel0");
    }

    @Override
    protected void $initialize_02_registerDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_02_registerDataBindings();
        // register 0 data bindings
    }

    @Override
    protected void $initialize_03_finalizeCreateComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_03_finalizeCreateComponents();
    }

    @Override
    protected void $initialize_04_applyDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_04_applyDataBindings();
    }

    @Override
    protected void $initialize_05_setProperties() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_05_setProperties();
    }

    @Override
    protected void $initialize_06_finalizeInitialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_06_finalizeInitialize();
    }

}
