package org.nuiton.jaxx.demo.component.swing;

/*-
 * #%L
 * JAXX :: Demo
 * %%
 * Copyright (C) 2008 - 2017 Ultreia.io
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.jaxx.demo.DemoPanel;
import org.nuiton.jaxx.runtime.JAXXContext;
import org.nuiton.jaxx.runtime.JAXXObjectDescriptor;
import org.nuiton.jaxx.runtime.JAXXUtil;
import org.nuiton.jaxx.runtime.swing.SwingUtil;
import static org.nuiton.i18n.I18n.t;

public class JMenuItemDemo extends DemoPanel {

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVUTU9TQRSdVkop5UsU4sdCEioYP17R6EaIihAiTSsqG2I3TvvGduB13jhzn32yYOHCnX/AhVs3hv9AXJm4cct/MOEneOe1faXQ1kq7aJs755w598699/sfEtOK3HZVyRIeB1dY29T3LeUJ4BVmZZa3tjYK26wIq0wXFZfgKlL7RKIkmidJO4xrIFY+i0rpmlLaKKXrSukVtyJdwcQxocUsGdbwwWG6zBgAudGRXNQ6vRkiF33pqfpdbV23u+vXp7uHEbb6JUqIL9H+EKZ96z8EmlkPZEmU20Ams9v0PU07VJTQnOKihAmNmtiKQ7V+TivsHdkj8SwZlFShGJA7ZypPIBdI+RJIMrXKKu4LKpizAOTeyRRsPLSKDTVLV9GXlckx4a0DqxiqlIHYIJCxVAav2wFXGjlUu2Tc+w3SsTNDSIS8iVRmXQBTgjprCtNE5pUWZsupIY2E3HgFrTylCsjFFkquFm6ai6eCGGqfPwU0kMkQmUyF+SF66hTaHBjoVMgYfmuMBTXEd2whBEEDG2/qm5rmmNa0xE7Cs7RQg1+V2FBznRoKG9hqNnCzlyJ5ElMehoHMdp4d0/6vEFVr/NnOjW+uCYAf9/fUt+rRYaPbk2hu5l+sY4ONrSeVK5kCbryN11rdA+6kc1Qu5klCMwe3QjD1892db9aR6B5dBI9pGSXrGdVlVIvFDw9+TL/5fY5E18iw41J7jRr8OklAWWHFXMf25eMngbmR6hB+Txib+IwFWtwpKdcTOI5jSzYFOlPgwsaXeeRjpea7Vyo0tr9x9PPr5+sHjWpF0GeqF2azYrHXZJALhwsWbIf64LfdBkmpmWe7zaluN+cR8zsq6+MwF3zfbFeDwTLjpTLulsml2v0zFHAZFTxgWANDs4KMzL+FnlVjVdxwZXP84KwiJny/i8JEDzYS+Px8lxYc1qdQDDj0KWLCD/u0MQDMhy4a0z25eNlF4XIPLi6UXcV3XQHUWXZ4SeBG7mbqWt+mjMJfYxdXVGoIAAA=";
    private static final Log log = LogFactory.getLog(JMenuItemDemo.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JLabel demoMessage;
    protected JPanel framePanel;
    protected JMenuBar menuBar;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JMenuItemDemo $DemoPanel0;
    private JDesktopPane $JDesktopPane0;
    private JInternalFrame $JInternalFrame0;
    private JMenu $JMenu0;
    private JMenuItem $JMenuItem0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    void $afterCompleteSetup(){}

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public JMenuItemDemo(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
    }

    public JMenuItemDemo(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
    }

    public JMenuItemDemo(LayoutManager param0) {
        super(param0);
    }

    public JMenuItemDemo(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
    }

    public JMenuItemDemo() {
        
    }

    public JMenuItemDemo(JAXXContext param0) {
        super(param0);
    }

    public JMenuItemDemo(boolean param0) {
        super(param0);
    }

    public JMenuItemDemo(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__$JMenuItem0(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        JOptionPane.showMessageDialog(this, "Menu item clicked");
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JLabel getDemoMessage() {
        return demoMessage;
    }

    public JPanel getFramePanel() {
        return framePanel;
    }

    public JMenuBar getMenuBar() {
        return menuBar;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JDesktopPane get$JDesktopPane0() {
        return $JDesktopPane0;
    }

    protected JInternalFrame get$JInternalFrame0() {
        return $JInternalFrame0;
    }

    protected JMenu get$JMenu0() {
        return $JMenu0;
    }

    protected JMenuItem get$JMenuItem0() {
        return $JMenuItem0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToFramePanel() {
        framePanel.add(demoMessage);
    }

    protected void addChildrenToMenuBar() {
        menuBar.add($JMenu0);
    }

    protected void create$JInternalFrame0() {
        $objectMap.put("$JInternalFrame0", $JInternalFrame0 = new JInternalFrame());
        
        $JInternalFrame0.setName("$JInternalFrame0");
        $JInternalFrame0.setVisible(true);
        $JInternalFrame0.setClosable(true);
        $JInternalFrame0.setDefaultCloseOperation(2);
        SwingUtil.setComponentHeight($JInternalFrame0,250);
        $JInternalFrame0.setResizable(true);
        $JInternalFrame0.setTitle(t("JMenu demo"));
        SwingUtil.setComponentWidth($JInternalFrame0,300);
    }

    protected void createDemoMessage() {
        $objectMap.put("demoMessage", demoMessage = new JLabel());
        
        demoMessage.setName("demoMessage");
        demoMessage.setHorizontalAlignment(0);
        demoMessage.setText(t("JMenu demo"));
    }

    protected void createFramePanel() {
        $objectMap.put("framePanel", framePanel = new JPanel());
        
        framePanel.setName("framePanel");
    }

    protected void createMenuBar() {
        $objectMap.put("menuBar", menuBar = new JMenuBar());
        
        menuBar.setName("menuBar");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    protected void $initialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $DemoPanel0 = this;
        super.$initialize();
    }

    @Override
    protected void $initialize_01_createComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_01_createComponents();
        $objectMap.put("$DemoPanel0", $DemoPanel0);
        // inline creation of $JDesktopPane0
        $objectMap.put("$JDesktopPane0", $JDesktopPane0 = new JDesktopPane());
        
        $JDesktopPane0.setName("$JDesktopPane0");
        SwingUtil.setComponentHeight($JDesktopPane0,400);
        SwingUtil.setComponentWidth($JDesktopPane0,350);
        create$JInternalFrame0();
        createMenuBar();
        // inline creation of $JMenu0
        $objectMap.put("$JMenu0", $JMenu0 = new JMenu());
        
        $JMenu0.setName("$JMenu0");
        $JMenu0.setText(t("Demo"));
        // inline creation of $JMenuItem0
        $objectMap.put("$JMenuItem0", $JMenuItem0 = new JMenuItem());
        
        $JMenuItem0.setName("$JMenuItem0");
        $JMenuItem0.setText(t("Message Box"));
        $JMenuItem0.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JMenuItem0"));
        createFramePanel();
        createDemoMessage();
        // inline creation of $DemoPanel0
        setName("$DemoPanel0");
        
        $JInternalFrame0.pack();
    }

    @Override
    protected void $initialize_02_registerDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_02_registerDataBindings();
        // register 0 data bindings
    }

    @Override
    protected void $initialize_03_finalizeCreateComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_03_finalizeCreateComponents();
        // inline complete setup of $DemoPanel0
        add($JDesktopPane0);
        // inline complete setup of $JDesktopPane0
        $JDesktopPane0.add($JInternalFrame0);
        // inline complete setup of $JInternalFrame0
        $JInternalFrame0.getContentPane().add(framePanel);
        $JInternalFrame0.setJMenuBar(menuBar);
        addChildrenToMenuBar();
        // inline complete setup of $JMenu0
        $JMenu0.add($JMenuItem0);
        addChildrenToFramePanel();
    }

    @Override
    protected void $initialize_04_applyDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_04_applyDataBindings();
    }

    @Override
    protected void $initialize_05_setProperties() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_05_setProperties();
        
        // apply 1 property setters
        $JDesktopPane0.setBackground(null);
    }

    @Override
    protected void $initialize_06_finalizeInitialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_06_finalizeInitialize();
    }

}
