package org.nuiton.jaxx.demo.component.jaxx.widgets.number;

/*-
 * #%L
 * JAXX :: Demo
 * %%
 * Copyright (C) 2008 - 2017 Ultreia.io
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.awt.BorderLayout;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.ButtonModel;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.jaxx.demo.DemoPanel;
import org.nuiton.jaxx.runtime.JAXXContext;
import org.nuiton.jaxx.runtime.JAXXObjectDescriptor;
import org.nuiton.jaxx.runtime.JAXXUtil;
import org.nuiton.jaxx.runtime.binding.DefaultJAXXBinding;
import org.nuiton.jaxx.runtime.swing.SwingUtil;
import org.nuiton.jaxx.runtime.swing.Table;
import org.nuiton.jaxx.widgets.number.NumberEditor;
import static org.nuiton.i18n.I18n.t;

public class NumberEditorDemo extends DemoPanel {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_DOUBLE_EDITOR_AUTO_POPUP = "doubleEditor.autoPopup";
    public static final String BINDING_DOUBLE_EDITOR_ENABLED = "doubleEditor.enabled";
    public static final String BINDING_DOUBLE_EDITOR_NUMBER_PATTERN = "doubleEditor.numberPattern";
    public static final String BINDING_DOUBLE_EDITOR_NUMBER_VALUE = "doubleEditor.numberValue";
    public static final String BINDING_DOUBLE_EDITOR_SHOW_POPUP_BUTTON = "doubleEditor.showPopupButton";
    public static final String BINDING_DOUBLE_EDITOR_SHOW_RESET = "doubleEditor.showReset";
    public static final String BINDING_FLOAT_EDITOR_AUTO_POPUP = "floatEditor.autoPopup";
    public static final String BINDING_FLOAT_EDITOR_ENABLED = "floatEditor.enabled";
    public static final String BINDING_FLOAT_EDITOR_NUMBER_PATTERN = "floatEditor.numberPattern";
    public static final String BINDING_FLOAT_EDITOR_NUMBER_VALUE = "floatEditor.numberValue";
    public static final String BINDING_FLOAT_EDITOR_SHOW_POPUP_BUTTON = "floatEditor.showPopupButton";
    public static final String BINDING_FLOAT_EDITOR_SHOW_RESET = "floatEditor.showReset";
    public static final String BINDING_INTEGER_EDITOR_AUTO_POPUP = "integerEditor.autoPopup";
    public static final String BINDING_INTEGER_EDITOR_ENABLED = "integerEditor.enabled";
    public static final String BINDING_INTEGER_EDITOR_NUMBER_PATTERN = "integerEditor.numberPattern";
    public static final String BINDING_INTEGER_EDITOR_NUMBER_VALUE = "integerEditor.numberValue";
    public static final String BINDING_INTEGER_EDITOR_SHOW_POPUP_BUTTON = "integerEditor.showPopupButton";
    public static final String BINDING_INTEGER_EDITOR_SHOW_RESET = "integerEditor.showReset";
    public static final String BINDING_RESULT_DOUBLE_TEXT = "resultDouble.text";
    public static final String BINDING_RESULT_FLOAT_TEXT = "resultFloat.text";
    public static final String BINDING_RESULT_INTEGER_TEXT = "resultInteger.text";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAK1Xz08bRxQeu5hfhlBIgtJKBZeQACpdJ1IuLVGbgmMF5CQoQVFULh17B3vpene7O1sbrcihh976D/TQay9V/oeop0q99Mr/UCmn9tJD38wuu7PrWe86gIRBM+9975tv3rz3/NvfqOTYaNO024rhatQ0lGPc7yu2a1CtS5S9r16+fNo8Ji1aI07L1ixq2sj/KRRR8RCV1XDdoUg5bABS1UeqMqRqgFTdMbuWaRBDANpqoGmHnujE6RBCKVpPdW45TvV5aLnVt1w7iCVlLYv15493zwqk9nMRob4F9G/AsT8ZASA69VgDFTWVooXGMf4eV3VstIGcrRltONAsW9vRseM8wV3yHXqFJhpo3MI2gFH06TvJw+E4VN+iqLxaI11zHxtEv0PRTvIIKmwqrXM0f62nqW1CHbDrNomtPOF/HqrgZDMsy+Lo4xSVuqZKdIoeXQLqYwYVQU+sHuCmToDyzTTVnR5oqHAz5jQV+i4ZAvaOaRxpbdfGVDMNLgOzmmcfc6HHnNMxe/um5VrbLoVAFF1nF9MPYuztdEjr222zz8wX4l7PiEOo78WWFxMm2KWmACwxuaoZlLSJ7Qvi04VsicVv4KbPO3K7FnPbx5QSG3gvxvwOSJ/WNaKrw3wfGkxCVUJt/kg3MRWJsY2P4kYLglFAg+1U0q3SAy6opgtbGRGvilbpIWNm6TEnV/fOX0dc9DBZojyZDYTzU4sOVoQhSc4gqiFSmesR7dyLb8/43FP3yzZxXJ2GFO8mePrbuz7bUMLPkv51RkKyPeNv1zgJcd9Gt9OeIxRdJSq6Uf0rHKKS7cIyPOX0es9K9jOw8ov1zfRizcJwwx9ev7J/7b09Eyt0JctLaEZQLi3btIhNNcZtzi/PLtX06mNsbR2iKYfo0Ml4p1obzvx5YAnsgcU8Q1IYkvIIOx1AK02cvfl98Zu/3kPFOpoG0dU6Zva7aIp2QOuOqat968sHnNxMbxI+34ffMYqmwgICdc1LVBNFc/zIRF3fOJWVsSUvsZR0mQpr2LmxUNCSxmNNggF0wuN1/7QPN7U2/KZCYV4/ffvHLz/denN+WwXQaTWPZ3Rjpa/RuGbomkF4Rw2apbSDli2HuKoZdUJZb0Qg6Yz4QoPuU+efewO3UaBovGnaKmQMuu8ZpFc50CjUlG2+tk7XV9gheOvznz/hqNAHhQ60srEBurEAB1wF9t8LlNmzrAxuRbgcCsWeoltyEgOZMekEN8s8bZfISCXzKT+L5XQWQbLlji/k44XjC49JiF86wrojJ5B4cDkITOqsV9dZd1j0ZD36NCS5IScpmQdk3GRzw2j8rnmDrTtityZnNzASyLgNDg6jMbvuSVp8RG1dTm1weJBxk8wYWeQK+dJVOlZdErZkfrokZNmYlAVdomjal/7gxIJmP+cFo4bSYgUWbmrWiM+lFelbUGBYYjMq7y6TQTs+ieYs3xjGFR/tBdZdiPah33+Y865ox1EmiH8EmDY82X3Ee5pMkPiQN6oUsx4fqlKFWJI8ujQZyoJpUoQbkQj1yCohwcfeYNpkCyDOpqMe/4rnD42p51+WPe00AWZE26QCH0QK1ASzhAQrniS/szWIDeA5Xlo4GdwbYTLg/NMmAnHEz0EgKI01b3i08+6ysllJe0QpryL2lSI/oQdZhHiyiXRi6TxUG26Zn8p2FhX/zkUu8cRKSRXxy1KeVNHxiQnjBLpyX8UUV5qaocIXzi8GsAvsczrv+djuv3KM5UwMtvzfEITbF0bYzIXwzxCEOxdG+BwQ/gfPObMrwxQAAA==";
    private static final Log log = LogFactory.getLog(NumberEditorDemo.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JCheckBox autoPopupButton;
    protected NumberEditor doubleEditor;
    protected JLabel doubleNumberConfig;
    protected JCheckBox doubleNumberEnabled;
    protected JTextField doubleNumberPattern;
    protected NumberEditor floatEditor;
    protected JLabel floatNumberConfig;
    protected JCheckBox floatNumberEnabled;
    protected JTextField floatNumberPattern;
    protected NumberEditorDemoHandler handler;
    protected NumberEditor integerEditor;
    protected JLabel integerNumberConfig;
    protected JCheckBox integerNumberEnabled;
    protected JTextField integerNumberPattern;
    protected NumberEditorDemoModel model;
    protected Table numberEditorConfigurationPanel;
    protected JLabel resultDouble;
    protected JLabel resultFloat;
    protected JLabel resultInteger;
    protected JPanel resultPanel;
    protected JCheckBox showPopupButton;
    protected JCheckBox showResetButton;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private NumberEditorDemo $DemoPanel0;
    private JPanel $JPanel0;
    private Table $Table0;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public NumberEditorDemo(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
    }

    public NumberEditorDemo(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
    }

    public NumberEditorDemo(LayoutManager param0) {
        super(param0);
    }

    public NumberEditorDemo(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
    }

    public NumberEditorDemo() {
        
    }

    public NumberEditorDemo(JAXXContext param0) {
        super(param0);
    }

    public NumberEditorDemo(boolean param0) {
        super(param0);
    }

    public NumberEditorDemo(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JCheckBox getAutoPopupButton() {
        return autoPopupButton;
    }

    public NumberEditor getDoubleEditor() {
        return doubleEditor;
    }

    public JLabel getDoubleNumberConfig() {
        return doubleNumberConfig;
    }

    public JCheckBox getDoubleNumberEnabled() {
        return doubleNumberEnabled;
    }

    public JTextField getDoubleNumberPattern() {
        return doubleNumberPattern;
    }

    public NumberEditor getFloatEditor() {
        return floatEditor;
    }

    public JLabel getFloatNumberConfig() {
        return floatNumberConfig;
    }

    public JCheckBox getFloatNumberEnabled() {
        return floatNumberEnabled;
    }

    public JTextField getFloatNumberPattern() {
        return floatNumberPattern;
    }

    public NumberEditorDemoHandler getHandler() {
        return handler;
    }

    public NumberEditor getIntegerEditor() {
        return integerEditor;
    }

    public JLabel getIntegerNumberConfig() {
        return integerNumberConfig;
    }

    public JCheckBox getIntegerNumberEnabled() {
        return integerNumberEnabled;
    }

    public JTextField getIntegerNumberPattern() {
        return integerNumberPattern;
    }

    public NumberEditorDemoModel getModel() {
        return model;
    }

    public Table getNumberEditorConfigurationPanel() {
        return numberEditorConfigurationPanel;
    }

    public JLabel getResultDouble() {
        return resultDouble;
    }

    public JLabel getResultFloat() {
        return resultFloat;
    }

    public JLabel getResultInteger() {
        return resultInteger;
    }

    public JPanel getResultPanel() {
        return resultPanel;
    }

    public JCheckBox getShowPopupButton() {
        return showPopupButton;
    }

    public JCheckBox getShowResetButton() {
        return showResetButton;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected Table get$Table0() {
        return $Table0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToNumberEditorConfigurationPanel() {
        numberEditorConfigurationPanel.add(showPopupButton, new GridBagConstraints(0, 0, 3, 1, 1.0, 0.0, 10, 1, new Insets(1, 1, 1, 1), 0, 0));
        numberEditorConfigurationPanel.add(showResetButton, new GridBagConstraints(0, 1, 3, 1, 1.0, 0.0, 10, 1, new Insets(1, 1, 1, 1), 0, 0));
        numberEditorConfigurationPanel.add(autoPopupButton, new GridBagConstraints(0, 2, 3, 1, 1.0, 0.0, 10, 1, new Insets(1, 1, 1, 1), 0, 0));
        numberEditorConfigurationPanel.add(integerNumberConfig, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 17, 1, new Insets(1, 1, 1, 1), 0, 0));
        numberEditorConfigurationPanel.add(integerNumberPattern, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 10, 1, new Insets(1, 1, 1, 1), 0, 0));
        numberEditorConfigurationPanel.add(integerNumberEnabled, new GridBagConstraints(2, 3, 1, 1, 1.0, 0.0, 13, 1, new Insets(1, 1, 1, 1), 0, 0));
        numberEditorConfigurationPanel.add(floatNumberConfig, new GridBagConstraints(0, 4, 1, 1, 1.0, 0.0, 17, 1, new Insets(1, 1, 1, 1), 0, 0));
        numberEditorConfigurationPanel.add(floatNumberPattern, new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 10, 1, new Insets(1, 1, 1, 1), 0, 0));
        numberEditorConfigurationPanel.add(floatNumberEnabled, new GridBagConstraints(2, 4, 1, 1, 1.0, 0.0, 13, 1, new Insets(1, 1, 1, 1), 0, 0));
        numberEditorConfigurationPanel.add(doubleNumberConfig, new GridBagConstraints(0, 5, 1, 1, 1.0, 0.0, 17, 1, new Insets(1, 1, 1, 1), 0, 0));
        numberEditorConfigurationPanel.add(doubleNumberPattern, new GridBagConstraints(1, 5, 1, 1, 1.0, 0.0, 10, 1, new Insets(1, 1, 1, 1), 0, 0));
        numberEditorConfigurationPanel.add(doubleNumberEnabled, new GridBagConstraints(2, 5, 1, 1, 1.0, 0.0, 13, 1, new Insets(1, 1, 1, 1), 0, 0));
    }

    protected void addChildrenToResultPanel() {
        resultPanel.add(resultInteger);
        resultPanel.add(resultFloat);
        resultPanel.add(resultDouble);
    }

    protected void createAutoPopupButton() {
        $objectMap.put("autoPopupButton", autoPopupButton = new JCheckBox());
        
        autoPopupButton.setName("autoPopupButton");
        autoPopupButton.setText(t("jaxxdemo.numbereditor.autoPopup"));
        autoPopupButton.setSelected(false);
    }

    protected void createDoubleEditor() {
        $objectMap.put("doubleEditor", doubleEditor = new NumberEditor(this));
        
        doubleEditor.setName("doubleEditor");
        doubleEditor.setProperty("doubleNumber");
    }

    protected void createDoubleNumberConfig() {
        $objectMap.put("doubleNumberConfig", doubleNumberConfig = new JLabel());
        
        doubleNumberConfig.setName("doubleNumberConfig");
        doubleNumberConfig.setText(t("jaxxdemo.numbereditor.doubleNumberConfig"));
    }

    protected void createDoubleNumberEnabled() {
        $objectMap.put("doubleNumberEnabled", doubleNumberEnabled = new JCheckBox());
        
        doubleNumberEnabled.setName("doubleNumberEnabled");
        doubleNumberEnabled.setSelected(true);
    }

    protected void createDoubleNumberPattern() {
        $objectMap.put("doubleNumberPattern", doubleNumberPattern = new JTextField());
        
        doubleNumberPattern.setName("doubleNumberPattern");
        doubleNumberPattern.setColumns(15);
    }

    protected void createFloatEditor() {
        $objectMap.put("floatEditor", floatEditor = new NumberEditor(this));
        
        floatEditor.setName("floatEditor");
        floatEditor.setProperty("floatNumber");
    }

    protected void createFloatNumberConfig() {
        $objectMap.put("floatNumberConfig", floatNumberConfig = new JLabel());
        
        floatNumberConfig.setName("floatNumberConfig");
        floatNumberConfig.setText(t("jaxxdemo.numbereditor.floatNumberConfig"));
    }

    protected void createFloatNumberEnabled() {
        $objectMap.put("floatNumberEnabled", floatNumberEnabled = new JCheckBox());
        
        floatNumberEnabled.setName("floatNumberEnabled");
        floatNumberEnabled.setSelected(true);
    }

    protected void createFloatNumberPattern() {
        $objectMap.put("floatNumberPattern", floatNumberPattern = new JTextField());
        
        floatNumberPattern.setName("floatNumberPattern");
        floatNumberPattern.setColumns(15);
    }

    protected void createIntegerEditor() {
        $objectMap.put("integerEditor", integerEditor = new NumberEditor(this));
        
        integerEditor.setName("integerEditor");
        integerEditor.setProperty("integerNumber");
    }

    protected void createIntegerNumberConfig() {
        $objectMap.put("integerNumberConfig", integerNumberConfig = new JLabel());
        
        integerNumberConfig.setName("integerNumberConfig");
        integerNumberConfig.setText(t("jaxxdemo.numbereditor.integerNumberConfig"));
    }

    protected void createIntegerNumberEnabled() {
        $objectMap.put("integerNumberEnabled", integerNumberEnabled = new JCheckBox());
        
        integerNumberEnabled.setName("integerNumberEnabled");
        integerNumberEnabled.setSelected(true);
    }

    protected void createIntegerNumberPattern() {
        $objectMap.put("integerNumberPattern", integerNumberPattern = new JTextField());
        
        integerNumberPattern.setName("integerNumberPattern");
        integerNumberPattern.setColumns(15);
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(NumberEditorDemoModel.class));
    }

    protected void createNumberEditorConfigurationPanel() {
        $objectMap.put("numberEditorConfigurationPanel", numberEditorConfigurationPanel = new Table());
        
        numberEditorConfigurationPanel.setName("numberEditorConfigurationPanel");
    }

    protected void createResultDouble() {
        $objectMap.put("resultDouble", resultDouble = new JLabel());
        
        resultDouble.setName("resultDouble");
    }

    protected void createResultFloat() {
        $objectMap.put("resultFloat", resultFloat = new JLabel());
        
        resultFloat.setName("resultFloat");
    }

    protected void createResultInteger() {
        $objectMap.put("resultInteger", resultInteger = new JLabel());
        
        resultInteger.setName("resultInteger");
    }

    protected void createResultPanel() {
        $objectMap.put("resultPanel", resultPanel = new JPanel());
        
        resultPanel.setName("resultPanel");
        resultPanel.setLayout(new GridLayout(0,1));
    }

    protected void createShowPopupButton() {
        $objectMap.put("showPopupButton", showPopupButton = new JCheckBox());
        
        showPopupButton.setName("showPopupButton");
        showPopupButton.setText(t("jaxxdemo.numbereditor.showPopupButton"));
        showPopupButton.setSelected(true);
    }

    protected void createShowResetButton() {
        $objectMap.put("showResetButton", showResetButton = new JCheckBox());
        
        showResetButton.setName("showResetButton");
        showResetButton.setText(t("jaxxdemo.numbereditor.showReset"));
        showResetButton.setSelected(true);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    protected void $initialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $DemoPanel0 = this;
        handler = new NumberEditorDemoHandler();
        handler.beforeInit(this);
        super.$initialize();
        handler.afterInit(this);
    }

    @Override
    protected void $initialize_01_createComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_01_createComponents();
        $objectMap.put("$DemoPanel0", $DemoPanel0);
        createModel();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        createNumberEditorConfigurationPanel();
        createShowPopupButton();
        createShowResetButton();
        createAutoPopupButton();
        createIntegerNumberConfig();
        createIntegerNumberPattern();
        createIntegerNumberEnabled();
        createFloatNumberConfig();
        createFloatNumberPattern();
        createFloatNumberEnabled();
        createDoubleNumberConfig();
        createDoubleNumberPattern();
        createDoubleNumberEnabled();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new GridLayout());
        createIntegerEditor();
        createFloatEditor();
        createDoubleEditor();
        createResultPanel();
        createResultInteger();
        createResultFloat();
        createResultDouble();
        // inline creation of $DemoPanel0
        setName("$DemoPanel0");
        setLayout(new BorderLayout());
    }

    @Override
    protected void $initialize_02_registerDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_02_registerDataBindings();
        // register 21 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_INTEGER_EDITOR_AUTO_POPUP, true) {
        
            @Override
            public void applyDataBinding() {
                if (autoPopupButton != null) {
                    $bindingSources.put("autoPopupButton.getModel()", autoPopupButton.getModel());
                    autoPopupButton.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u0"));
                    autoPopupButton.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(org.nuiton.jaxx.demo.component.jaxx.widgets.number.NumberEditorDemo.this, BINDING_INTEGER_EDITOR_AUTO_POPUP));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (autoPopupButton != null) {
                    integerEditor.setAutoPopup(autoPopupButton.isSelected());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (autoPopupButton != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("autoPopupButton.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u0"));
                    }
                    autoPopupButton.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(org.nuiton.jaxx.demo.component.jaxx.widgets.number.NumberEditorDemo.this, BINDING_INTEGER_EDITOR_AUTO_POPUP));
                }
            }
        
            public void $pr$u0(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_INTEGER_EDITOR_NUMBER_PATTERN, true) {
        
            @Override
            public void applyDataBinding() {
                if (integerNumberPattern != null) {
                    $bindingSources.put("integerNumberPattern.getDocument()", integerNumberPattern.getDocument());
                    integerNumberPattern.getDocument().addDocumentListener( JAXXUtil.getEventListener(DocumentListener.class, this, "$pr$u1"));
                    integerNumberPattern.addPropertyChangeListener("document", JAXXUtil.getDataBindingUpdateListener(org.nuiton.jaxx.demo.component.jaxx.widgets.number.NumberEditorDemo.this, BINDING_INTEGER_EDITOR_NUMBER_PATTERN));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (integerNumberPattern != null) {
                    integerEditor.setNumberPattern(integerNumberPattern.getText());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (integerNumberPattern != null) {
                    Document $target = (Document) $bindingSources.remove("integerNumberPattern.getDocument()");
                    if ($target != null) {
                        $target.removeDocumentListener( JAXXUtil.getEventListener(DocumentListener.class, this, "$pr$u1"));
                    }
                    integerNumberPattern.removePropertyChangeListener("document", JAXXUtil.getDataBindingUpdateListener(org.nuiton.jaxx.demo.component.jaxx.widgets.number.NumberEditorDemo.this, BINDING_INTEGER_EDITOR_NUMBER_PATTERN));
                }
            }
        
            public void $pr$u1(DocumentEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_INTEGER_EDITOR_SHOW_POPUP_BUTTON, true) {
        
            @Override
            public void applyDataBinding() {
                if (showPopupButton != null) {
                    $bindingSources.put("showPopupButton.getModel()", showPopupButton.getModel());
                    showPopupButton.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u2"));
                    showPopupButton.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(org.nuiton.jaxx.demo.component.jaxx.widgets.number.NumberEditorDemo.this, BINDING_INTEGER_EDITOR_SHOW_POPUP_BUTTON));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (showPopupButton != null) {
                    integerEditor.setShowPopupButton(showPopupButton.isSelected());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (showPopupButton != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("showPopupButton.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u2"));
                    }
                    showPopupButton.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(org.nuiton.jaxx.demo.component.jaxx.widgets.number.NumberEditorDemo.this, BINDING_INTEGER_EDITOR_SHOW_POPUP_BUTTON));
                }
            }
        
            public void $pr$u2(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_INTEGER_EDITOR_NUMBER_VALUE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("integerNumber", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    integerEditor.setNumberValue(model.getIntegerNumber());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("integerNumber", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_INTEGER_EDITOR_SHOW_RESET, true) {
        
            @Override
            public void applyDataBinding() {
                if (showResetButton != null) {
                    $bindingSources.put("showResetButton.getModel()", showResetButton.getModel());
                    showResetButton.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u3"));
                    showResetButton.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(org.nuiton.jaxx.demo.component.jaxx.widgets.number.NumberEditorDemo.this, BINDING_INTEGER_EDITOR_SHOW_RESET));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (showResetButton != null) {
                    integerEditor.setShowReset(showResetButton.isSelected());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (showResetButton != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("showResetButton.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u3"));
                    }
                    showResetButton.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(org.nuiton.jaxx.demo.component.jaxx.widgets.number.NumberEditorDemo.this, BINDING_INTEGER_EDITOR_SHOW_RESET));
                }
            }
        
            public void $pr$u3(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_INTEGER_EDITOR_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (integerNumberEnabled != null) {
                    $bindingSources.put("integerNumberEnabled.getModel()", integerNumberEnabled.getModel());
                    integerNumberEnabled.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u4"));
                    integerNumberEnabled.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(org.nuiton.jaxx.demo.component.jaxx.widgets.number.NumberEditorDemo.this, BINDING_INTEGER_EDITOR_ENABLED));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (integerNumberEnabled != null) {
                    integerEditor.setEnabled(integerNumberEnabled.isSelected());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (integerNumberEnabled != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("integerNumberEnabled.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u4"));
                    }
                    integerNumberEnabled.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(org.nuiton.jaxx.demo.component.jaxx.widgets.number.NumberEditorDemo.this, BINDING_INTEGER_EDITOR_ENABLED));
                }
            }
        
            public void $pr$u4(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FLOAT_EDITOR_AUTO_POPUP, true) {
        
            @Override
            public void applyDataBinding() {
                if (autoPopupButton != null) {
                    $bindingSources.put("autoPopupButton.getModel()", autoPopupButton.getModel());
                    autoPopupButton.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u5"));
                    autoPopupButton.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(org.nuiton.jaxx.demo.component.jaxx.widgets.number.NumberEditorDemo.this, BINDING_FLOAT_EDITOR_AUTO_POPUP));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (autoPopupButton != null) {
                    floatEditor.setAutoPopup(autoPopupButton.isSelected());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (autoPopupButton != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("autoPopupButton.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u5"));
                    }
                    autoPopupButton.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(org.nuiton.jaxx.demo.component.jaxx.widgets.number.NumberEditorDemo.this, BINDING_FLOAT_EDITOR_AUTO_POPUP));
                }
            }
        
            public void $pr$u5(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FLOAT_EDITOR_NUMBER_PATTERN, true) {
        
            @Override
            public void applyDataBinding() {
                if (floatNumberPattern != null) {
                    $bindingSources.put("floatNumberPattern.getDocument()", floatNumberPattern.getDocument());
                    floatNumberPattern.getDocument().addDocumentListener( JAXXUtil.getEventListener(DocumentListener.class, this, "$pr$u6"));
                    floatNumberPattern.addPropertyChangeListener("document", JAXXUtil.getDataBindingUpdateListener(org.nuiton.jaxx.demo.component.jaxx.widgets.number.NumberEditorDemo.this, BINDING_FLOAT_EDITOR_NUMBER_PATTERN));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (floatNumberPattern != null) {
                    floatEditor.setNumberPattern(floatNumberPattern.getText());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (floatNumberPattern != null) {
                    Document $target = (Document) $bindingSources.remove("floatNumberPattern.getDocument()");
                    if ($target != null) {
                        $target.removeDocumentListener( JAXXUtil.getEventListener(DocumentListener.class, this, "$pr$u6"));
                    }
                    floatNumberPattern.removePropertyChangeListener("document", JAXXUtil.getDataBindingUpdateListener(org.nuiton.jaxx.demo.component.jaxx.widgets.number.NumberEditorDemo.this, BINDING_FLOAT_EDITOR_NUMBER_PATTERN));
                }
            }
        
            public void $pr$u6(DocumentEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FLOAT_EDITOR_SHOW_POPUP_BUTTON, true) {
        
            @Override
            public void applyDataBinding() {
                if (showPopupButton != null) {
                    $bindingSources.put("showPopupButton.getModel()", showPopupButton.getModel());
                    showPopupButton.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u7"));
                    showPopupButton.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(org.nuiton.jaxx.demo.component.jaxx.widgets.number.NumberEditorDemo.this, BINDING_FLOAT_EDITOR_SHOW_POPUP_BUTTON));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (showPopupButton != null) {
                    floatEditor.setShowPopupButton(showPopupButton.isSelected());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (showPopupButton != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("showPopupButton.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u7"));
                    }
                    showPopupButton.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(org.nuiton.jaxx.demo.component.jaxx.widgets.number.NumberEditorDemo.this, BINDING_FLOAT_EDITOR_SHOW_POPUP_BUTTON));
                }
            }
        
            public void $pr$u7(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FLOAT_EDITOR_NUMBER_VALUE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("floatNumber", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    floatEditor.setNumberValue(model.getFloatNumber());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("floatNumber", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FLOAT_EDITOR_SHOW_RESET, true) {
        
            @Override
            public void applyDataBinding() {
                if (showResetButton != null) {
                    $bindingSources.put("showResetButton.getModel()", showResetButton.getModel());
                    showResetButton.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u8"));
                    showResetButton.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(org.nuiton.jaxx.demo.component.jaxx.widgets.number.NumberEditorDemo.this, BINDING_FLOAT_EDITOR_SHOW_RESET));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (showResetButton != null) {
                    floatEditor.setShowReset(showResetButton.isSelected());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (showResetButton != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("showResetButton.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u8"));
                    }
                    showResetButton.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(org.nuiton.jaxx.demo.component.jaxx.widgets.number.NumberEditorDemo.this, BINDING_FLOAT_EDITOR_SHOW_RESET));
                }
            }
        
            public void $pr$u8(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FLOAT_EDITOR_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (floatNumberEnabled != null) {
                    $bindingSources.put("floatNumberEnabled.getModel()", floatNumberEnabled.getModel());
                    floatNumberEnabled.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u9"));
                    floatNumberEnabled.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(org.nuiton.jaxx.demo.component.jaxx.widgets.number.NumberEditorDemo.this, BINDING_FLOAT_EDITOR_ENABLED));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (floatNumberEnabled != null) {
                    floatEditor.setEnabled(floatNumberEnabled.isSelected());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (floatNumberEnabled != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("floatNumberEnabled.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u9"));
                    }
                    floatNumberEnabled.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(org.nuiton.jaxx.demo.component.jaxx.widgets.number.NumberEditorDemo.this, BINDING_FLOAT_EDITOR_ENABLED));
                }
            }
        
            public void $pr$u9(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_DOUBLE_EDITOR_AUTO_POPUP, true) {
        
            @Override
            public void applyDataBinding() {
                if (autoPopupButton != null) {
                    $bindingSources.put("autoPopupButton.getModel()", autoPopupButton.getModel());
                    autoPopupButton.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u10"));
                    autoPopupButton.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(org.nuiton.jaxx.demo.component.jaxx.widgets.number.NumberEditorDemo.this, BINDING_DOUBLE_EDITOR_AUTO_POPUP));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (autoPopupButton != null) {
                    doubleEditor.setAutoPopup(autoPopupButton.isSelected());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (autoPopupButton != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("autoPopupButton.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u10"));
                    }
                    autoPopupButton.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(org.nuiton.jaxx.demo.component.jaxx.widgets.number.NumberEditorDemo.this, BINDING_DOUBLE_EDITOR_AUTO_POPUP));
                }
            }
        
            public void $pr$u10(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_DOUBLE_EDITOR_NUMBER_PATTERN, true) {
        
            @Override
            public void applyDataBinding() {
                if (doubleNumberPattern != null) {
                    $bindingSources.put("doubleNumberPattern.getDocument()", doubleNumberPattern.getDocument());
                    doubleNumberPattern.getDocument().addDocumentListener( JAXXUtil.getEventListener(DocumentListener.class, this, "$pr$u11"));
                    doubleNumberPattern.addPropertyChangeListener("document", JAXXUtil.getDataBindingUpdateListener(org.nuiton.jaxx.demo.component.jaxx.widgets.number.NumberEditorDemo.this, BINDING_DOUBLE_EDITOR_NUMBER_PATTERN));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (doubleNumberPattern != null) {
                    doubleEditor.setNumberPattern(doubleNumberPattern.getText());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (doubleNumberPattern != null) {
                    Document $target = (Document) $bindingSources.remove("doubleNumberPattern.getDocument()");
                    if ($target != null) {
                        $target.removeDocumentListener( JAXXUtil.getEventListener(DocumentListener.class, this, "$pr$u11"));
                    }
                    doubleNumberPattern.removePropertyChangeListener("document", JAXXUtil.getDataBindingUpdateListener(org.nuiton.jaxx.demo.component.jaxx.widgets.number.NumberEditorDemo.this, BINDING_DOUBLE_EDITOR_NUMBER_PATTERN));
                }
            }
        
            public void $pr$u11(DocumentEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_DOUBLE_EDITOR_SHOW_POPUP_BUTTON, true) {
        
            @Override
            public void applyDataBinding() {
                if (showPopupButton != null) {
                    $bindingSources.put("showPopupButton.getModel()", showPopupButton.getModel());
                    showPopupButton.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u12"));
                    showPopupButton.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(org.nuiton.jaxx.demo.component.jaxx.widgets.number.NumberEditorDemo.this, BINDING_DOUBLE_EDITOR_SHOW_POPUP_BUTTON));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (showPopupButton != null) {
                    doubleEditor.setShowPopupButton(showPopupButton.isSelected());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (showPopupButton != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("showPopupButton.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u12"));
                    }
                    showPopupButton.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(org.nuiton.jaxx.demo.component.jaxx.widgets.number.NumberEditorDemo.this, BINDING_DOUBLE_EDITOR_SHOW_POPUP_BUTTON));
                }
            }
        
            public void $pr$u12(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_DOUBLE_EDITOR_NUMBER_VALUE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("doubleNumber", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    doubleEditor.setNumberValue(model.getDoubleNumber());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("doubleNumber", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_DOUBLE_EDITOR_SHOW_RESET, true) {
        
            @Override
            public void applyDataBinding() {
                if (showResetButton != null) {
                    $bindingSources.put("showResetButton.getModel()", showResetButton.getModel());
                    showResetButton.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u13"));
                    showResetButton.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(org.nuiton.jaxx.demo.component.jaxx.widgets.number.NumberEditorDemo.this, BINDING_DOUBLE_EDITOR_SHOW_RESET));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (showResetButton != null) {
                    doubleEditor.setShowReset(showResetButton.isSelected());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (showResetButton != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("showResetButton.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u13"));
                    }
                    showResetButton.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(org.nuiton.jaxx.demo.component.jaxx.widgets.number.NumberEditorDemo.this, BINDING_DOUBLE_EDITOR_SHOW_RESET));
                }
            }
        
            public void $pr$u13(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_DOUBLE_EDITOR_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (doubleNumberEnabled != null) {
                    $bindingSources.put("doubleNumberEnabled.getModel()", doubleNumberEnabled.getModel());
                    doubleNumberEnabled.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u14"));
                    doubleNumberEnabled.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(org.nuiton.jaxx.demo.component.jaxx.widgets.number.NumberEditorDemo.this, BINDING_DOUBLE_EDITOR_ENABLED));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (doubleNumberEnabled != null) {
                    doubleEditor.setEnabled(doubleNumberEnabled.isSelected());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (doubleNumberEnabled != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("doubleNumberEnabled.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u14"));
                    }
                    doubleNumberEnabled.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(org.nuiton.jaxx.demo.component.jaxx.widgets.number.NumberEditorDemo.this, BINDING_DOUBLE_EDITOR_ENABLED));
                }
            }
        
            public void $pr$u14(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_RESULT_INTEGER_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("integerNumber", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    resultInteger.setText(t(t("jaxxdemo.numbereditor.model.integer", model.getIntegerNumber())));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("integerNumber", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_RESULT_FLOAT_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("floatNumber", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    resultFloat.setText(t(t("jaxxdemo.numbereditor.model.float", model.getFloatNumber())));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("floatNumber", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_RESULT_DOUBLE_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("doubleNumber", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    resultDouble.setText(t(t("jaxxdemo.numbereditor.model.double", model.getDoubleNumber())));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("doubleNumber", this);
                }
            }
        });
    }

    @Override
    protected void $initialize_03_finalizeCreateComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_03_finalizeCreateComponents();
        // inline complete setup of $DemoPanel0
        add($Table0, BorderLayout.NORTH);
        // inline complete setup of $Table0
        $Table0.add(numberEditorConfigurationPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        $Table0.add($JPanel0, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        $Table0.add(resultPanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        addChildrenToNumberEditorConfigurationPanel();
        // inline complete setup of $JPanel0
        $JPanel0.add(integerEditor);
        $JPanel0.add(floatEditor);
        $JPanel0.add(doubleEditor);
        addChildrenToResultPanel();
    }

    @Override
    protected void $initialize_04_applyDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_04_applyDataBindings();
        
        // apply 21 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
    }

    @Override
    protected void $initialize_05_setProperties() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_05_setProperties();
        
        // apply 17 property setters
        SwingUtil.setText(integerNumberPattern, "-?\\d{0,3}");
        
        SwingUtil.setText(floatNumberPattern, "\\d{0,1}.\\d{0,2}");
        
        SwingUtil.setText(doubleNumberPattern, "-?\\d{0,4}.\\d{0,6}");
        
        numberEditorConfigurationPanel.setBorder(new TitledBorder(t("jaxxdemo.numbereditor.configuration")));
        integerNumberConfig.setLabelFor(integerNumberPattern);
        floatNumberConfig.setLabelFor(floatNumberPattern);
        doubleNumberConfig.setLabelFor(doubleNumberPattern);
        integerEditor.setNumberType(Integer.class);
        integerEditor.setBean(model);
        floatEditor.setNumberType(Float.class);
        floatEditor.setBean(model);
        doubleEditor.setNumberType(Double.class);
        doubleEditor.setBean(model);
        resultPanel.setBorder(new TitledBorder(t("jaxxdemo.numbereditor.model")));
    }

    @Override
    protected void $initialize_06_finalizeInitialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_06_finalizeInitialize();
    }

}
