/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.compiler.tags.validator;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuiton.jaxx.compiler.CompilerException;
import org.nuiton.jaxx.compiler.JAXXCompiler;
import org.nuiton.jaxx.compiler.reflect.ClassDescriptor;
import org.nuiton.jaxx.compiler.reflect.ClassDescriptorHelper;
import org.nuiton.jaxx.compiler.tags.TagHandler;
import org.nuiton.jaxx.compiler.tags.validator.BeanValidatorHandler;
import org.nuiton.jaxx.validator.swing.SwingValidator;
import org.w3c.dom.Element;

public class ExcludeFieldValidatorHandler
implements TagHandler {
    public static final String TAG = "excludeField";
    public static final String NAME_ATTRIBUTE = "name";
    public static final String COMPONENT_ATTRIBUTE = "component";
    private static final Logger log = LogManager.getLogger(ExcludeFieldValidatorHandler.class);

    @Override
    public void compileFirstPass(Element tag, JAXXCompiler compiler) throws CompilerException {
        if (compiler.getConfiguration().isVerbose()) {
            log.info((Object)tag);
        }
    }

    @Override
    public void compileSecondPass(Element tag, JAXXCompiler compiler) throws CompilerException {
        ClassDescriptor descriptor;
        if (compiler.getConfiguration().isVerbose()) {
            log.debug((Object)tag);
        }
        if (!(descriptor = ClassDescriptorHelper.getClassDescriptor(SwingValidator.class)).isAssignableFrom(compiler.getOpenComponent().getObjectClass())) {
            compiler.reportError(String.format("%s tag may only appear within %s tag but was %s", TAG, "BeanValidator", tag));
            return;
        }
        BeanValidatorHandler.CompiledBeanValidator info = (BeanValidatorHandler.CompiledBeanValidator)compiler.getOpenComponent();
        if (!info.getAutoField()) {
            compiler.reportError(String.format("%s tag can not be used without an 'autoField' validator : %s", TAG, tag));
            return;
        }
        String name = tag.getAttribute(NAME_ATTRIBUTE);
        String component = tag.getAttribute(COMPONENT_ATTRIBUTE);
        if (name == null || name.trim().isEmpty()) {
            compiler.reportError(String.format("%s tag requires a %s attribute", TAG, NAME_ATTRIBUTE));
            return;
        }
        name = name.trim();
        if (component == null || component.trim().isEmpty()) {
            if (!compiler.checkReference(tag, name, false, name)) {
                compiler.reportError(String.format("%s tag requires a %s attribute, try to use the name attribute [%s] for the component, but no such component found", TAG, COMPONENT_ATTRIBUTE, name));
                return;
            }
            component = name;
        }
        if (info.containsFieldEditor(component = component.trim())) {
            compiler.reportError(String.format("%s tag found a attribute %s [%s] already used in this validator", TAG, COMPONENT_ATTRIBUTE, component));
            return;
        }
        if (info.containsExcludeFieldEditor(component)) {
            compiler.reportError(String.format("%s tag found a attribute %s [%s] already used in this validator", TAG, COMPONENT_ATTRIBUTE, component));
            return;
        }
        if (compiler.checkReference(tag, component, true, COMPONENT_ATTRIBUTE)) {
            info.registerExcludeField(name, component, compiler);
        }
    }
}

