/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.compiler.reflect;

import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuiton.jaxx.compiler.reflect.ClassDescriptorHelper;
import org.nuiton.jaxx.compiler.reflect.FieldDescriptor;
import org.nuiton.jaxx.compiler.reflect.MethodDescriptor;
import org.nuiton.jaxx.runtime.JAXXObjectDescriptor;

public abstract class ClassDescriptor {
    private static final Logger log = LogManager.getLogger(ClassDescriptor.class);
    public static final FieldDescriptor[] EMPTY_FIELD_DESCRIPTORS_ARRAY = new FieldDescriptor[0];
    private final String name;
    private final String packageName;
    private final String superclass;
    private final String[] interfaces;
    private final boolean isInterface;
    private final boolean isArray;
    private final String componentType;
    private final JAXXObjectDescriptor jaxxObjectDescriptor;
    private final ClassLoader classLoader;
    private final MethodDescriptor[] constructorDescriptors;
    private final MethodDescriptor[] methodDescriptors;
    private final FieldDescriptor[] fieldDescriptors;
    protected final FieldDescriptor[] declaredFieldDescriptors;
    protected final ClassDescriptorHelper.ResolverType resolverType;

    public abstract Optional<MethodDescriptor> tryToGetDeclaredMethodDescriptor(String var1, ClassDescriptor ... var2);

    public abstract MethodDescriptor getDeclaredMethodDescriptor(String var1, ClassDescriptor ... var2) throws NoSuchMethodException;

    public FieldDescriptor getDeclaredFieldDescriptor(String name) throws NoSuchFieldException {
        for (FieldDescriptor descriptor : this.declaredFieldDescriptors) {
            if (!name.equals(descriptor.getName())) continue;
            if (log.isDebugEnabled()) {
                log.debug("Using a declared field descriptor [" + name + "] for " + this.getName());
            }
            return descriptor;
        }
        throw new NoSuchFieldException(name);
    }

    protected ClassDescriptor(ClassDescriptorHelper.ResolverType resolverType, String name, String packageName, String superclass, String[] interfaces, boolean isInterface, boolean isArray, String componentType, JAXXObjectDescriptor jaxxObjectDescriptor, ClassLoader classLoader, MethodDescriptor[] constructorDescriptors, MethodDescriptor[] methodDescriptors, FieldDescriptor[] fieldDescriptors) {
        this(resolverType, name, packageName, superclass, interfaces, isInterface, isArray, componentType, jaxxObjectDescriptor, classLoader, constructorDescriptors, methodDescriptors, fieldDescriptors, null);
    }

    protected ClassDescriptor(ClassDescriptorHelper.ResolverType resolverType, String name, String packageName, String superclass, String[] interfaces, boolean isInterface, boolean isArray, String componentType, JAXXObjectDescriptor jaxxObjectDescriptor, ClassLoader classLoader, MethodDescriptor[] constructorDescriptors, MethodDescriptor[] methodDescriptors, FieldDescriptor[] fieldDescriptors, FieldDescriptor[] declaredFieldDescriptors) {
        this.resolverType = resolverType;
        this.name = name;
        this.packageName = packageName;
        this.superclass = superclass;
        this.interfaces = interfaces;
        this.isInterface = isInterface;
        this.isArray = isArray;
        this.componentType = componentType;
        this.jaxxObjectDescriptor = jaxxObjectDescriptor;
        this.classLoader = classLoader;
        this.constructorDescriptors = constructorDescriptors;
        this.methodDescriptors = methodDescriptors;
        this.fieldDescriptors = fieldDescriptors;
        this.declaredFieldDescriptors = declaredFieldDescriptors;
    }

    public Map<String, String> getTypeParameters() {
        return Map.of();
    }

    public ClassDescriptorHelper.ResolverType getResolverType() {
        return this.resolverType;
    }

    public String getName() {
        return this.name;
    }

    public String getSimpleName() {
        int dot = this.name.lastIndexOf(".");
        return dot == -1 ? this.name : this.name.substring(dot + 1);
    }

    public String getPackageName() {
        return this.packageName;
    }

    public ClassDescriptor getSuperclass() {
        return this.getClassDescriptor(this.superclass);
    }

    public ClassDescriptor[] getInterfaces() {
        ClassDescriptor[] result = new ClassDescriptor[this.interfaces.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.getClassDescriptor(this.interfaces[i]);
        }
        return result;
    }

    public boolean isInterface() {
        return this.isInterface;
    }

    public boolean isArray() {
        return this.isArray;
    }

    public ClassDescriptor getComponentType() {
        return this.getClassDescriptor(this.componentType);
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public MethodDescriptor[] getConstructorDescriptors() {
        return this.constructorDescriptors;
    }

    public MethodDescriptor[] getMethodDescriptors() {
        return this.methodDescriptors;
    }

    public MethodDescriptor getMethodDescriptor(String name, ClassDescriptor ... parameterTypes) throws NoSuchMethodException {
        for (MethodDescriptor m : this.methodDescriptors) {
            if (!m.getName().equals(name) || m.getParameterTypes().length != parameterTypes.length || !Arrays.equals(m.getParameterTypes(), parameterTypes)) continue;
            return m;
        }
        throw new NoSuchMethodException("Could not find method " + name + "(" + Arrays.asList(parameterTypes) + ") in " + this.getName());
    }

    public FieldDescriptor[] getFieldDescriptors() {
        return this.fieldDescriptors;
    }

    public FieldDescriptor[] getDeclaredFieldDescriptors() {
        return this.declaredFieldDescriptors == null ? EMPTY_FIELD_DESCRIPTORS_ARRAY : this.declaredFieldDescriptors;
    }

    public FieldDescriptor getFieldDescriptor(String name) throws NoSuchFieldException {
        for (FieldDescriptor fieldDescriptor : this.fieldDescriptors) {
            if (!fieldDescriptor.getName().equals(name)) continue;
            return fieldDescriptor;
        }
        throw new NoSuchFieldException("Could not find field " + name + " in " + this.getName());
    }

    public Optional<FieldDescriptor> tryToGetFieldDescriptor(String name) {
        for (FieldDescriptor descriptor : this.fieldDescriptors) {
            if (!descriptor.getName().equals(name)) continue;
            return Optional.of(descriptor);
        }
        if (this.declaredFieldDescriptors != null) {
            for (FieldDescriptor descriptor : this.declaredFieldDescriptors) {
                if (!descriptor.getName().equals(name)) continue;
                return Optional.of(descriptor);
            }
        }
        return Optional.empty();
    }

    public Optional<MethodDescriptor> tryToGetSetterMethodDescriptor(String name) {
        String methodName = "set" + StringUtils.capitalize((String)name);
        for (MethodDescriptor descriptor : this.methodDescriptors) {
            if (!descriptor.getName().equals(methodName)) continue;
            return Optional.of(descriptor);
        }
        return this.tryToGetDeclaredMethodDescriptor(name, new ClassDescriptor[0]);
    }

    public JAXXObjectDescriptor getJAXXObjectDescriptor() {
        return this.jaxxObjectDescriptor;
    }

    public boolean isAssignableFrom(ClassDescriptor descriptor) {
        while (descriptor != null) {
            if (this.equals(descriptor)) {
                return true;
            }
            for (ClassDescriptor anInterface : descriptor.getInterfaces()) {
                if (!this.equals(anInterface) && !this.isAssignableFrom(anInterface)) continue;
                return true;
            }
            descriptor = descriptor.getSuperclass();
        }
        return false;
    }

    public String toString() {
        return "ClassDescriptor[" + this.getName() + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ClassDescriptor)) {
            return false;
        }
        ClassDescriptor that = (ClassDescriptor)o;
        return this.name.equals(that.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    protected ClassDescriptor getClassDescriptor(String fqn) {
        if (fqn == null) {
            return null;
        }
        try {
            return ClassDescriptorHelper.getClassDescriptor(fqn, this.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }
}

