/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.compiler.finalizers;

import com.google.auto.service.AutoService;
import java.awt.Container;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.codehaus.plexus.component.annotations.Component;
import org.nuiton.jaxx.compiler.CompiledObject;
import org.nuiton.jaxx.compiler.CompiledObjectDecorator;
import org.nuiton.jaxx.compiler.CompilerException;
import org.nuiton.jaxx.compiler.EventHandler;
import org.nuiton.jaxx.compiler.JAXXCompiler;
import org.nuiton.jaxx.compiler.binding.DataBinding;
import org.nuiton.jaxx.compiler.binding.writers.DefaultJAXXBindingWriter;
import org.nuiton.jaxx.compiler.binding.writers.JAXXBindingWriter;
import org.nuiton.jaxx.compiler.binding.writers.SimpleJAXXObjectBindingWriter;
import org.nuiton.jaxx.compiler.finalizers.AbstractFinalizer;
import org.nuiton.jaxx.compiler.finalizers.JAXXCompilerFinalizer;
import org.nuiton.jaxx.compiler.java.JavaArgument;
import org.nuiton.jaxx.compiler.java.JavaElementFactory;
import org.nuiton.jaxx.compiler.java.JavaField;
import org.nuiton.jaxx.compiler.java.JavaFile;
import org.nuiton.jaxx.compiler.java.JavaFileGenerator;
import org.nuiton.jaxx.compiler.java.JavaMethod;
import org.nuiton.jaxx.compiler.reflect.ClassDescriptor;
import org.nuiton.jaxx.compiler.reflect.ClassDescriptorHelper;
import org.nuiton.jaxx.compiler.reflect.MemberDescriptor;
import org.nuiton.jaxx.compiler.reflect.MethodDescriptor;
import org.nuiton.jaxx.compiler.types.TypeManager;
import org.nuiton.jaxx.runtime.Base64Coder;
import org.nuiton.jaxx.runtime.JAXXBinding;
import org.nuiton.jaxx.runtime.JAXXContext;
import org.nuiton.jaxx.runtime.JAXXObject;
import org.nuiton.jaxx.runtime.JAXXObjectDescriptor;
import org.nuiton.jaxx.runtime.JAXXUtil;
import org.nuiton.jaxx.runtime.spi.UIHandler;
import org.nuiton.jaxx.runtime.swing.SwingUtil;

@Component(hint="default", role=JAXXCompilerFinalizer.class)
@AutoService(value={JAXXCompilerFinalizer.class})
public class DefaultFinalizer
extends AbstractFinalizer {
    public static final String FIELD_NAME_$BINDING_SOURCES = "$bindingSources";
    public static final String FIELD_NAME_$OBJECT_MAP = "$objectMap";
    public static final String FIELD_NAME_$ACTIVE_BINDINGS = "$activeBindings";
    public static final String FIELD_NAME_$PREVIOUS_VALUES = "$previousValues";
    public static final String FIELD_NAME_$BINDINGS = "$bindings";
    public static final String FIELD_NAME_$PROPERTY_CHANGE_SUPPORT = "$propertyChangeSupport";
    public static final String FIELD_NAME_DELEGATE_CONTEXT = "delegateContext";
    public static final String FIELD_NAME_SERIAL_VERSION_UID = "serialVersionUID";
    public static final String FIELD_NAME_$JAXX_OBJECT_DESCRIPTOR = "$jaxxObjectDescriptor";
    public static final String METHOD_NAME_$GET_JAXX_OBJECT_DESCRIPTOR = "$getJAXXObjectDescriptor";
    public static final String METHOD_NAME_REGISTER_DATA_BINDING = "registerDataBinding";
    public static final String METHOD_NAME_REMOVE_DATA_BINDING = "removeDataBinding";
    public static final String METHOD_NAME_APPLY_DATA_BINDING = "applyDataBinding";
    public static final String METHOD_NAME_PROCESS_DATA_BINDING = "processDataBinding";
    public static final String METHOD_NAME_FIRE_PROPERTY_CHANGE = "firePropertyChange";
    public static final String METHOD_NAME_$GET_PROPERTY_CHANGE_SUPPORT = "$getPropertyChangeSupport";
    public static final String METHOD_NAME_$INITIALIZE = "$initialize";
    public static final String METHOD_NAME_$INITIALIZE_01_CREATE_HANDLER = "$initialize_01_createHandler";
    public static final String METHOD_NAME_$INITIALIZE_01_CREATE_COMPONENTS = "$initialize_01_createComponents";
    public static final String METHOD_NAME_$INITIALIZE_02_REGISTER_DATA_BINDINGS = "$initialize_02_registerDataBindings";
    public static final String METHOD_NAME_$INITIALIZE_03_FINALIZE_CREATE_COMPONENTS = "$initialize_03_finalizeCreateComponents";
    public static final String METHOD_NAME_$INITIALIZE_03_REGISTER_ACTIONS = "$initialize_03_registerActions";
    public static final String METHOD_NAME_$INITIALIZE_04_APPLY_DATA_BINDINGS = "$initialize_04_applyDataBindings";
    public static final String METHOD_NAME_$INITIALIZE_05_SET_PROPERTIES = "$initialize_05_setProperties";
    public static final String METHOD_NAME_$INITIALIZE_06_FINALIZE_INITIALIZE = "$initialize_06_finalizeInitialize";
    public static final String METHOD_$INITIALIZER_CALL = "JAXXObject.initialize(%1$s        this,%1$s        this::%2$s,%1$s        this::%3$s,%1$s        this::%4$s,%1$s        this::%5$s,%1$s        this::%6$s,%1$s        this::%7$s,%1$s        this::%8$s,%1$s        this::%9$s);%1$s";
    protected static final Logger log = LogManager.getLogger(DefaultFinalizer.class);
    protected static final JavaField SERIAL_VERSION_UID_FIELD = JavaElementFactory.newField(26, "long", "serialVersionUID", false, "1L", new String[0]);
    protected static final JavaField ACTIVE_BINDINGS_FIELD = JavaElementFactory.newField(4, List.class.getName() + "<Object>", "$activeBindings", false, "new %s<Object>()", ArrayList.class.getName());
    protected static final JavaField BINDING_SOURCES_FIELD = JavaElementFactory.newField(4, Map.class.getName() + "<String, Object>", "$bindingSources", false, "new %s<String, Object>()", HashMap.class.getName());
    protected static final JavaField OBJECT_MAP_FIELD = JavaElementFactory.newField(4, Map.class.getName() + "<String, Object>", "$objectMap", true, "new %s<String, Object>()", HashMap.class.getName());
    protected static final JavaField PREVIOUS_VALUES_FIELD = JavaElementFactory.newField(4, Map.class.getName() + "<?,?>", "$previousValues", false, "new %s<Object, Object>()", HashMap.class.getName());
    protected static final JavaField BINDINGS_FIELD = JavaElementFactory.newField(20, Map.class.getName() + "<String, " + JAXXBinding.class.getName() + ">", "$bindings", false, "new %s<String, %s>()", TreeMap.class.getName(), JAXXBinding.class.getName());
    protected static final JavaField PROPERTY_CHANGE_SUPPORT_FIELD = JavaElementFactory.newField(4, PropertyChangeSupport.class.getName(), "$propertyChangeSupport", false);
    protected static final JavaMethod GET_CONTEXT_VALUE_METHOD = JavaElementFactory.newMethod(1, "<T> T", "getContextValue", "return delegateContext.getContextValue(clazz, null);", true, JavaElementFactory.newArgument("Class<T>", "clazz"));
    protected static final JavaMethod GET_CONTEXT_VALUE_NAMED_METHOD = JavaElementFactory.newMethod(1, "<T> T", "getContextValue", "return delegateContext.getContextValue(clazz, name);", true, JavaElementFactory.newArgument("Class<T>", "clazz"), JavaElementFactory.newArgument("String", "name"));
    protected static final JavaMethod SET_CONTEXT_VALUE_NAMED_METHOD = JavaElementFactory.newMethod(1, "<T> void", "setContextValue", "delegateContext.setContextValue(o, name);", true, JavaElementFactory.newArgument("T", "o"), JavaElementFactory.newArgument("String", "name"));
    protected static final JavaMethod SET_CONTEXT_VALUE_METHOD = JavaElementFactory.newMethod(1, "<T> void", "setContextValue", "delegateContext.setContextValue(o, null);", true, JavaElementFactory.newArgument("T", "o"));
    protected static final JavaMethod REMOVE_CONTEXT_VALUE_NAMED_METHOD = JavaElementFactory.newMethod(1, "<T> void", "removeContextValue", "delegateContext.removeContextValue(clazz, name);", true, JavaElementFactory.newArgument("Class<T>", "clazz"), JavaElementFactory.newArgument("String", "name"));
    protected static final JavaMethod REMOVE_CONTEXT_VALUE_METHOD = JavaElementFactory.newMethod(1, "<T> void", "removeContextValue", "delegateContext.removeContextValue(clazz, null);", true, JavaElementFactory.newArgument("Class<T>", "clazz"));
    protected static final JavaMethod GET_PARENT_CONTAINER_MORE_METHOD = JavaElementFactory.newMethod(1, "<O extends Container> O", "getParentContainer", "return %s.getParentContainer(source, clazz);", true, JavaElementFactory.newArgument("Object", "source"), JavaElementFactory.newArgument("Class<O>", "clazz"));
    protected static final JavaMethod GET_PARENT_CONTAINER_METHOD = JavaElementFactory.newMethod(1, "<O extends Container> O", "getParentContainer", "return %s.getParentContainer(this, clazz);", true, JavaElementFactory.newArgument("Class<O>", "clazz"));
    protected static final JavaMethod GET_OBJECT_BY_ID_METHOD = JavaElementFactory.newMethod(1, "Object", "getObjectById", "return $objectMap.get(id);", true, JavaElementFactory.newArgument("String", "id"));
    protected static final JavaMethod GET_JAXX_OBJECT_DESCRIPTOR_METHOD = JavaElementFactory.newMethod(9, JAXXObjectDescriptor.class.getName(), "$getJAXXObjectDescriptor", "return %s.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);", false, new JavaArgument[0]);
    protected static final JavaMethod REGISTER_DATA_BINDING_METHOD = JavaElementFactory.newMethod(1, "void", "registerDataBinding", "$bindings.put(binding.getId(), binding);", true, JavaElementFactory.newArgument(JAXXBinding.class.getName(), "binding"));
    protected static final JavaMethod GET_DATA_BINDINGS_METHOD = JavaElementFactory.newMethod(1, JAXXBinding.class.getName() + "[]", "getDataBindings", "return $bindings.values().toArray(new %s[$bindings.size()]);", true, new JavaArgument[0]);
    protected static final JavaMethod GET_DATA_BINDING_METHOD = JavaElementFactory.newMethod(1, JAXXBinding.class.getName(), "getDataBinding", "return $bindings.get(bindingId);", true, JavaElementFactory.newArgument("String", "bindingId"));
    protected static final JavaMethod FIRE_PROPERTY_CHANGE_METHOD = JavaElementFactory.newMethod(1, "void", "firePropertyChange", "super.firePropertyChange(propertyName, oldValue, newValue);", true, JavaElementFactory.newArgument("String", "propertyName"), JavaElementFactory.newArgument("Object", "oldValue"), JavaElementFactory.newArgument("Object", "newValue"));
    protected static final JavaMethod FIRE_PROPERTY_CHANGE_NAMED_METHOD = JavaElementFactory.newMethod(1, "void", "firePropertyChange", "$getPropertyChangeSupport().firePropertyChange(propertyName, oldValue, newValue);", true, JavaElementFactory.newArgument("String", "propertyName"), JavaElementFactory.newArgument("Object", "oldValue"), JavaElementFactory.newArgument("Object", "newValue"));
    protected static final JavaMethod GET_PROPERTY_CHANGE_SUPPORT_METHOD = JavaElementFactory.newMethod(0, PropertyChangeSupport.class.getName(), "$getPropertyChangeSupport", "if ($propertyChangeSupport == null)\n    $propertyChangeSupport = new PropertyChangeSupport(this);\nreturn $propertyChangeSupport;", false, new JavaArgument[0]);
    protected static final JavaMethod ADD_PROPERTY_CHANGE_SUPPORT_METHOD = JavaElementFactory.newMethod(1, "void", "addPropertyChangeListener", "$getPropertyChangeSupport().addPropertyChangeListener(listener);", true, JavaElementFactory.newArgument(PropertyChangeListener.class.getName(), "listener"));
    protected static final JavaMethod ADD_PROPERTY_CHANGE_SUPPORT_NAMED_METHOD = JavaElementFactory.newMethod(1, "void", "addPropertyChangeListener", "$getPropertyChangeSupport().addPropertyChangeListener(property, listener);", true, JavaElementFactory.newArgument("String", "property"), JavaElementFactory.newArgument(PropertyChangeListener.class.getName(), "listener"));
    protected static final JavaMethod REMOVE_PROPERTY_CHANGE_SUPPORT_METHOD = JavaElementFactory.newMethod(1, "void", "removePropertyChangeListener", "$getPropertyChangeSupport().removePropertyChangeListener(listener);", true, JavaElementFactory.newArgument(PropertyChangeListener.class.getName(), "listener"));
    protected static final JavaMethod REMOVE_PROPERTY_CHANGE_SUPPORT_NAMED_METHOD = JavaElementFactory.newMethod(1, "void", "removePropertyChangeListener", "$getPropertyChangeSupport().removePropertyChangeListener(property, listener);", true, JavaElementFactory.newArgument("String", "property"), JavaElementFactory.newArgument(PropertyChangeListener.class.getName(), "listener"));
    private static final String PARAMETER_NAME_$BINDING = "$binding";
    protected static final JavaMethod PROCESS_DATA_BINDING_METHOD = JavaElementFactory.newMethod(1, "void", "processDataBinding", "processDataBinding($binding, false);", true, JavaElementFactory.newArgument("String", "$binding"));
    protected final JAXXBindingWriter<?>[] bindingWriters = new JAXXBindingWriter[]{new SimpleJAXXObjectBindingWriter(), new DefaultJAXXBindingWriter()};

    @Override
    public boolean accept(JAXXCompiler compiler) {
        return true;
    }

    @Override
    public void finalizeCompiler(CompiledObject root, JAXXCompiler compiler, JavaFile javaFile, String packageName, String className) throws ClassNotFoundException {
        String fullClassName;
        String string = fullClassName = packageName != null ? packageName + "." + className : className;
        if (root == null) {
            throw new CompilerException("root tag can not be null");
        }
        ClassDescriptor superclass = root.getObjectClass();
        boolean superclassIsJAXXObject = compiler.isSuperClassAware(JAXXObject.class);
        javaFile.setModifiers(1);
        javaFile.setName(fullClassName);
        javaFile.setSimpleName(className);
        javaFile.setSuperClass(JAXXCompiler.getCanonicalName(superclass));
        javaFile.setSuperclassIsJAXXObject(superclassIsJAXXObject);
        javaFile.addInterface(compiler.getExtraInterfaces());
        javaFile.setAbstractClass(compiler.isAbstractClass());
        javaFile.setGenericType(compiler.getGenericType());
        javaFile.setSuperGenericType(compiler.getSuperGenericType());
        if (!superclassIsJAXXObject) {
            javaFile.addInterface(JAXXObject.class.getName());
        }
    }

    @Override
    public void prepareJavaFile(CompiledObject root, JAXXCompiler compiler, JavaFile javaFile, String packageName, String className) {
        this.addLoggerSupport(compiler, javaFile, className);
        this.addJAXXObjectSupport(compiler, root, javaFile);
        this.addSimpleField(javaFile, SERIAL_VERSION_UID_FIELD);
        this.addJAXXObjectDescriptorField(compiler, javaFile);
        this.addMethod(javaFile, GET_JAXX_OBJECT_DESCRIPTOR_METHOD, JAXXUtil.class.getName());
        this.addPreviousValuesField(compiler, javaFile, root);
        DataBinding[] bindings = compiler.getBindingHelper().getDataBindings();
        this.addInitializerMethod(compiler, javaFile);
        this.addInitialize_01_createHandler(compiler, javaFile, className);
        this.addInitialize_01_createComponents(compiler, javaFile);
        this.addInitialize_02_registerActions(compiler, javaFile);
        this.addInitialize_02_registerDataBindings(compiler, javaFile);
        this.addInitialize_03_finalizeCreateComponents(compiler, javaFile);
        this.addInitialize_04_applyDataBindings(compiler, javaFile);
        this.addInitialize_05_setProperties(compiler, javaFile);
        this.addInitialize_06_finalizeInitialize(compiler, javaFile);
        javaFile.addBodyCode(compiler.getBodyCode().toString());
        this.addDataBindings(compiler, javaFile, bindings);
        this.addEventHandlers(compiler, javaFile);
    }

    protected void addDataBindings(JAXXCompiler compiler, JavaFile javaFile, DataBinding[] bindings) {
        if (bindings.length < 1) {
            return;
        }
        for (JAXXBindingWriter<?> writer : this.bindingWriters) {
            if (!writer.isUsed()) continue;
            javaFile.addImport(writer.getType());
        }
        for (DataBinding binding : bindings) {
            String constantId = binding.getConstantId();
            compiler.addSimpleField(JavaElementFactory.newField((constantId.startsWith("BINDING_$") ? 2 : 1) | 0x10 | 8, "String", constantId, false, TypeManager.getJavaCode(binding.getRealId()), new String[0]));
        }
    }

    protected void addJAXXObjectSupport(JAXXCompiler compiler, CompiledObject root, JavaFile javaFile) {
        String jaxxContextImplementorClass = compiler.getConfiguration().getJaxxContextClass().getName();
        boolean superclassIsJAXXObject = javaFile.isSuperclassIsJAXXObject();
        if (superclassIsJAXXObject) {
            javaFile.addImport(JAXXContext.class);
        } else {
            this.addField(javaFile, OBJECT_MAP_FIELD);
            this.addSimpleField(javaFile, BINDING_SOURCES_FIELD);
            this.addSimpleField(javaFile, ACTIVE_BINDINGS_FIELD);
            this.addSimpleField(javaFile, BINDINGS_FIELD);
            javaFile.addMethod(GET_OBJECT_BY_ID_METHOD);
            this.addMethod(javaFile, REGISTER_DATA_BINDING_METHOD, new String[0]);
            this.addMethod(javaFile, GET_DATA_BINDINGS_METHOD, JAXXBinding.class.getSimpleName());
            this.addMethod(javaFile, GET_DATA_BINDING_METHOD, JAXXBinding.class.getSimpleName());
            javaFile.addMethod(this.createApplyDataBindingMethod());
            javaFile.addMethod(this.createProcessDataBindingMethod());
            javaFile.addMethod(this.createRemoveDataBindingMethod());
            String type = javaFile.getImportedType(jaxxContextImplementorClass);
            javaFile.addField(JavaElementFactory.newField(20, JAXXContext.class.getName(), FIELD_NAME_DELEGATE_CONTEXT, true, "new " + type + "()", new String[0]));
            javaFile.addImport(Container.class);
            javaFile.addMethod(SET_CONTEXT_VALUE_METHOD);
            javaFile.addMethod(SET_CONTEXT_VALUE_NAMED_METHOD);
            javaFile.addMethod(GET_CONTEXT_VALUE_METHOD);
            javaFile.addMethod(GET_CONTEXT_VALUE_NAMED_METHOD);
            javaFile.addMethod(REMOVE_CONTEXT_VALUE_METHOD);
            javaFile.addMethod(REMOVE_CONTEXT_VALUE_NAMED_METHOD);
            this.addMethod(javaFile, GET_PARENT_CONTAINER_METHOD, SwingUtil.class.getName());
            this.addMethod(javaFile, GET_PARENT_CONTAINER_MORE_METHOD, SwingUtil.class.getName());
            this.addPropertyChangeSupport(root, javaFile);
            javaFile.addMethod(PROCESS_DATA_BINDING_METHOD);
        }
    }

    protected void addLoggerSupport(JAXXCompiler compiler, JavaFile javaFile, String className) {
        if (compiler.getConfiguration().isAddLogger()) {
            javaFile.addSimpleField(JavaElementFactory.newField(26, Logger.class.getName(), "log", false, "%s.getLogger(" + className + ".class)", LogManager.class.getName()));
        }
    }

    protected JavaField addJAXXObjectDescriptorField(JAXXCompiler compiler, JavaFile javaFile) {
        JavaField field;
        try {
            JAXXObjectDescriptor descriptor = compiler.getJAXXObjectDescriptor();
            String data = Base64Coder.serialize((Object)descriptor, (boolean)true);
            int sizeLimit = 65000;
            if (data.length() < sizeLimit) {
                field = JavaElementFactory.newField(26, "String", FIELD_NAME_$JAXX_OBJECT_DESCRIPTOR, false, TypeManager.getJavaCode(data), new String[0]);
            } else {
                StringBuilder initializer = new StringBuilder();
                for (int i = 0; i < data.length(); i += sizeLimit) {
                    String name = FIELD_NAME_$JAXX_OBJECT_DESCRIPTOR + i;
                    javaFile.addField(JavaElementFactory.newField(10, "String", name, false, TypeManager.getJavaCode(data.substring(i, Math.min(i + sizeLimit, data.length()))), new String[0]));
                    if (initializer.length() > 0) {
                        initializer.append(" + ");
                    }
                    initializer.append("String.valueOf(");
                    initializer.append(name);
                    initializer.append(")");
                }
                field = JavaElementFactory.newField(26, "String", FIELD_NAME_$JAXX_OBJECT_DESCRIPTOR, false, initializer.toString(), new String[0]);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Internal error: can't-happen error", e);
        }
        javaFile.addSimpleField(field);
        return field;
    }

    protected void addPreviousValuesField(JAXXCompiler compiler, JavaFile javaFile, CompiledObject root) {
        boolean superclassIsJAXXObject = javaFile.isSuperclassIsJAXXObject();
        if (compiler.getStylesheet() != null) {
            boolean needField = true;
            if (superclassIsJAXXObject) {
                JAXXCompiler parentCompiler;
                ClassDescriptor superclass = root.getObjectClass();
                if (log.isDebugEnabled()) {
                    log.debug("superclass : " + superclass);
                }
                if ((parentCompiler = compiler.getEngine().getJAXXCompiler(superclass.getName())) != null) {
                    needField = parentCompiler.getStylesheet() == null;
                } else {
                    try {
                        superclass.getDeclaredFieldDescriptor(PREVIOUS_VALUES_FIELD.getName());
                        needField = false;
                    }
                    catch (NoSuchFieldException noSuchFieldException) {
                        // empty catch block
                    }
                }
                if (needField && log.isDebugEnabled()) {
                    log.debug("no " + PREVIOUS_VALUES_FIELD.getName() + " field in super class");
                }
            }
            if (needField) {
                this.addSimpleField(javaFile, PREVIOUS_VALUES_FIELD);
            }
        }
    }

    protected void addPropertyChangeSupport(CompiledObject root, JavaFile javaFile) {
        int modifiers;
        ClassDescriptor currentClass = root.getObjectClass();
        MemberDescriptor firePropertyChange = null;
        while (firePropertyChange == null && currentClass != null) {
            try {
                firePropertyChange = currentClass.getDeclaredMethodDescriptor(METHOD_NAME_FIRE_PROPERTY_CHANGE, ClassDescriptorHelper.getClassDescriptor(String.class), ClassDescriptorHelper.getClassDescriptor(Object.class), ClassDescriptorHelper.getClassDescriptor(Object.class));
            }
            catch (NoSuchMethodException e) {
                currentClass = currentClass.getSuperclass();
            }
        }
        int n = modifiers = firePropertyChange != null ? firePropertyChange.getModifiers() : 0;
        if (Modifier.isPublic(modifiers)) {
            return;
        }
        if (Modifier.isProtected(modifiers)) {
            javaFile.addMethod(FIRE_PROPERTY_CHANGE_METHOD);
        } else {
            this.addField(javaFile, PROPERTY_CHANGE_SUPPORT_FIELD);
            this.addMethod(javaFile, GET_PROPERTY_CHANGE_SUPPORT_METHOD, PropertyChangeSupport.class.getName());
            this.addMethod(javaFile, ADD_PROPERTY_CHANGE_SUPPORT_METHOD, new String[0]);
            this.addMethod(javaFile, ADD_PROPERTY_CHANGE_SUPPORT_NAMED_METHOD, new String[0]);
            this.addMethod(javaFile, REMOVE_PROPERTY_CHANGE_SUPPORT_METHOD, new String[0]);
            this.addMethod(javaFile, REMOVE_PROPERTY_CHANGE_SUPPORT_NAMED_METHOD, new String[0]);
            this.addMethod(javaFile, FIRE_PROPERTY_CHANGE_NAMED_METHOD, new String[0]);
        }
    }

    protected void addInitialize_01_createHandler(JAXXCompiler compiler, JavaFile javaFile, String className) {
        String handlerReturnType = String.format("%s<? extends %s>", compiler.getImportedType(UIHandler.class.getName()), compiler.getImportedType(JAXXObject.class.getName()));
        if (compiler.isAbstractClass()) {
            JavaMethod method = JavaElementFactory.newMethod(1028, handlerReturnType, METHOD_NAME_$INITIALIZE_01_CREATE_HANDLER, "", javaFile.isSuperclassIsJAXXObject(), new JavaArgument[0]);
            javaFile.addMethod(method);
            return;
        }
        StringBuilder body = new StringBuilder();
        body.append(JavaFileGenerator.addDebugLoggerInvocation(compiler, "this"));
        String eol = JAXXCompiler.getLineSeparator();
        ClassDescriptor objectClass = compiler.getRootObject().getObjectClass();
        boolean useHandler = compiler.isUseHandler();
        if (javaFile.isSuperclassIsJAXXObject() && !useHandler && objectClass.tryToGetFieldDescriptor("handler").isPresent()) {
            return;
        }
        if (!useHandler) {
            body.append("return null;").append(eol);
            JavaMethod method = JavaElementFactory.newMethod(4, handlerReturnType, METHOD_NAME_$INITIALIZE_01_CREATE_HANDLER, body.toString(), javaFile.isSuperclassIsJAXXObject(), new JavaArgument[0]);
            javaFile.addMethod(method);
            return;
        }
        String handler = compiler.getUiHandler();
        String handlerType = compiler.getImportedType(handler);
        body.append("return handler = new ").append(handlerType);
        String genericType = compiler.getGenericType();
        if (genericType != null) {
            body.append("<>");
            handlerReturnType = !compiler.isAbstractClass() ? handlerType : String.format("%s<%s<%s>>", compiler.getImportedType(UIHandler.class.getName()), className, genericType);
        }
        String constructorParams = "";
        try {
            ClassDescriptor classDescriptor = ClassDescriptorHelper.getClassDescriptor(handler);
            MethodDescriptor[] constructorDescriptors = classDescriptor.getConstructorDescriptors();
            if (constructorDescriptors.length == 1 && constructorDescriptors[0].getParameterTypes().length == 1 && constructorDescriptors[0].getParameterTypes()[0] != null && (constructorDescriptors[0].getParameterTypes()[0].isAssignableFrom(objectClass) || javaFile.getName().equals(constructorDescriptors[0].getParameterTypes()[0].getName()) || constructorDescriptors[0].getParameterTypes()[0].isAssignableFrom(ClassDescriptorHelper.getClassDescriptor(JAXXObject.class)))) {
                constructorParams = "this";
            }
        }
        catch (ClassNotFoundException classDescriptor) {
            // empty catch block
        }
        body.append("(").append(constructorParams).append(");").append(eol);
        JavaMethod method = JavaElementFactory.newMethod(4, handlerReturnType, METHOD_NAME_$INITIALIZE_01_CREATE_HANDLER, body.toString(), javaFile.isSuperclassIsJAXXObject(), new JavaArgument[0]);
        javaFile.addMethod(method);
    }

    protected void addInitialize_01_createComponents(JAXXCompiler compiler, JavaFile javaFile) {
        StringBuilder body = new StringBuilder();
        body.append(JavaFileGenerator.addDebugLoggerInvocation(compiler, "this"));
        String eol = JAXXCompiler.getLineSeparator();
        if (javaFile.isSuperclassIsJAXXObject()) {
            body.append(String.format("super.%s();", METHOD_NAME_$INITIALIZE_01_CREATE_COMPONENTS)).append(eol);
        }
        CompiledObject root = compiler.getRootObject();
        String rootId = root.getId();
        body.append("$objectMap.put(").append(TypeManager.getJavaCode(rootId)).append(", ").append(rootId).append(");").append(eol);
        Iterator<CompiledObject> i = compiler.getObjectCreationOrder();
        boolean lastWasMethodCall = false;
        while (i.hasNext()) {
            CompiledObject object = i.next();
            if (object == root) continue;
            CompiledObjectDecorator decorator = object.getDecorator();
            lastWasMethodCall = decorator.createInitializer(compiler, root, object, body, lastWasMethodCall);
        }
        root.getDecorator().createInitializer(compiler, root, root, body, lastWasMethodCall);
        if (compiler.getInitializer().length() > 0) {
            body.append((CharSequence)compiler.getInitializer());
        }
        JavaMethod method = JavaElementFactory.newMethod(4, "void", METHOD_NAME_$INITIALIZE_01_CREATE_COMPONENTS, body.toString(), javaFile.isSuperclassIsJAXXObject(), new JavaArgument[0]);
        javaFile.addMethod(method);
    }

    protected void addInitialize_02_registerDataBindings(JAXXCompiler compiler, JavaFile javaFile) {
        StringBuilder body = new StringBuilder();
        body.append(JavaFileGenerator.addDebugLoggerInvocation(compiler, "this"));
        String eol = JAXXCompiler.getLineSeparator();
        if (javaFile.isSuperclassIsJAXXObject()) {
            body.append(String.format("super.%s();", METHOD_NAME_$INITIALIZE_02_REGISTER_DATA_BINDINGS)).append(eol);
        }
        JavaFileGenerator generator = new JavaFileGenerator(eol, true);
        for (JAXXBindingWriter<?> writer : this.bindingWriters) {
            writer.reset();
        }
        for (JAXXBindingWriter<?> writer : this.bindingWriters) {
            if (!writer.isUsed()) continue;
            compiler.getJavaFile().addImport(writer.getType());
        }
        DataBinding[] bindings = compiler.getBindingHelper().getDataBindings();
        body.append("// register ");
        body.append(bindings.length);
        body.append(" data bindings");
        body.append(eol);
        block2: for (DataBinding binding : bindings) {
            for (JAXXBindingWriter<?> writer : this.bindingWriters) {
                if (!writer.accept(binding)) continue;
                writer.write(binding, generator, body);
                continue block2;
            }
        }
        JavaMethod method = JavaElementFactory.newMethod(4, "void", METHOD_NAME_$INITIALIZE_02_REGISTER_DATA_BINDINGS, body.toString(), javaFile.isSuperclassIsJAXXObject(), new JavaArgument[0]);
        javaFile.addMethod(method);
    }

    protected void addInitialize_02_registerActions(JAXXCompiler compiler, JavaFile javaFile) {
        StringBuilder body = new StringBuilder();
        body.append(JavaFileGenerator.addDebugLoggerInvocation(compiler, "this"));
        String eol = JAXXCompiler.getLineSeparator();
        if (javaFile.isSuperclassIsJAXXObject()) {
            body.append(String.format("super.%s();", METHOD_NAME_$INITIALIZE_03_REGISTER_ACTIONS)).append(eol);
        }
        body.append((CharSequence)compiler.getActionsInitializer()).append(eol);
        JavaMethod method = JavaElementFactory.newMethod(4, "void", METHOD_NAME_$INITIALIZE_03_REGISTER_ACTIONS, body.toString(), javaFile.isSuperclassIsJAXXObject(), new JavaArgument[0]);
        javaFile.addMethod(method);
    }

    protected void addInitialize_03_finalizeCreateComponents(JAXXCompiler compiler, JavaFile javaFile) {
        StringBuilder body = new StringBuilder();
        body.append(JavaFileGenerator.addDebugLoggerInvocation(compiler, "this"));
        String eol = JAXXCompiler.getLineSeparator();
        if (javaFile.isSuperclassIsJAXXObject()) {
            body.append(String.format("super.%s();", METHOD_NAME_$INITIALIZE_03_FINALIZE_CREATE_COMPONENTS)).append(eol);
        }
        for (CompiledObject object : compiler.getObjects().values()) {
            CompiledObjectDecorator decorator = object.getDecorator();
            body.append(decorator.createCompleteSetupMethod(compiler, object, javaFile));
        }
        JavaMethod method = JavaElementFactory.newMethod(4, "void", METHOD_NAME_$INITIALIZE_03_FINALIZE_CREATE_COMPONENTS, body.toString(), javaFile.isSuperclassIsJAXXObject(), new JavaArgument[0]);
        javaFile.addMethod(method);
    }

    protected void addInitialize_04_applyDataBindings(JAXXCompiler compiler, JavaFile javaFile) {
        StringBuilder body = new StringBuilder();
        String eol = JAXXCompiler.getLineSeparator();
        body.append(JavaFileGenerator.addDebugLoggerInvocation(compiler, "this"));
        if (javaFile.isSuperclassIsJAXXObject()) {
            body.append(String.format("super.%s();", METHOD_NAME_$INITIALIZE_04_APPLY_DATA_BINDINGS)).append(eol);
        } else {
            DataBinding[] bindings = compiler.getBindingHelper().getDataBindings();
            if (bindings.length > 0) {
                body.append(eol);
                body.append("// apply ");
                body.append(bindings.length);
                body.append(" data bindings");
                body.append(eol);
                body.append(JAXXUtil.class.getSimpleName());
                body.append(".applyDataBinding(this, $bindings.keySet());");
                body.append(eol);
            }
        }
        JavaMethod method = JavaElementFactory.newMethod(4, "void", METHOD_NAME_$INITIALIZE_04_APPLY_DATA_BINDINGS, body.toString(), javaFile.isSuperclassIsJAXXObject(), new JavaArgument[0]);
        javaFile.addMethod(method);
    }

    protected void addInitialize_05_setProperties(JAXXCompiler compiler, JavaFile javaFile) {
        DataBinding[] bindings;
        StringBuilder body = new StringBuilder();
        String eol = JAXXCompiler.getLineSeparator();
        body.append(JavaFileGenerator.addDebugLoggerInvocation(compiler, "this"));
        if (javaFile.isSuperclassIsJAXXObject()) {
            body.append(String.format("super.%s();", METHOD_NAME_$INITIALIZE_05_SET_PROPERTIES)).append(eol);
        }
        if ((bindings = compiler.getBindingHelper().getSimpleBindings()).length > 0) {
            StringBuilder initCode = new StringBuilder();
            for (DataBinding binding : bindings) {
                String binding1 = binding.getInitDataBinding();
                if (binding1 == null || binding1.trim().isEmpty()) continue;
                initCode.append(binding1);
            }
            if (initCode.length() > 0) {
                body.append(eol);
                body.append("// apply ");
                body.append(bindings.length);
                body.append(" property setters");
                body.append(eol);
                body.append(initCode.toString().trim());
            }
        }
        if (compiler.getLateInitializer().length() > 0) {
            body.append("// late initializer").append(eol);
            body.append((CharSequence)compiler.getLateInitializer()).append(eol);
        }
        JavaMethod method = JavaElementFactory.newMethod(4, "void", METHOD_NAME_$INITIALIZE_05_SET_PROPERTIES, body.toString(), javaFile.isSuperclassIsJAXXObject(), new JavaArgument[0]);
        javaFile.addMethod(method);
    }

    protected void addInitialize_06_finalizeInitialize(JAXXCompiler compiler, JavaFile javaFile) {
        StringBuilder body = new StringBuilder();
        body.append(JavaFileGenerator.addDebugLoggerInvocation(compiler, "this"));
        String eol = JAXXCompiler.getLineSeparator();
        if (javaFile.isSuperclassIsJAXXObject()) {
            body.append(String.format("super.%s();", METHOD_NAME_$INITIALIZE_06_FINALIZE_INITIALIZE)).append(eol);
        }
        JavaMethod method = JavaElementFactory.newMethod(4, "void", METHOD_NAME_$INITIALIZE_06_FINALIZE_INITIALIZE, body.toString(), javaFile.isSuperclassIsJAXXObject(), new JavaArgument[0]);
        javaFile.addMethod(method);
    }

    protected void addEventHandlers(JAXXCompiler compiler, JavaFile javaFile) {
        for (Map.Entry<String, Map<ClassDescriptor, List<EventHandler>>> e1 : compiler.getEventHandlers().entrySet()) {
            for (Map.Entry<ClassDescriptor, List<EventHandler>> e2 : e1.getValue().entrySet()) {
                for (EventHandler handler : e2.getValue()) {
                    String methodName = compiler.getEventHandlerMethodName(handler);
                    MethodDescriptor listenerMethod = handler.getListenerMethod();
                    if (listenerMethod.getParameterTypes().length != 1) {
                        throw new CompilerException("Expected event handler " + listenerMethod.getName() + " of class " + handler.getListenerClass() + " to have exactly one argument");
                    }
                    ClassDescriptor eventType = listenerMethod.getParameterTypes()[0];
                    JavaArgument argument = JavaElementFactory.newArgument(JAXXCompiler.getCanonicalName(eventType), "event");
                    Object body = JavaFileGenerator.addDebugLoggerInvocation(compiler, "event");
                    body = (String)body + handler.getJavaCode();
                    javaFile.addMethod(JavaElementFactory.newMethod(1, "void", methodName, (String)body, false, argument));
                }
            }
        }
    }

    public void addInitializerMethod(JAXXCompiler compiler, JavaFile javaFile) {
        String eol = JAXXCompiler.getLineSeparator();
        StringBuilder code = new StringBuilder();
        code.append(JavaFileGenerator.addDebugLoggerInvocation(compiler, "this"));
        code.append(compiler.getRootObject().getId()).append(" = this;").append(eol);
        if (javaFile.isSuperclassIsJAXXObject()) {
            code.append("super.$initialize();").append(eol);
        } else {
            code.append(String.format(METHOD_$INITIALIZER_CALL, eol, METHOD_NAME_$INITIALIZE_01_CREATE_HANDLER, METHOD_NAME_$INITIALIZE_01_CREATE_COMPONENTS, METHOD_NAME_$INITIALIZE_02_REGISTER_DATA_BINDINGS, METHOD_NAME_$INITIALIZE_03_FINALIZE_CREATE_COMPONENTS, METHOD_NAME_$INITIALIZE_03_REGISTER_ACTIONS, METHOD_NAME_$INITIALIZE_04_APPLY_DATA_BINDINGS, METHOD_NAME_$INITIALIZE_05_SET_PROPERTIES, METHOD_NAME_$INITIALIZE_06_FINALIZE_INITIALIZE));
        }
        JavaMethod method = JavaElementFactory.newMethod(4, "void", METHOD_NAME_$INITIALIZE, code.toString(), javaFile.isSuperclassIsJAXXObject(), new JavaArgument[0]);
        javaFile.addMethod(method);
    }

    protected JavaMethod createApplyDataBindingMethod() {
        StringBuilder buffer = new StringBuilder();
        String eol = JAXXCompiler.getLineSeparator();
        buffer.append("if ($bindings.containsKey($binding)) {");
        buffer.append(eol);
        buffer.append("    getDataBinding($binding).applyDataBinding();");
        buffer.append(eol);
        buffer.append("}");
        buffer.append(eol);
        buffer.append("processDataBinding($binding);");
        return JavaElementFactory.newMethod(1, "void", METHOD_NAME_APPLY_DATA_BINDING, buffer.toString(), true, JavaElementFactory.newArgument("String", PARAMETER_NAME_$BINDING));
    }

    protected JavaMethod createRemoveDataBindingMethod() {
        StringBuilder buffer = new StringBuilder();
        String eol = JAXXCompiler.getLineSeparator();
        buffer.append("if ($bindings.containsKey($binding)) {");
        buffer.append(eol);
        buffer.append("    getDataBinding($binding).removeDataBinding();");
        buffer.append(eol);
        buffer.append("}");
        return JavaElementFactory.newMethod(1, "void", METHOD_NAME_REMOVE_DATA_BINDING, buffer.toString(), true, JavaElementFactory.newArgument("String", PARAMETER_NAME_$BINDING));
    }

    protected JavaMethod createProcessDataBindingMethod() {
        StringBuilder code = new StringBuilder();
        String eol = JAXXCompiler.getLineSeparator();
        code.append("    if (!$force && $activeBindings.contains($binding)) { ");
        code.append(eol);
        code.append("    return;");
        code.append(eol);
        code.append("}").append(eol);
        code.append("$activeBindings.add($binding);");
        code.append(eol);
        code.append("try {").append(eol);
        code.append("    if ($bindings.containsKey($binding)) {");
        code.append(eol);
        code.append("        getDataBinding($binding).processDataBinding();");
        code.append(eol);
        code.append("    }").append(eol);
        code.append("} finally {").append(eol);
        code.append("    $activeBindings.remove($binding);");
        code.append(eol);
        code.append("}").append(eol);
        return JavaElementFactory.newMethod(1, "void", METHOD_NAME_PROCESS_DATA_BINDING, code.toString(), true, JavaElementFactory.newArgument("String", PARAMETER_NAME_$BINDING), JavaElementFactory.newArgument("boolean", "$force"));
    }
}

