package org.nuiton.jaxx.compiler;

/*-
 * #%L
 * JAXX :: Compiler
 * %%
 * Copyright (C) 2008 - 2023 Code Lutin, Ultreia.io
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

/**
 * Represents a bean scope detected on a compiled object.
 *
 * Created on 31/01/19.
 *
 * @author Tony Chemit - dev@tchemit.fr
 * @since 3
 */
public class BeanScope {

    private final String beanScope;

    private final CompiledObject compiledObject;

    public BeanScope(String beanScope, CompiledObject compiledObject) {
        this.beanScope = beanScope;
        this.compiledObject = compiledObject;
    }

    public String getBeanScope() {
        return beanScope;
    }

    public CompiledObject getCompiledObject() {
        return compiledObject;
    }

    @Override
    public String toString() {
        return "BeanScope{" + compiledObject.getId() + " → " + beanScope + '}';
    }
}
