/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.compiler;

import com.google.common.collect.ImmutableSet;
import io.ultreia.java4all.i18n.I18n;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.CharUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuiton.jaxx.compiler.CompiledObject;
import org.nuiton.jaxx.compiler.JAXXCompiler;
import org.nuiton.jaxx.compiler.reflect.ClassDescriptor;
import org.nuiton.jaxx.runtime.swing.SwingUtil;

public class I18nHelper {
    protected static final Logger log = LogManager.getLogger(I18nHelper.class);
    public static final List<String> I18N_ATTRIBUTES = Arrays.asList("text", "title", "label", "toolTipText", "resetTip", "openLinkTip", "labelText", "infoLabelTip");
    private static final Set<String> DOUBLE_LIST_TYPES = ImmutableSet.of((Object)"io.ultreia.java4all.jaxx.widgets.list.DoubleList", (Object)"org.nuiton.jaxx.widgets.select.FilterableDoubleList", (Object)"org.nuiton.jaxx.widgets.extension.editor.ReferentialDoubleListBeanEditor");

    public static boolean isI18nableAttribute(String attributeName, JAXXCompiler compiler) {
        return compiler.getConfiguration().isI18nable() && I18nHelper.isI18nAttribute(attributeName);
    }

    public static boolean isI18nAttribute(String attributeName) {
        return I18N_ATTRIBUTES.contains(attributeName);
    }

    public static String addI18nInvocation(String widgetId, String attributeName, String attributeValueCode, JAXXCompiler compiler) {
        if (log.isDebugEnabled()) {
            log.debug(" try i18n support for [" + widgetId + ":" + attributeName + "] : " + (String)attributeValueCode);
        }
        boolean doWarn = false;
        int indexOf = ((String)attributeValueCode).indexOf("t(");
        if (indexOf > -1 && !((String)attributeValueCode).contains(",")) {
            char charBefore;
            doWarn = indexOf == 0 ? true : !CharUtils.isAsciiAlphanumeric((char)(charBefore = ((String)attributeValueCode).charAt(indexOf - 1)));
        }
        if (doWarn) {
            compiler.reportWarning("\n\tjaxx supports i18n, no need to add explicit call to I18n.t for attribute '" + attributeName + "' in component '" + widgetId + "' : [" + (String)attributeValueCode + "]");
        } else {
            if (((String)attributeValueCode).contains("(")) {
                return attributeValueCode;
            }
            compiler.addImport("static " + I18n.class.getName() + ".t");
            compiler.getEngine().registerI18nKey(((String)attributeValueCode).replaceAll("\"", ""));
            attributeValueCode = "t(" + (String)attributeValueCode + ")";
        }
        return attributeValueCode;
    }

    public static String addI18nMnemonicInvocation(CompiledObject object, String attributeName, String attributeValueCode, JAXXCompiler compiler) {
        String stringValue = I18nHelper.addI18nInvocation(object.getId(), attributeName, attributeValueCode, compiler);
        compiler.addImport(SwingUtil.class.getName());
        return "{" + SwingUtil.class.getSimpleName() + ".getFirstCharAt(" + stringValue + ",'Z')}";
    }

    public static void tryToRegisterI18nInvocation(JAXXCompiler compiler, String code) {
        int indexOf = code.indexOf("t(\"");
        if (indexOf == -1) {
            indexOf = code.indexOf("n(\"");
        }
        if (indexOf > -1) {
            char c;
            if (indexOf > 0 && (Character.isLetter(c = code.charAt(indexOf - 1)) || Character.isDigit(c))) {
                return;
            }
            int lastIndex = code.indexOf("\"", indexOf + 3);
            if (lastIndex > -1) {
                String i18nKey = code.substring(indexOf + 3, lastIndex);
                if (compiler.getEngine().isVerbose()) {
                    log.info(String.format("Detect i18n key: %s in %s", i18nKey, code));
                }
                compiler.getEngine().registerI18nKey(i18nKey);
            }
        }
    }

    public static boolean isDoubleList(ClassDescriptor object) {
        return DOUBLE_LIST_TYPES.contains(object.getName());
    }

    public static boolean isNewDoubleList(ClassDescriptor object) {
        return "io.ultreia.java4all.jaxx.widgets.list.DoubleList".equals(object.getName());
    }
}

